/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.renderers;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import oracle.dss.presutil.XMLWriter;
import oracle.dss.util.containers.Marker;
import oracle.dss.util.renderers.XMLRenderer;
import oracle.dss.util.renderers.utils.GradientUtils;
import oracle.dss.util.shapes.Container;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.DrawableObjectXMLGenerator;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.FillGradient;
import oracle.dss.util.shapes.FillPattern;
import oracle.dss.util.shapes.Stroke;

public class MDOXMLRenderer
extends XMLRenderer {
    protected String ELEM_PATH = "p";
    protected String ELEM_GRADIENT = "g";
    protected String ELEM_PATTERN = "pn";
    protected String ELEM_MARKERDEF = "markerDef";
    protected String ATTRIB_FILL = "f";
    protected String ATTRIB_FILLCOLOR = "fc";
    protected String ATTRIB_FILLGRADIENT = "fg";
    protected String ATTRIB_FILLPATTERN = "fp";
    protected String ATTRIB_BORDERCOLOR = "bc";
    protected String ATTRIB_LINEWIDTH = "lw";
    protected String ATTRIB_PATH = "p";
    protected String ATTRIB_DRAW = "d";
    protected String ATTRIB_CLIPPATH = "cp";
    protected String ATTRIB_STROKEWIDTH = "sw";
    protected String ATTRIB_STROKECAP = "sc";
    protected String ATTRIB_STROKEJOIN = "sj";
    protected String ATTRIB_STROKEMITERLIMIT = "sm";
    protected String ATTRIB_STROKETYPE = "st";
    private DefinitionManager m_def = new DefinitionManager();

    public MDOXMLRenderer(XMLWriter writer) {
        super(writer);
    }

    @Override
    public void defaultFillHandler(Fill fill, Shape shape) {
    }

    @Override
    public void defaultDrawableHandler(DrawableObject obj) {
        try {
            Shape shape = obj.getShape();
            AffineTransform at = obj.getTransform();
            if (at != null) {
                shape = at.createTransformedShape(shape);
            }
            if (shape == null) {
                return;
            }
            this.m_writer.startElement(this.ELEM_PATH);
            PathIterator pathIterator = shape.getPathIterator(null);
            int windingRule = -1;
            while (!pathIterator.isDone()) {
                double[] points = new double[6];
                windingRule = pathIterator.currentSegment(points);
                pathIterator.next();
            }
            Shape clipPath = obj.getClipPath();
            if (clipPath != null && windingRule == 4) {
                if (at != null) {
                    clipPath = at.createTransformedShape(clipPath);
                }
                Area area = new Area(shape);
                area.intersect(new Area(clipPath));
                shape = new GeneralPath();
                ((GeneralPath)shape).append(area.getPathIterator(null), false);
            }
            this.renderStroke(obj.getStroke(), at);
            this.renderFill(obj.getFill(), obj.getShape());
            this.m_writer.writeAttribute(this.ATTRIB_DRAW, DrawableObjectXMLGenerator.generateXMLFromShape(shape));
            this.m_writer.endElement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void drawShape(DrawableObject obj) {
        this.m_def = new DefinitionManager();
        super.drawShape(obj);
    }

    @Override
    public void preDrawShape(DrawableObject obj) {
    }

    @Override
    public void postDrawShape(DrawableObject obj) {
        this.m_def.writeDefinitions(this.m_writer);
    }

    @Override
    protected void handleContainer(Container obj) {
        try {
            if (obj instanceof Marker) {
                this.m_writer.startElement(this.ELEM_MARKERDEF);
                this.m_writer.writeAttribute(ATTRIB_ID, obj.getID());
                Marker marker = (Marker)obj;
                Rectangle2D dim = marker.getBounds();
                if (dim != null) {
                    this.m_writer.writeAttribute("dx", dim.getX());
                    this.m_writer.writeAttribute("dy", dim.getY());
                    this.m_writer.writeAttribute("dw", dim.getWidth());
                    this.m_writer.writeAttribute("dh", dim.getHeight());
                }
            }
            super.handleContainer(obj);
            if (obj instanceof Marker) {
                this.m_writer.endElement();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleFill(FillColor fill, Shape shape) throws Exception {
        this.m_writer.writeAttribute(this.ATTRIB_FILLCOLOR, XMLWriter.colorToHexWithAlpha(fill.getColor()));
    }

    public void handleFill(FillPattern fill, Shape shape) throws Exception {
        String id = fill.getID();
        this.m_writer.writeAttribute(this.ATTRIB_FILLPATTERN, id);
        StringWriter sw = new StringWriter();
        XMLWriter patternWriter = new XMLWriter(sw, null);
        patternWriter.startElement(this.ELEM_PATTERN);
        patternWriter.writeAttribute(ATTRIB_ID, id);
        this._generateImmediateXML(fill, patternWriter);
        patternWriter.endElement();
        patternWriter.flush();
        this.m_def.put(id, sw.toString());
    }

    public void handleFill(FillGradient fill, Shape shape) throws Exception {
        String id = String.valueOf(fill.hashCode());
        this.m_writer.writeAttribute(this.ATTRIB_FILLGRADIENT, id);
        StringWriter sw = new StringWriter();
        XMLWriter gradientWriter = new XMLWriter(sw, null);
        GradientUtils.writeGradientElement(fill.getGradientObj(), shape.getBounds(), this.ELEM_GRADIENT, id, gradientWriter);
        gradientWriter.flush();
        this.m_def.put(id, sw.toString());
    }

    @Override
    public void renderStroke(Stroke stroke, AffineTransform transform) {
        float scaleX;
        if (stroke == null) {
            return;
        }
        float width = stroke.getWidth();
        if (transform != null && (scaleX = (float)transform.getScaleX()) != 1.0f) {
            width *= scaleX;
        }
        try {
            int nWidth;
            if (stroke.getColor() != null) {
                this.m_writer.writeAttribute(this.ATTRIB_BORDERCOLOR, XMLWriter.colorToHexWithAlpha(stroke.getColor()));
            }
            if ((nWidth = Math.round(width)) != (int)Stroke.DEFAULT_WIDTH) {
                this.m_writer.writeAttribute(this.ATTRIB_LINEWIDTH, nWidth);
            }
            if (stroke.getCap() != Stroke.DEFAULT_CAP) {
                this.m_writer.writeAttribute(this.ATTRIB_STROKECAP, stroke.getCap());
            }
            if (stroke.getJoin() != Stroke.DEFAULT_JOIN) {
                this.m_writer.writeAttribute(this.ATTRIB_STROKEJOIN, stroke.getJoin());
            }
            if (stroke.getMiterLimit() != Stroke.DEFAULT_MITERLIMIT) {
                this.m_writer.writeAttribute(this.ATTRIB_STROKEMITERLIMIT, (int)stroke.getMiterLimit());
            }
            if (stroke.getDash() != null) {
                this.m_writer.writeAttribute(this.ATTRIB_STROKETYPE, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected class DefinitionManager
    extends HashMap {
        private static final long serialVersionUID = 1L;
        protected String ELEM_FILLDEF = "fillDef";

        protected DefinitionManager() {
        }

        @Override
        public void put(String id, String def) {
            if (this.containsKey(id)) {
                return;
            }
            super.put(id, def);
        }

        public void writeDefinitions(XMLWriter writer) {
            if (this.size() <= 0) {
                return;
            }
            try {
                writer.startElement(this.ELEM_FILLDEF);
                for (Map.Entry def : this.entrySet()) {
                    try {
                        writer.writeText("");
                        writer.write((String)def.getValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                writer.endElement();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

