/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.shared.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.legend.shared.LegendItem;
import oracle.dss.legend.shared.util.LegendUtils;
import oracle.dss.legend.shared.visit.LegendVisitContext;
import oracle.dss.legend.shared.visit.LegendVisitor;
import oracle.dss.presutil.FontMetricsResolver;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.Label;
import oracle.dss.util.shapes.Rectangle;
import oracle.dss.util.shapes.Stroke;

public abstract class LegendText
extends LegendItem {
    protected String m_text;
    private String m_displayText;
    protected List<String> m_lineText = new ArrayList<String>();
    protected Color m_fontColor = null;
    protected Font m_font = null;
    protected int m_lines = 1;
    protected int m_maxLines = -1;
    private boolean m_truncated = false;

    public LegendText(String text) {
        this.m_text = text;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LegendText)) {
            return false;
        }
        LegendText other = (LegendText)object;
        return this.m_text != null ? this.m_text.equals(other.m_text) : other.m_text == null;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this.m_text == null ? 0 : this.m_text.hashCode());
        return result;
    }

    @Override
    public void internalAccept(LegendVisitor visitor, LegendVisitContext context) {
        visitor.visit(this, context);
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
    }

    public Font getFont() {
        Font font = this.getDefaultFont();
        if (this.m_font != null) {
            font = this.m_font;
        }
        return font;
    }

    public Color getTextColor() {
        Color color = this.getDefaultTextColor();
        if (this.m_fontColor != null) {
            color = this.m_fontColor;
        }
        return color;
    }

    public abstract Color getDefaultTextColor();

    public abstract Font getDefaultFont();

    @Override
    public List<DrawableObject> render() {
        FontMetrics fm = this.m_settings.getFontMetrics(this.getFont());
        boolean noWrap = this.m_settings.getStyles().isNoWrap();
        if (noWrap) {
            this.setMaxlines(1);
        } else {
            this.setMaxlines(Integer.MAX_VALUE);
        }
        ArrayList<DrawableObject> item = new ArrayList<DrawableObject>();
        if (this.getInstanceBorder() != null) {
            Rectangle bounds = new Rectangle(this.m_x, this.m_y, this.m_width, this.m_height);
            bounds.setStroke(this.getInstanceBorder());
            item.add(bounds);
        }
        int currY = this.m_y;
        int lineHeight = fm.getHeight();
        boolean isBidi = this.m_settings.isBidi();
        if (this.m_settings.isBidi()) {
            this.m_x += this.m_width;
        }
        for (String text : this.m_lineText) {
            Label label = new Label(text, (double)this.m_x, (double)currY, (double)this.m_width, lineHeight);
            if (isBidi) {
                int textWidth = this.m_settings.getStringWidth(this.getFont(), text);
                label = new Label(text, (double)(this.m_x - textWidth), (double)currY, (double)this.m_width, lineHeight);
            }
            label.setFont(this.getFont());
            label.setFontColor(this.getTextColor());
            label.setFill(new FillColor(new Color(0, 0, 0, 0)));
            if (this.m_truncated) {
                label.setAltText(this.m_text);
            }
            item.add(label);
            currY += lineHeight;
        }
        return item;
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    @Override
    public void calc() {
        boolean noWrap = this.m_settings.getStyles().isNoWrap();
        if (noWrap) {
            this.setMaxlines(1);
        } else {
            this.setMaxlines(Integer.MAX_VALUE);
        }
        FontMetrics fm = this.m_settings.getFontMetrics(this.getFont());
        int fontHeight = fm.getHeight();
        int actualWidth = this.m_settings.getStringWidth(this.getFont(), this.m_text);
        this.m_width = Math.min(actualWidth, this.m_width);
        this.formatText(this.m_maxLines);
        this.m_height = fontHeight * this.m_lines;
        int stringMaxWidth = Integer.MIN_VALUE;
        for (String text : this.m_lineText) {
            stringMaxWidth = Math.max(this.m_settings.getStringWidth(this.getFont(), text), stringMaxWidth);
        }
        this.m_width = stringMaxWidth;
    }

    @Override
    public void calcFinal() {
        this.formatText(this.m_maxLines);
    }

    private void formatText(int maxLines) {
        this.m_lineText.clear();
        LegendUtils.TextWrapper wrapper = new LegendUtils.TextWrapper(this.m_settings.getLocale());
        FontMetrics fm = this.m_settings.getFontMetrics(this.getFont());
        wrapper.extractLinesWordWrap(this.m_text, this.m_lineText, this.m_width, fm, new FontMetricsResolver(), maxLines);
        this.m_lines = this.m_lineText.size();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (i = 0; i < this.m_lineText.size(); ++i) {
            String line = this.m_lineText.get(i);
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(line);
        }
        this.m_displayText = sb.toString();
    }

    public int getLines() {
        return this.m_lines;
    }

    public void setMaxlines(int m_maxlines) {
        this.m_maxLines = m_maxlines;
    }

    public int getMaxlines() {
        return this.m_maxLines;
    }

    public void setDisplayText(String m_displayText) {
        this.m_displayText = m_displayText;
    }

    public String getDisplayText() {
        return this.m_displayText;
    }

    public void setFontColor(Color fontColor) {
        this.m_fontColor = fontColor;
    }

    public Color getFontColor() {
        return this.m_fontColor;
    }

    @Override
    public Fill getDefaultFill() {
        return null;
    }

    @Override
    public Stroke getDefaultBorder() {
        return null;
    }
}

