/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.impl;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.legend.LegendItem;
import oracle.dss.legend.impl.LegendContext;
import oracle.dss.legend.shared.util.LegendUtils;
import oracle.dss.presutil.FontMetricsResolver;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Label;
import oracle.dss.util.shapes.Rectangle;

public class LegendText
extends LegendItem {
    protected String m_text;
    private String m_displayText;
    protected Font m_font;
    protected int m_lines = 1;
    private FontMetrics fm;
    private FontMetricsResolver fmr;
    private boolean m_bTruncated = false;

    public LegendText(String text) {
        this.m_text = text != null ? text : "";
    }

    @Override
    public List<DrawableObject> render() {
        ArrayList<DrawableObject> item = new ArrayList<DrawableObject>();
        if (this.m_border != null) {
            Rectangle bounds = new Rectangle(this.m_x, this.m_y, this.m_width, this.m_height);
            bounds.setStroke(this.m_border);
            item.add(bounds);
        }
        Label label = new Label(this.m_displayText, (double)this.m_x, (double)this.m_y, (double)this.m_width, this.m_height);
        label.setFont(this.m_font);
        label.setProperty(LEGEND_ID_KEY, this.m_id);
        if (this.m_bTruncated) {
            label.setAltText(this.m_text);
        }
        item.add(label);
        return item;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.m_font = font;
        }
    }

    @Override
    public void calc() {
        Font font = this.m_font != null ? this.m_font : LegendContext.getContext().getFont();
        this.fm = LegendContext.getContext().getGraphics().getFontMetrics(font);
        this.fmr = new FontMetricsResolver();
        int actualWidth = this.fmr.stringWidth(this.m_text, this.fm);
        this.m_width = Math.min(actualWidth, this.m_width);
        int fontHeight = this.fm.getHeight();
        this.formatText(-1);
        this.m_height = fontHeight * this.m_lines;
    }

    @Override
    public void calcFinal() {
        Font font = this.m_font != null ? this.m_font : LegendContext.getContext().getFont();
        FontMetrics fm = LegendContext.getContext().getGraphics().getFontMetrics(font);
        int fontHeight = fm.getHeight();
        int newLines = this.m_height / fontHeight;
        this.formatText(newLines);
    }

    private void formatText(int maxLines) {
        Font font = this.m_font != null ? this.m_font : LegendContext.getContext().getFont();
        LegendUtils.TextWrapper wrapper = new LegendUtils.TextWrapper(this.m_locale);
        ArrayList lines = new ArrayList();
        wrapper.extractLinesWordWrap(this.m_text, lines, this.m_width, this.fm, this.fmr, maxLines);
        this.m_bTruncated = wrapper.isTruncated();
        this.m_lines = lines.size();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(line);
        }
        this.m_displayText = sb.toString();
    }

    public int getLines() {
        return this.m_lines;
    }
}

