/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.GraphSVGWriter;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.MathExt;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.math.FP;

public class DetPolyline
extends DetObj {
    private static final long serialVersionUID = 1L;
    protected static final int SLOP_FACTOR = 40;
    public static final int THIN_LINE = 0;
    protected Point[] m_points;
    protected Polygon m_polyLine;
    protected int m_nLineWidth;
    protected int m_lineStyle = Perspective.SOLID;
    protected boolean m_isMarker = false;
    protected boolean m_is3D = false;
    Rectangle m_clipRect;

    public DetPolyline(Detectiv m_Detectiv, IdentObj id, List points, BlackBoxIF blackBox, Rectangle clipRect, int nLineWidth) {
        super(m_Detectiv, id, blackBox, false, true, true);
        this.m_clipRect = clipRect;
        int np = points.size();
        this.m_points = new Point[np];
        for (int i = 0; i < np; ++i) {
            this.m_points[i] = (Point)points.get(i);
        }
        this.m_nLineWidth = nLineWidth;
        if (this.m_nLineWidth != 0) {
            this.m_blackBox.setFillColor(this.m_blackBox.getBorderColor());
            this.m_blackBox.setTransparentFillColor(this.m_blackBox.getTransparentBorderColor());
        }
        if (id.getObjectID() == 504) {
            this.m_isMarker = true;
        } else if (id.getObjectID() == 13) {
            this.setVisualEffectsMap(JChart_2D.getLineEffectsMap(nLineWidth, true));
        } else if (id.getObjectID() == 258) {
            this.setVisualEffectsMap(JChart_2D.getLineEffectsMap(nLineWidth, false));
        }
    }

    public DetPolyline(Detectiv m_Detectiv, IdentObj id, List points, BlackBoxIF blackBox, Rectangle clipRect, int nLineWidth, int nLineStyle, boolean is3D) {
        this(m_Detectiv, id, points, blackBox, clipRect, nLineWidth);
        this.m_lineStyle = nLineStyle;
        this.m_is3D = is3D;
    }

    public DetPolyline(Detectiv m_Detectiv, IdentObj id, List points, BlackBoxIF blackBox, Rectangle clipRect, int nLineWidth, int nLineStyle, boolean is3D, List groups) {
        this(m_Detectiv, id, points, blackBox, clipRect, nLineWidth, nLineStyle, is3D);
        this.m_groups = groups;
    }

    public DetPolyline(Detectiv m_Detectiv, IdentObj id, List points, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable) {
        this(m_Detectiv, id, points, blackBox, clipRect, bMoveable, bDetectable, 0);
    }

    public DetPolyline(Detectiv m_Detectiv, IdentObj id, List points, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, int nLineWidth) {
        super(m_Detectiv, id, blackBox, bMoveable, bDetectable, true);
        this.m_clipRect = clipRect;
        int np = points.size();
        this.m_points = new Point[np];
        for (int i = 0; i < np; ++i) {
            this.m_points[i] = (Point)points.get(i);
        }
        this.m_nLineWidth = nLineWidth;
        if (this.m_nLineWidth != 0) {
            this.m_blackBox.setFillColor(this.m_blackBox.getBorderColor());
            this.m_blackBox.setTransparentFillColor(this.m_blackBox.getTransparentBorderColor());
        }
        if (id.getObjectID() == 504) {
            this.m_isMarker = true;
        } else if (id.getObjectID() == 13) {
            this.setVisualEffectsMap(JChart_2D.getLineEffectsMap(nLineWidth, true));
        } else if (id.getObjectID() == 258) {
            this.setVisualEffectsMap(JChart_2D.getLineEffectsMap(nLineWidth, false));
        }
    }

    public DetPolyline(Detectiv m_Detectiv, IdentObj id, List points, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, int nLineWidth, int nLineStyle) {
        this(m_Detectiv, id, points, blackBox, clipRect, bMoveable, bDetectable, nLineWidth);
        this.m_lineStyle = nLineStyle;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetPolyline)) {
            return false;
        }
        DetPolyline detLine = (DetPolyline)obj;
        return this.m_id.equals(detLine.m_id);
    }

    public Point getBeginPoint() {
        return this.m_points[0];
    }

    public Point getEndPoint() {
        int size = this.m_points.length - 1;
        return this.m_points[size];
    }

    public Point[] getAllPoints() {
        return this.m_points;
    }

    @Override
    public Rectangle getBounds() {
        return this.getShape(null).getBounds();
    }

    @Override
    public void hilite(Graphics g, VC vc) {
        int np = this.m_points.length;
        int[] x = new int[np];
        int[] y = new int[np];
        for (int i = 0; i < np; ++i) {
            Point pt = vc.virtToDest(this.m_points[i]);
            x[i] = pt.x;
            y[i] = pt.y;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        g2.setXORMode(Color.yellow);
        g2.drawPolyline(x, y, np);
        g2.setPaintMode();
    }

    @Override
    public boolean isPointInObj(int x, int y, VC vc) {
        if (!this.m_bDetectable) {
            return false;
        }
        for (int i = 0; i < this.m_points.length - 1; ++i) {
            Polygon p = this.calcLine(this.m_points[i], this.m_points[i + 1], Math.max(this.m_nLineWidth, 5), vc, false);
            if (!p.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    @Override
    public void paintIt(Graphics g, VC vc) {
        Shape savedClip = null;
        if (this.m_clipRect != null) {
            Rectangle rClip = vc.virtToDest(this.m_clipRect);
            ++rClip.height;
            savedClip = g.getClip();
            g.setClip(rClip);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.01f, 1, 1));
        Point[] newP = new Point[this.m_points.length];
        for (int i = 0; i < this.m_points.length; ++i) {
            newP[i] = vc.virtToDest(this.m_points[i]);
        }
        switch (this.m_nLineWidth) {
            case 0: 
            case 1: {
                this.m_blackBox.paint((Graphics)g2, newP, 1, this.m_lineStyle, this.m_isMarker, this.m_is3D);
                break;
            }
            default: {
                this.m_blackBox.paint((Graphics)g2, newP, this.m_nLineWidth, this.m_lineStyle, this.m_isMarker, this.m_is3D);
            }
        }
        if (this.m_clipRect != null) {
            g.setClip(savedClip);
        }
    }

    @Override
    public void renderItToSVG(Map context) throws IOException, Exception {
        int i;
        String onMouseOutJS;
        String onMouseOverJS;
        boolean bOnMouseOverOutPresent;
        boolean bOnClickPresent;
        GraphSVGWriter writer = (GraphSVGWriter)context.get("svgWriter");
        VC vc = (VC)context.get("svgVC");
        int mode = (Integer)context.get("svgMode");
        boolean bTooltips = (mode & 2) != 0;
        String[] tooltipsArray = null;
        if (bTooltips) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        boolean bShapeAttributes = (mode & 0x10) != 0;
        String clickEventJS = null;
        boolean bl = bOnClickPresent = bShapeAttributes && writer.isOnClickPresent();
        if (bShapeAttributes && !bOnClickPresent) {
            clickEventJS = writer.getClickEventJS();
        }
        boolean bl2 = bOnMouseOverOutPresent = bShapeAttributes && writer.isOnMouseOverOutPresent();
        if (bOnMouseOverOutPresent) {
            bTooltips = false;
        }
        String saAlt = null;
        String saTitle = null;
        String saHRef = null;
        String saTarget = null;
        if (bShapeAttributes) {
            saAlt = writer.getShapeAttributesAlt();
            saTitle = writer.getShapeAttributesTitle();
            if (!bOnClickPresent) {
                saHRef = writer.getShapeAttributesHRef();
            }
            saTarget = writer.getShapeAttributesTarget();
        }
        boolean bDrilling = (mode & 4) != 0;
        bDrilling = bDrilling && !bOnClickPresent && clickEventJS == null;
        String drillJS = null;
        if (bDrilling && ((drillJS = writer.getDrillJS(this)) == null || drillJS.length() < 1)) {
            bDrilling = false;
        }
        if (bTooltips) {
            if (saAlt != null) {
                tooltipsArray = new String[]{saAlt};
            } else if (saTitle != null) {
                tooltipsArray = new String[]{saTitle};
            }
        }
        if (bDrilling && bTooltips && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        bTooltips = bTooltips && tooltipsArray != null && tooltipsArray.length > 0;
        boolean lineSelectPoint = this.m_Detectiv.getPerspective().getJGraphType().isLineSelectPoint() && this.m_id.getObjectID() == 258;
        boolean bStartA = bDrilling || bOnClickPresent || clickEventJS != null || saHRef != null || lineSelectPoint;
        boolean bAnchorGroup = false;
        if (bStartA) {
            writer.startElement("a");
            String href = "";
            if (clickEventJS == null && !bDrilling && saHRef != null) {
                href = saHRef;
            }
            writer.writeAttribute("xlink:href", href);
            if (saTarget != null) {
                writer.writeAttribute("target", saTarget);
            }
            String strOnclick = null;
            if (lineSelectPoint) {
                strOnclick = writer.getLineSelectPointClickJS();
            } else if (clickEventJS != null) {
                strOnclick = clickEventJS;
            } else if (bDrilling) {
                strOnclick = drillJS;
            }
            if (strOnclick != null) {
                bAnchorGroup = true;
                writer.startElement("g");
                writer.writeAttribute("onclick", strOnclick);
            }
        }
        writer.startElement("g");
        if (bShapeAttributes) {
            writer.writeShapeAttributes();
        }
        if (bTooltips) {
            int rbMode;
            List l;
            onMouseOverJS = null;
            onMouseOutJS = null;
            int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
            if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                context.put("svgHasReferenceObj", Boolean.TRUE);
                StringBuilder strBuf = new StringBuilder("evt,");
                for (i = 0; i < l.size() - 1; ++i) {
                    strBuf.append("'" + (String)l.get(i) + "',");
                }
                strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                onMouseOverJS = "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                onMouseOutJS = "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
            }
            if ((rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior)) != 0) {
                String shfOver = new String("bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');");
                String shfOut = new String("bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');");
                onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
            }
            boolean shfOver = writer.writeTooltip(tooltipsArray, onMouseOverJS, onMouseOutJS);
        } else {
            List l;
            int graphID;
            onMouseOverJS = null;
            onMouseOutJS = null;
            int rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior);
            if (rbMode != 0 && this.m_id.isSeriesRelated()) {
                String shfOver = new String("bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');");
                String shfOut = new String("bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');");
                onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
            }
            if ((graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID())) != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                context.put("svgHasReferenceObj", Boolean.TRUE);
                StringBuilder strBuf = new StringBuilder("evt,");
                for (int i2 = 0; i2 < l.size() - 1; ++i2) {
                    strBuf.append("'" + (String)l.get(i2) + "',");
                }
                strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                onMouseOverJS = onMouseOverJS == null ? "bi_refObj_show_mOver(" + strBuf.toString() + ");" : onMouseOverJS + "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                onMouseOutJS = onMouseOutJS == null ? "bi_refObj_hide_mOut(" + strBuf.toString() + ");" : "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
            }
            if (onMouseOverJS != null) {
                writer.writeAttribute("onmouseover", onMouseOverJS);
            }
            if (onMouseOutJS != null) {
                writer.writeAttribute("onmouseout", onMouseOutJS);
            }
            if (saTitle != null) {
                writer.writeTitleElement(saTitle);
            }
        }
        Point[] destPoints = new Point[this.m_points.length];
        for (int i3 = 0; i3 < this.m_points.length; ++i3) {
            destPoints[i3] = vc.virtToDest(this.m_points[i3]);
        }
        Point[] shadowPoints = null;
        int shadowWidth = this.m_nLineWidth;
        if (this.m_is3D) {
            shadowWidth = shadowWidth % 2 == 0 ? shadowWidth++ : shadowWidth;
            int shadowX = shadowWidth <= 2 ? 1 : 2;
            shadowX = shadowWidth == 1 ? 0 : shadowX;
            int shadowY = shadowWidth / 2 + 1;
            shadowPoints = new Point[destPoints.length];
            for (i = 0; i < destPoints.length; ++i) {
                shadowPoints[i] = new Point(destPoints[i].x + shadowX, destPoints[i].y - shadowY);
            }
        }
        String sPlotAreaClip = (String)context.get("svgPlotAreaClip");
        if (this.m_clipRect != null && sPlotAreaClip == null) {
            Rectangle rClip = vc.virtToDest(this.m_clipRect);
            writer.startElement("clipPath");
            String clipID = writer.getFilteredBeanName() + "_plotAreaClip";
            writer.writeAttribute("id", clipID);
            StringBuilder sb = new StringBuilder("url(#");
            sb.append(clipID);
            sb.append(")");
            sPlotAreaClip = sb.toString();
            context.put("svgPlotAreaClip", sPlotAreaClip);
            if (writer.startRectElement(rClip)) {
                writer.endElement();
            }
            writer.endElement();
        }
        switch (this.m_nLineWidth) {
            case 0: 
            case 1: {
                if (this.m_lineStyle == Perspective.SOLID) {
                    if (!writer.startElement(this.m_id, this.m_blackBox, destPoints)) break;
                    writer.endElement();
                    break;
                }
                if (this.m_is3D && writer.startElement(this.m_id, this.m_blackBox, shadowPoints, 1, this.m_lineStyle, this.m_isMarker, true)) {
                    writer.endElement();
                }
                if (!writer.startElement(this.m_id, this.m_blackBox, destPoints, 1, this.m_lineStyle, this.m_isMarker, false)) break;
                writer.endElement();
                break;
            }
            default: {
                if (this.m_is3D && writer.startElement(this.m_id, this.m_blackBox, shadowPoints, shadowWidth, this.m_lineStyle, this.m_isMarker, true)) {
                    writer.endElement();
                }
                if (!writer.startElement(this.m_id, this.m_blackBox, destPoints, this.m_nLineWidth, this.m_lineStyle, this.m_isMarker, false)) break;
                if (sPlotAreaClip != null) {
                    writer.writeAttribute("clip-path", sPlotAreaClip);
                }
                writer.endElement();
            }
        }
        writer.endElement();
        if (bStartA) {
            if (bAnchorGroup) {
                writer.endElement();
            }
            writer.endElement();
        }
        this.m_polyLine = null;
    }

    @Override
    public void renderItToXML(Map context) throws IOException, Exception {
        String drillJS;
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        VC vc = (VC)context.get("xmlVC");
        String[] tooltipsArray = null;
        boolean bTooltipTemplate = writer.useTooltipTemplate(this.m_id);
        if (!bTooltipTemplate) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        boolean bDrilling = (drillJS = writer.getDrillJS(this)) != null && drillJS.length() > 0;
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = this.m_Detectiv.getPerspective().getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        if (bDrilling && !bTooltipTemplate && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        boolean bTooltips = tooltipsArray != null && tooltipsArray.length > 0;
        boolean lineSelectPoint = this.m_Detectiv.getPerspective().getJGraphType().isLineSelectPoint() && this.m_id.getObjectID() == 258;
        String lineSelectPointJS = null;
        if (lineSelectPoint) {
            lineSelectPointJS = writer.getLineSelectPointSubmitJS();
        }
        Point[] destPoints = new Point[this.m_points.length];
        for (int i = 0; i < this.m_points.length; ++i) {
            destPoints[i] = vc.virtToDest(this.m_points[i]);
        }
        Point[] shadowPoints = null;
        int shadowWidth = this.m_nLineWidth;
        if (this.m_is3D) {
            shadowWidth = shadowWidth % 2 == 0 ? shadowWidth++ : shadowWidth;
            int shadowX = shadowWidth <= 2 ? 1 : 2;
            shadowX = shadowWidth == 1 ? 0 : shadowX;
            int shadowY = shadowWidth / 2 + 1;
            shadowPoints = new Point[destPoints.length];
            for (int i = 0; i < destPoints.length; ++i) {
                shadowPoints[i] = new Point(destPoints[i].x + shadowX, destPoints[i].y - shadowY);
            }
        }
        String sPlotAreaClip = (String)context.get("xmlPlotAreaClip");
        if (this.m_clipRect != null && sPlotAreaClip == null) {
            Rectangle rClip = vc.virtToDest(this.m_clipRect);
            writer.startElement("clipPath");
            String clipID = "plotAreaClip";
            writer.writeAttribute("id", clipID);
            StringBuilder sb = new StringBuilder("(#");
            sb.append(clipID);
            sb.append(")");
            sPlotAreaClip = sb.toString();
            context.put("xmlPlotAreaClip", sPlotAreaClip);
            if (writer.startRectElement(rClip)) {
                writer.endElement();
            }
            writer.endElement();
        }
        switch (this.m_nLineWidth) {
            case 0: 
            case 1: {
                if (this.m_lineStyle == Perspective.SOLID) {
                    if (!writer.startElement(this.m_id, this.m_blackBox, destPoints)) break;
                    if (lineSelectPointJS != null) {
                        writer.writeAttribute("lspJS", lineSelectPointJS);
                    }
                    this.writeAdditionalXMLInfo(writer, bDrilling ? drillJS : null, bLink ? link : null, (String[])(bTooltips ? tooltipsArray : null));
                    writer.endElement();
                    break;
                }
                if (this.m_is3D && writer.startElement(this.m_id, this.m_blackBox, shadowPoints, 1, this.m_lineStyle, this.m_isMarker, true)) {
                    if (lineSelectPointJS != null) {
                        writer.writeAttribute("lspJS", lineSelectPointJS);
                    }
                    this.writeAdditionalXMLInfo(writer, bDrilling ? drillJS : null, bLink ? link : null, (String[])(bTooltips ? tooltipsArray : null));
                    writer.endElement();
                }
                if (!writer.startElement(this.m_id, this.m_blackBox, destPoints, 1, this.m_lineStyle, this.m_isMarker, false)) break;
                if (lineSelectPointJS != null) {
                    writer.writeAttribute("lspJS", lineSelectPointJS);
                }
                this.writeAdditionalXMLInfo(writer, bDrilling ? drillJS : null, bLink ? link : null, (String[])(bTooltips ? tooltipsArray : null));
                writer.endElement();
                break;
            }
            default: {
                if (this.m_is3D && writer.startElement(this.m_id, this.m_blackBox, shadowPoints, shadowWidth, this.m_lineStyle, this.m_isMarker, true)) {
                    if (lineSelectPointJS != null) {
                        writer.writeAttribute("lspJS", lineSelectPointJS);
                    }
                    this.writeAdditionalXMLInfo(writer, bDrilling ? drillJS : null, bLink ? link : null, (String[])(bTooltips ? tooltipsArray : null));
                    writer.endElement();
                }
                if (!writer.startElement(this.m_id, this.m_blackBox, destPoints, this.m_nLineWidth, this.m_lineStyle, this.m_isMarker, false)) break;
                if (lineSelectPointJS != null) {
                    writer.writeAttribute("lspJS", lineSelectPointJS);
                }
                if (sPlotAreaClip != null) {
                    writer.writeAttribute("clip", sPlotAreaClip);
                }
                this.writeAdditionalXMLInfo(writer, bDrilling ? drillJS : null, bLink ? link : null, (String[])(bTooltips ? tooltipsArray : null));
                writer.endElement();
            }
        }
        this.m_polyLine = null;
    }

    protected void writeAdditionalXMLInfo(GraphExportXMLWriter writer, String drillJS, String link, String[] tooltipsArray) throws IOException, Exception {
        if (drillJS != null && drillJS.length() > 0) {
            writer.writeAttribute("drillJs", drillJS);
        }
        if (link != null && link.length() > 0) {
            writer.writeAttribute("link", link);
        }
        if (!writer.hasAlt()) {
            if (tooltipsArray != null && tooltipsArray.length > 0) {
                writer.writeTooltipAttribute(tooltipsArray);
            } else if (!writer.useTooltipTemplate(this.m_id)) {
                writer.writeCachedAttribute("tt", "f", null);
            }
        }
        writer.writeVisualEffectsAttributes(this.m_visualEffectsMap);
        writer.writeCustomPropertyAttribute();
        writer.writeShapeAttributesElement();
        writer.writeFillChildren(this.m_id, this.m_blackBox);
        writer.writeBorderChildren(this.m_id, this.m_blackBox, null);
        int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
        if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2) {
            writer.writeReferenceObjectsElement(this.m_id);
        }
    }

    @Override
    public void setBounds(Rectangle rBounds) {
    }

    @Override
    public Polygon getShape(VC vc) {
        int length = 2 * this.m_points.length + 1;
        int[] pointsX = new int[length];
        int[] pointsY = new int[length];
        --length;
        int j = 0;
        for (int i = 0; i < this.m_points.length - 1; ++i) {
            Point pt0 = vc.virtToDest(this.m_points[i]);
            Point pt1 = vc.virtToDest(this.m_points[i + 1]);
            double dx = pt1.x - pt0.x;
            double dy = pt1.y - pt0.y;
            double fAngleDeg = Math.atan2(dy, dx) * 57.29577951308232;
            double angle = (fAngleDeg + 90.0) * (Math.PI / 180);
            int x0 = pt0.x + (int)Math.round((double)this.m_nLineWidth * Math.cos(angle));
            int y0 = pt0.y + (int)Math.round((double)this.m_nLineWidth * Math.sin(angle));
            if (i == 0) {
                pointsX[j] = x0;
                pointsY[j++] = y0;
            }
            pointsX[length] = x0;
            pointsY[length--] = y0;
            angle = (fAngleDeg + 270.0) * (Math.PI / 180);
            int x1 = pt0.x + (int)Math.round((double)this.m_nLineWidth * Math.cos(angle));
            int y1 = pt0.y + (int)Math.round((double)this.m_nLineWidth * Math.sin(angle));
            if (i == 0) {
                pointsX[j] = x1;
                pointsY[j++] = y1;
            }
            angle = (fAngleDeg - 90.0) * (Math.PI / 180);
            int x2 = pt1.x + (int)Math.round((double)this.m_nLineWidth * Math.cos(angle));
            int y2 = pt1.y + (int)Math.round((double)this.m_nLineWidth * Math.sin(angle));
            pointsX[j] = x2;
            pointsY[j++] = y2;
            angle = (fAngleDeg + 90.0) * (Math.PI / 180);
            int x3 = pt1.x + (int)Math.round((double)this.m_nLineWidth * Math.cos(angle));
            int y3 = pt1.y + (int)Math.round((double)this.m_nLineWidth * Math.sin(angle));
            if (i != this.m_points.length - 2) continue;
            pointsX[length] = x3;
            pointsY[length--] = y3;
        }
        return vc.destToVirt(new Polygon(pointsX, pointsY, pointsX.length));
    }

    private Polygon calcLine(Point m_pt1, Point m_pt2, int nLineWidth, VC vc, boolean bWantEndcaps) {
        Point pt1;
        Point pt0;
        Polygon poly = new Polygon();
        if (m_pt1.x < m_pt2.x) {
            pt0 = vc.virtToDest(m_pt1);
            pt1 = vc.virtToDest(m_pt2);
        } else {
            pt1 = vc.virtToDest(m_pt1);
            pt0 = vc.virtToDest(m_pt2);
        }
        PfjAssert.pfjAssert(pt0.x <= pt1.x);
        double dx = pt1.x - pt0.x;
        double dy = pt1.y - pt0.y;
        double fAngleDeg = Math.atan2(dy, dx) * 57.29577951308232;
        if (bWantEndcaps) {
            Point pt;
            double delta = 90.0;
            while (FP.lessThan(delta, 272.0)) {
                pt = vc.destToVirt(MathExt.polToCart(fAngleDeg + delta, (double)nLineWidth, pt0));
                poly.addPoint(pt.x, pt.y);
                delta += 10.0;
            }
            delta = -90.0;
            while (FP.lessThan(delta, 92.0)) {
                pt = vc.destToVirt(MathExt.polToCart(fAngleDeg + delta, (double)nLineWidth, pt1));
                poly.addPoint(pt.x, pt.y);
                delta += 10.0;
            }
        } else {
            double angle = (fAngleDeg + 90.0) * (Math.PI / 180);
            int x0 = pt0.x + (int)Math.round((double)nLineWidth * Math.cos(angle));
            int y0 = pt0.y + (int)Math.round((double)nLineWidth * Math.sin(angle));
            poly.addPoint(x0, y0);
            angle = (fAngleDeg + 270.0) * (Math.PI / 180);
            int x1 = pt0.x + (int)Math.round((double)nLineWidth * Math.cos(angle));
            int y1 = pt0.y + (int)Math.round((double)nLineWidth * Math.sin(angle));
            poly.addPoint(x1, y1);
            angle = (fAngleDeg - 90.0) * (Math.PI / 180);
            int x2 = pt1.x + (int)Math.round((double)nLineWidth * Math.cos(angle));
            int y2 = pt1.y + (int)Math.round((double)nLineWidth * Math.sin(angle));
            poly.addPoint(x2, y2);
            angle = (fAngleDeg + 90.0) * (Math.PI / 180);
            int x3 = pt1.x + (int)Math.round((double)nLineWidth * Math.cos(angle));
            int y3 = pt1.y + (int)Math.round((double)nLineWidth * Math.sin(angle));
            poly.addPoint(x3, y3);
            poly.addPoint(x0, y0);
            poly = vc.destToVirt(poly);
        }
        return poly;
    }
}

