/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import oracle.dss.graph.pfj.AssertionException;

public final class PfjAssert {
    private static final boolean DEBUG = true;
    private static boolean m_bPrintStackTrace = false;
    private static boolean m_bPrintExplanation = false;

    private static void _fail() throws AssertionException {
        if (m_bPrintStackTrace) {
            Throwable e = new Throwable();
            e.printStackTrace();
        }
        throw new AssertionException();
    }

    private static void fail() throws AssertionException {
        if (m_bPrintExplanation) {
            System.err.println("Assertion failed!");
        }
        PfjAssert._fail();
    }

    private static void fail(String explanation) throws AssertionException {
        if (m_bPrintExplanation) {
            System.err.println("Assertion failed: " + explanation);
        }
        PfjAssert._fail();
    }

    public static boolean getPrintStackTrace() {
        return m_bPrintStackTrace;
    }

    public static void setPrintStackTrace(boolean newValue) {
        m_bPrintStackTrace = newValue;
    }

    public static void pfjAssert(boolean expression) throws AssertionException {
        if (!expression) {
            PfjAssert.fail();
        }
    }

    public static void pfjAssert(Object ref) throws AssertionException {
        if (ref == null) {
            PfjAssert.fail();
        }
    }

    public static void pfjAssert(boolean expression, String explanation) throws AssertionException {
        if (!expression) {
            PfjAssert.fail(explanation);
        }
    }

    public static void pfjAssert(Object ref, String explanation) throws AssertionException {
        if (ref == null) {
            PfjAssert.fail(explanation);
        }
    }
}

