/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIStockMarker;
import oracle.dss.graph.BaseDataComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class StockMarker
extends BaseDataComponent
implements UIStockMarker {
    public static final String a_fallingColor = "fallingColor";
    public static final String a_risingColor = "risingColor";

    public StockMarker(CommonGraph graph, IdentObj identObj) {
        super(graph, identObj);
    }

    @Override
    public int getStockMarkerType(int series, int groups) {
        double close;
        double open;
        switch (this.m_commonGraph.getGraphType()) {
            case 70: {
                if (this.m_commonGraph.isDataRowShownAsASeries()) {
                    open = this.getValue(series, 0 + 4 * groups);
                    close = this.getValue(series, 3 + 4 * groups);
                    break;
                }
                open = this.getValue(0 + 4 * groups, series);
                close = this.getValue(3 + 4 * groups, series);
                break;
            }
            case 71: {
                if (this.m_commonGraph.isDataRowShownAsASeries()) {
                    open = this.getValue(series, 0 + 5 * groups);
                    close = this.getValue(series, 3 + 5 * groups);
                    break;
                }
                open = this.getValue(0 + 5 * groups, series);
                close = this.getValue(3 + 5 * groups, series);
                break;
            }
            case 72: {
                if (this.m_commonGraph.isDataRowShownAsASeries()) {
                    open = this.getValue(series, 0 + 2 * groups);
                    close = this.getValue(series, 1 + 2 * groups);
                    break;
                }
                open = this.getValue(0 + 2 * groups, series);
                close = this.getValue(1 + 2 * groups, series);
                break;
            }
            case 84: {
                if (this.m_commonGraph.isDataRowShownAsASeries()) {
                    open = this.getValue(series, 0 + 3 * groups);
                    close = this.getValue(series, 1 + 3 * groups);
                    break;
                }
                open = this.getValue(0 + 3 * groups, series);
                close = this.getValue(1 + 3 * groups, series);
                break;
            }
            default: {
                return 3;
            }
        }
        if (close == open) {
            return 2;
        }
        if (close > open) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setFallingColor(Color color) {
        this.m_pfj.setFillColor(this.m_pfj.getStockFallingRiser(), color);
    }

    @Override
    public Color getFallingColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getStockFallingRiser());
    }

    @Override
    public void setRisingColor(Color color) {
        this.m_pfj.setFillColor(this.m_pfj.getStockRisingRiser(), color);
    }

    @Override
    public Color getRisingColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getStockRisingRiser());
    }

    @Override
    protected String getComponentName() {
        return "StockMarker";
    }

    @Override
    public void setStyleXML(ObjectNode node) {
        Color c;
        PropertyNode pNode = node.getProperty(a_fallingColor);
        if (pNode != null) {
            c = new Color(StockMarker.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_fallingColor, c);
            } else {
                this.setFallingColor(c);
            }
        }
        if ((pNode = node.getProperty(a_risingColor)) != null) {
            c = new Color(StockMarker.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_risingColor, c);
            } else {
                this.setRisingColor(c);
            }
        }
    }

    @Override
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = false;
        Color val = this.getFallingColor();
        if (val != null) {
            node.addProperty(a_fallingColor, StockMarker.toHexString(val.getRGB()));
            styleOverridden = true;
        }
        if ((val = this.getRisingColor()) != null) {
            node.addProperty(a_risingColor, StockMarker.toHexString(val.getRGB()));
            styleOverridden = true;
        }
        return styleOverridden;
    }

    private double getValue(int row, int col) {
        Object value = ((DataCallback)this.m_commonGraph.getDataFilter()).getValue(row, col);
        if (value != null && value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    protected void resetStyle() {
        this.setFallingColor(Color.black);
        this.setRisingColor(Color.black);
    }
}

