/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseBorderLine;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Line;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class O1Axis
extends BaseBorderLine
implements Line {
    protected static final String al_left = "AL_LEFT";
    protected static final String al_right = "AL_RIGHT";
    protected static final String al_both = "AL_BOTH";
    protected static final String a_axisLocation = "axisLocation";

    public O1Axis(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getO1AxisLine();
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    @Override
    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    @Override
    public void setVisible(boolean visible) {
        this.m_pfj.setO1AxisLineDisplay(visible);
        this.m_pfj.setO1LabelDisplay(visible);
        this.m_pfj.setO1MajorGridDisplay(visible);
    }

    public int getAxisLocation() {
        return this.m_pfj.getAxisSide(this.m_pfj.getO1Axis());
    }

    public void setAxisLocation(int location) {
        if (location < 0 || location > 2) {
            this.m_commonGraph.getErrorHandler().log("invalid value for AxisLocation", this.getClass().getName(), "setAxisLocation( int location )");
        } else {
            IdentObj identObj = this.m_pfj.getO1Axis();
            this.m_pfj.setAxisSide(identObj, location);
            this.m_commonGraph.autoSetAxisTitleVerticalAlignment(identObj.getObjectID());
        }
    }

    @Override
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getAxisSideObj(this.m_pfj.getO1Axis());
        if (val != null) {
            node.addProperty(a_axisLocation, this.convertAxisLocationToString((Integer)val));
            styleOverridden = true;
        }
        return styleOverridden;
    }

    @Override
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty(a_axisLocation);
        if (pNode != null) {
            this.setAxisLocation(this.convertAxisLocationToInt(pNode.getValueAsString()));
        }
    }

    @Override
    protected String getComponentName() {
        return "O1Axis";
    }

    protected int convertAxisLocationToInt(String str) {
        int loc = 0;
        if (str.equals(al_right)) {
            loc = 1;
        } else if (str.equals(al_both)) {
            loc = 2;
        }
        return loc;
    }

    protected String convertAxisLocationToString(int loc) {
        String str = "";
        switch (loc) {
            case 0: {
                str = al_left;
                break;
            }
            case 1: {
                str = al_right;
                break;
            }
            case 2: {
                str = al_both;
            }
        }
        return str;
    }

    @Override
    protected void resetStyle() {
        super.resetStyle();
        this.setAxisLocation(0);
    }
}

