/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIFillColor;
import oracle.dss.dataView.UITransparentFillColor;
import oracle.dss.graph.BaseGraphFrame;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class Base3DPanel
extends BaseGraphFrame
implements UIFillColor,
UITransparentFillColor {
    public Base3DPanel(CommonGraph graph) {
        super(graph);
    }

    @Override
    public void setFillColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        if (this.m_commonGraph.m_settingXML) {
            if (this.m_commonGraph.isGroup3DPanels()) {
                this.m_pfj.setFillColor(this.m_pfj.getCubeFloor(), newColor);
                this.m_pfj.setFillColor(this.m_pfj.getCubeLeftWall(), newColor);
                this.m_pfj.setFillColor(this.m_pfj.getCubeRightWall(), newColor);
            } else {
                this.m_pfj.setFillColor(this.m_identObj, newColor);
            }
        } else {
            super.setFillColor(newColor);
        }
    }

    @Override
    public void setFillTransparent(boolean yesNo) {
        if (this.m_commonGraph.m_settingXML) {
            if (this.m_commonGraph.isGroup3DPanels()) {
                this.m_pfj.setTransparentFillColor(this.m_pfj.getCubeFloor(), yesNo);
                this.m_pfj.setTransparentFillColor(this.m_pfj.getCubeLeftWall(), yesNo);
                this.m_pfj.setTransparentFillColor(this.m_pfj.getCubeRightWall(), yesNo);
            } else {
                this.m_pfj.setTransparentFillColor(this.m_identObj, yesNo);
            }
        } else {
            super.setFillTransparent(yesNo);
        }
    }

    public boolean isSharePanelProperties() {
        return this.m_commonGraph.isGroup3DPanels();
    }

    public void setSharePanelProperties(boolean yesNo) {
        this.m_commonGraph.get3DFloor().setGroup3DPanels(yesNo);
    }

    @Override
    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        Object val;
        boolean nodeExists = false;
        if ((this.getComponentName().equals("ThreeDLeftWall") || this.getComponentName().equals("ThreeDRightWall")) && this.m_commonGraph.isGroup3DPanels()) {
            return null;
        }
        ObjectNode node = super.getXML(allProperties, allOverriddenProperties);
        if (node != null) {
            nodeExists = true;
        } else {
            node = new ObjectNode(this.getComponentName());
        }
        if (this.getComponentName().equals("ThreeDFloor") && (val = this.m_pfj.getObjProp(Attr.Group3DPanels)) != null) {
            node.addProperty("sharePanelProperties", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    @Override
    protected void setXML(ObjectNode node, boolean allProperties) {
        PropertyNode pNode = node.getProperty("sharePanelProperties");
        if (pNode != null) {
            this.setSharePanelProperties(pNode.getValueAsBoolean());
        }
        super.setXML(node, allProperties);
    }
}

