/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import oracle.dss.gauge.BaseFrame;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.GaugeDefaultValues;

public class LegendArea
extends BaseFrame {
    public LegendArea(CommonGauge gauge) {
        super(gauge, 27);
        this.m_visibleKey = "LegendAreaVisible";
        this.m_fillColorKey = "LegendAreaFillColor";
        this.m_borderColorKey = "LegendAreaBorderColor";
        this.m_sfxID = 27;
        this.m_defaultVisible = GaugeDefaultValues.isLegendAreaVisible();
        this.m_defaultFillColor = GaugeDefaultValues.getLegendAreaFillColor();
        this.m_defaultBorderColor = GaugeDefaultValues.getLegendAreaBorderColor();
        this.m_isGaugeSetComponent = true;
    }

    public int getPosition() {
        Object obj = this.m_commonGauge.getGaugeSetAttribute("LegendAreaPosition");
        if (obj == null) {
            return GaugeDefaultValues.getLegendAreaPosition();
        }
        return (Integer)obj;
    }

    public void setPosition(int position) {
        if (position < 0 || position > 3) {
            this.m_commonGauge.getErrorHandler().log("invalid position", this.getClass().getName(), "setPosition");
            return;
        }
        this.m_commonGauge.setGaugeSetAttribute("LegendAreaPosition", new Integer(position));
    }

    public static int convertPositionToInt(String position) {
        int iPosition = 0;
        if (position.equals("LAP_RIGHT") || position.equalsIgnoreCase("right")) {
            iPosition = 2;
        } else if (position.equals("LAP_LEFT") || position.equalsIgnoreCase("left")) {
            iPosition = 3;
        } else if (position.equals("LAP_BOTTOM") || position.equalsIgnoreCase("bottom")) {
            iPosition = 1;
        }
        return iPosition;
    }

    public static String convertPositionToString(int position) {
        String iPosition = "LAP_TOP";
        if (position == 2) {
            iPosition = "LAP_RIGHT";
        } else if (position == 3) {
            iPosition = "LAP_LEFT";
        } else if (position == 1) {
            iPosition = "LAP_BOTTOM";
        }
        return iPosition;
    }
}

