/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import oracle.dss.dataView.managers.Formattable;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.util.format.BaseViewFormat;
import oracle.dss.util.format.BaseViewFormatHandle;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class ViewFormatHandle
extends BaseViewFormatHandle
implements Formattable {
    protected ViewFormat m_viewFormat = null;
    private static final String a_runRules = "runRules";
    private static final String a_id = "id";

    public ViewFormatHandle() {
    }

    public ViewFormatHandle(ViewFormat vf, String id, int runRules) {
        this.setViewFormat(vf);
        this.setViewFormatID(id);
        this.setRunRulesForViewFormat(runRules);
    }

    @Override
    public ViewFormat getViewFormat() {
        return this.m_viewFormat;
    }

    @Override
    public void setViewFormat(ViewFormat vf) {
        this.m_viewFormat = vf;
        this.m_baseViewFormat = vf;
    }

    public void setBaseViewFormat(BaseViewFormat baseViewFormat) {
        super.setBaseViewFormat(baseViewFormat);
        this.m_viewFormat = null;
    }

    public ObjectNode getXML(String name, boolean allProperties) {
        ObjectNode formatXML;
        ObjectNode node = null;
        ViewFormat format = this.getViewFormat();
        if (format != null && (formatXML = format.getXML(allProperties)) != null) {
            node = new ObjectNode(name);
            node.addProperty(formatXML);
            if (allProperties || this.getRunRulesForViewFormat() != 0) {
                node.addProperty(a_runRules, this.getRunRulesForViewFormat());
            }
            if (allProperties || this.getViewFormatID() != null) {
                node.addProperty(a_id, this.getViewFormatID());
            }
        }
        return node;
    }

    public void setXML(ObjectNode node) {
        ObjectNode format;
        PropertyNode pNode = node.getProperty(a_runRules);
        if (pNode != null) {
            this.setRunRulesForViewFormat(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_id)) != null) {
            this.setViewFormatID(pNode.getValueAsString());
        }
        if ((format = node.getPropertyValueAsObjectNode("ViewFormat", true)) != null) {
            ViewFormat obj = new ViewFormat();
            obj.setXML(format, "2.8.0.0", 0);
            this.setViewFormat(obj);
        }
    }
}

