/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

public class SynchronizedQueue {
    private boolean enabled = true;
    private int get = 0;
    private int put = 0;
    private Object[] objects = new Object[128];

    public synchronized void add(Object object) {
        boolean notify;
        if (object == null) {
            throw new NullPointerException("adding null");
        }
        if (!this.enabled) {
            return;
        }
        boolean bl = notify = this.objects[this.get] == null;
        if (this.objects[this.put] != null) {
            Object[] temporary = new Object[this.objects.length * 2];
            System.arraycopy(this.objects, this.get, temporary, 0, this.objects.length - this.get);
            System.arraycopy(this.objects, 0, temporary, this.objects.length - this.get, this.get);
            this.get = 0;
            this.put = this.objects.length;
            this.objects = temporary;
        }
        this.objects[this.put] = object;
        if (++this.put == this.objects.length) {
            this.put = 0;
        }
        if (notify) {
            this.notify();
        }
    }

    public synchronized Object remove() throws InterruptedException {
        if (this.objects[this.get] == null) {
            this.wait();
        }
        Object object = this.objects[this.get];
        this.objects[this.get] = null;
        if (++this.get == this.objects.length) {
            this.get = 0;
        }
        return object;
    }

    public synchronized Object remove(long timeout) throws InterruptedException {
        Object object;
        if (this.objects[this.get] == null) {
            this.wait(timeout);
        }
        if ((object = this.objects[this.get]) != null) {
            this.objects[this.get] = null;
            if (++this.get == this.objects.length) {
                this.get = 0;
            }
        }
        return object;
    }

    public synchronized void clear() {
        this.get = 0;
        this.put = 0;
        this.objects = new Object[128];
    }

    public synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized boolean isEmpty() {
        return this.objects[this.get] == null;
    }

    public synchronized Object first() {
        return this.objects[this.get];
    }

    public synchronized Object last() {
        return this.objects[this.put > 0 ? this.put - 1 : this.objects.length - 1];
    }
}

