/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import oracle.javatools.util.NamedThreadFactory;
import oracle.javatools.util.UnexpectedExceptionError;

public final class Executors {
    private static boolean privilegesChecked;

    private Executors() {
    }

    public static ThreadFactory namedThreadFactory(String baseName) {
        if (baseName == null) {
            throw new NullPointerException("baseName is null");
        }
        return new NamedThreadFactory(baseName);
    }

    public static void shutdown(final ExecutorService executor) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                executor.shutdown();
                return null;
            }
        };
        Executors.perform(action);
    }

    public static List<Runnable> shutdownNow(final ExecutorService executor) {
        PrivilegedAction<List<Runnable>> action = new PrivilegedAction<List<Runnable>>(){

            @Override
            public List<Runnable> run() {
                return executor.shutdownNow();
            }
        };
        return Executors.perform(action);
    }

    private static <T> T perform(PrivilegedAction<T> action) {
        if (!privilegesChecked) {
            privilegesChecked = true;
            try {
                Class.forName("java.util.concurrent.BlockingDeque");
            }
            catch (ClassNotFoundException e) {
                try {
                    ProtectionDomain d = Executors.class.getProtectionDomain();
                    Permissions permissions = (Permissions)d.getPermissions();
                    Field field = PermissionCollection.class.getDeclaredField("readOnly");
                    field.setAccessible(true);
                    field.setBoolean(permissions, false);
                    permissions.add(new RuntimePermission("modifyThread"));
                    field.setBoolean(permissions, true);
                }
                catch (NoSuchFieldException f) {
                    throw new UnexpectedExceptionError(e);
                }
                catch (IllegalAccessException f) {
                    throw new UnexpectedExceptionError(e);
                }
            }
        }
        return AccessController.doPrivileged(action);
    }
}

