/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.write;

import java.util.Comparator;
import oracle.javatools.data.HashStructure;
import oracle.javatools.parser.java.v2.JavaPreferences;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.write.SourceComparator;

public final class SourcePreferences
implements JavaPreferences {
    private final HashStructure hash;

    public static SourcePreferences copy(SourcePreferences preferences) {
        HashStructure hash = preferences.hash;
        HashStructure hashCopy = hash.copyTo(null);
        return new SourcePreferences(hashCopy);
    }

    public static SourcePreferences createCascadingPreferences(SourcePreferences preferences) {
        HashStructure hash = preferences.hash;
        HashStructure newHash = HashStructure.newInstance();
        HashStructure[] array = new HashStructure[]{newHash, hash};
        HashStructure chain = HashStructure.newChainForOverriding(array);
        return new SourcePreferences(chain);
    }

    public SourcePreferences() {
        this.hash = HashStructure.newInstance();
    }

    public SourcePreferences(HashStructure hash) {
        this.hash = hash;
    }

    public boolean getBoolean(int setting) {
        String key = SourcePreferences.setting2key(setting);
        if (this.hash.containsKey(key)) {
            return this.hash.getBoolean(key);
        }
        Object defaultV = PREFERENCES_defaults[setting - 0];
        if (defaultV instanceof Boolean) {
            return (Boolean)defaultV;
        }
        if (defaultV instanceof Integer) {
            return this.getBoolean(-((Integer)defaultV).intValue());
        }
        return false;
    }

    public void setBoolean(int setting, boolean value) {
        String key = SourcePreferences.setting2key(setting);
        this.hash.putBoolean(key, value);
    }

    public String getString(int setting) {
        String key = SourcePreferences.setting2key(setting);
        if (this.hash.containsKey(key)) {
            return this.hash.getString(key);
        }
        String defaultV = (String)PREFERENCES_defaults[setting - 0];
        return defaultV;
    }

    public void setString(int setting, String value) {
        String key = SourcePreferences.setting2key(setting);
        this.hash.putString(key, value);
    }

    public int getInt(int setting) {
        String key = SourcePreferences.setting2key(setting);
        if (this.hash.containsKey(key)) {
            return this.hash.getInt(key);
        }
        Integer defaultV = (Integer)PREFERENCES_defaults[setting - 0];
        if (defaultV < -1) {
            return this.getInt(-defaultV.intValue());
        }
        return defaultV;
    }

    public void setInt(int setting, int value) {
        String key = SourcePreferences.setting2key(setting);
        this.hash.putInt(key, value);
    }

    private HashStructure getHashStructure(int setting) {
        String key = SourcePreferences.setting2key(setting);
        if (this.hash.containsKey(key)) {
            return this.hash.getHashStructure(key);
        }
        return null;
    }

    public HashStructure getMemberOrderHashStructure() {
        return this.getHashStructure(68);
    }

    public Comparator getMemberComparator() {
        return SourceComparator.memberComparator(this);
    }

    public byte getMemberOrder(int member) {
        String memberOrderKey = SourcePreferences.setting2key(68);
        HashStructure s = this.hash.getHashStructure(memberOrderKey);
        byte defaultV = JavaPreferences.MemberOrder.MEMBER_default[member];
        if (s == null) {
            return defaultV;
        }
        String memberKey = SourcePreferences.member2key(member);
        byte b = -1;
        if (s.containsKey(memberKey)) {
            b = (byte)s.getInt(memberKey);
        }
        if (b >= 0) {
            return b;
        }
        return defaultV;
    }

    public void setMemberOrder(int member, byte value) {
        String memberOrderKey = SourcePreferences.setting2key(68);
        HashStructure s = this.hash.getOrCreateHashStructure(memberOrderKey);
        String memberKey = SourcePreferences.member2key(member);
        s.putInt(memberKey, value);
    }

    public void reloadAll(Object[] allPreferences) {
        int count = 102;
        for (int j = 0; j < 102; ++j) {
            int key = j + 0;
            Object setting = allPreferences[j];
            if (setting instanceof Boolean) {
                Boolean bB = (Boolean)setting;
                boolean b = bB;
                this.setBoolean(key, b);
                continue;
            }
            if (!(setting instanceof Integer)) continue;
            Integer iI = (Integer)setting;
            int i = iI;
            this.setInt(key, i);
        }
    }

    private static String setting2key(int setting) {
        if (0 <= setting && setting < 102) {
            return PREFERENCES_keys[setting - 0];
        }
        CommonUtilities.panic("Invalid setting: " + setting);
        return "";
    }

    private static String member2key(int member) {
        if (0 <= member && member < 11) {
            return JavaPreferences.MemberOrder.MEMBER_keys[member];
        }
        CommonUtilities.panic("Invalid member: " + member);
        return "";
    }
}

