/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util.filter;

import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaElement;

public class DeprecatedFilter {
    public static final DeprecatedFilter SINGLETON = new DeprecatedFilter();
    public static final int REJECT_DEPRECATED = 0;
    public static final int REJECT_HIDDEN = 1;
    public static final int REJECT_BOTH = 2;
    private final int reject;

    public final boolean accepts(JavaElement element) {
        switch (this.reject) {
            case 0: {
                return !element.isDeprecated();
            }
            case 1: {
                return !element.isHidden();
            }
            case 2: {
                return !element.isDeprecated() && !element.isHidden();
            }
        }
        CommonUtilities.panic("Invalid reject " + this.reject);
        return false;
    }

    public DeprecatedFilter() {
        this(0);
    }

    public DeprecatedFilter(int reject) {
        this.reject = reject;
        switch (reject) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public DeprecatedFilter(boolean tossDeprecated, boolean tossHidden) {
        if (tossHidden) {
            this.reject = tossDeprecated ? 2 : 1;
        } else {
            this.reject = 0;
            if (!tossDeprecated) {
                throw new IllegalArgumentException();
            }
        }
    }
}

