/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.expr;

import java.util.Iterator;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;

public final class ListExpr
extends Expr
implements SourceListExpression {
    @Override
    public Object getConstantValue() {
        if (this.exprOptcode != 5) {
            return null;
        }
        int count = this.getOperandCount();
        if (count == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] things = new Object[count];
        if (count < 16) {
            for (int i = 0; i < count; ++i) {
                things[i] = this.getNthOperandSym(i).getConstantValue();
            }
        } else {
            Iterator iterator = this.getOperands().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Expr e = (Expr)iterator.next();
                things[i] = e.getConstantValue();
                ++i;
            }
        }
        return things;
    }

    @Override
    public String printCompiledInfo() {
        if (this.exprOptcode == 26) {
            return "";
        }
        return super.printCompiledInfo();
    }

    @Override
    protected JavaElement resolveImplImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    @Override
    protected void unlinkChildTrigger(Sym child, byte filter) {
        Sym parentSym;
        super.unlinkChildTrigger(child, filter);
        if (this.treeChildren.length == 0 && (parentSym = this.getParentSym()) != null && parentSym.symKind == 1) {
            this.symFlags = (byte)(this.symFlags | 4);
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

