/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.PackageSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.write.SourceComparator;
import oracle.javatools.util.ArraySortedSet;

public final class RootSym
extends TreeSym {
    public RootSym() {
        this.symFlags = (byte)(this.symFlags | 1);
        this.symFlags = (byte)(this.symFlags | 2);
    }

    public SourcePackage getSourcePackage() {
        return this.getPackageSym();
    }

    public PackageSym getPackageSym() {
        return (PackageSym)this.getChild((byte)21);
    }

    public void setSourcePackage(SourcePackage packageD) {
        this.setPackageSym((PackageSym)packageD);
    }

    public void setPackageSym(PackageSym packageSym) {
        this.setSym((byte)21, packageSym);
    }

    public void setPackageName(String name) {
        PackageSym packageSym = this.getPackageSym();
        if (packageSym != null) {
            packageSym.setName(name);
        } else {
            PackageSym newPackage = (PackageSym)this.symFile.factory.createPackageDeclaration(name);
            this.linkChild(0, newPackage);
        }
    }

    public List getSourceImports() {
        return this.getChildren(14);
    }

    public Set getSourceImportNames() {
        return new ImportSet();
    }

    public List getSourceClasses() {
        return this.getChildren(3);
    }

    public SourceClass getSourceClass(String name) {
        for (ClassSym thing : this.getSourceClasses()) {
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public SourceName getSqlContext() {
        return null;
    }

    public Collection getClasses() {
        return this.getObjects((byte)3);
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 3: 
            case 14: 
            case 21: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 21: {
                return 0;
            }
            case 14: {
                int firstImport;
                int target;
                int lastImport = this.lastIndexOf((byte)14);
                if (lastImport == -1) {
                    int lastPackage = this.lastIndexOf((byte)21);
                    if (lastPackage != -1) {
                        return lastPackage + 1;
                    }
                    return 0;
                }
                Comparator hasNameC = SourceComparator.hasNameComparator();
                for (target = firstImport = this.indexOf(14); target <= lastImport; ++target) {
                    int result = hasNameC.compare(sym, this.getNthChild(target));
                    if (result == 0) {
                        return -1;
                    }
                    if (result < 0) break;
                }
                return target;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (!compiler.isJdkLoaded()) {
            return this.getCompiledObject();
        }
        JavaElement out = super.compileImpl(compiler);
        if (!compiler.skipCompilations()) {
            compiler.compile(this);
        }
        return out;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    private class ImportSet
    extends AbstractSet {
        List<Sym> imports;

        private ImportSet() {
            this.initChildren();
        }

        private void initChildren() {
            List<Sym> treeChildren = RootSym.this.getTreeChildren((byte)14);
            this.imports = new ArrayList<Sym>(treeChildren.size());
            for (Sym sym : treeChildren) {
                if (sym == null) continue;
                this.imports.add(sym);
            }
        }

        @Override
        public Iterator iterator() {
            this.initChildren();
            return new ImportSetIterator();
        }

        @Override
        public boolean isEmpty() {
            return this.imports.isEmpty();
        }

        @Override
        public int size() {
            return this.imports.size();
        }

        private Set toStrings() {
            ImportSetIterator i = new ImportSetIterator();
            while (i.hasNext()) {
                i.next();
            }
            return i.processed;
        }

        @Override
        public boolean add(String value) {
            this.initChildren();
            if (this.contains(value)) {
                return false;
            }
            SourceFactory factory = RootSym.this.symFile.getFactory();
            ImportSym importSym = (ImportSym)factory.createImportDeclaration(value);
            importSym.addSelf(RootSym.this);
            this.initChildren();
            return true;
        }

        public boolean contains(String value) {
            for (int x = 0; x < this.imports.size(); ++x) {
                ImportSym importSym = (ImportSym)this.imports.get(x);
                if (!value.equals(importSym.getName())) continue;
                return true;
            }
            return false;
        }

        public boolean remove(String value) {
            this.initChildren();
            for (int x = 0; x < this.imports.size(); ++x) {
                ImportSym importSym = (ImportSym)this.imports.get(x);
                if (!value.equals(importSym.getName())) continue;
                importSym.removeSelf();
                this.initChildren();
                return true;
            }
            return false;
        }

        @Override
        public boolean add(Object o) {
            return this.add((String)o);
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((String)o);
        }

        @Override
        public boolean remove(Object o) {
            return this.remove((String)o);
        }

        @Override
        public boolean containsAll(Collection c) {
            Set set = this.toStrings();
            return set.containsAll(c);
        }

        @Override
        public void clear() {
            RootSym.this.getSourceImports().clear();
            this.initChildren();
        }

        private class ImportSetIterator
        implements Iterator {
            private final ArraySortedSet processed = new ArraySortedSet();
            private String next;
            private String lastNext;
            private List<Sym> imports;
            private int iteratorNext = -1;

            ImportSetIterator() {
                this.initChildren();
                this.advance();
            }

            private void initChildren() {
                List<Sym> treeChildren = RootSym.this.getTreeChildren((byte)14);
                this.imports = new ArrayList<Sym>(treeChildren.size());
                for (Sym sym : treeChildren) {
                    if (sym == null) continue;
                    this.imports.add(sym);
                }
            }

            @Override
            public boolean hasNext() {
                return this.iteratorNext < this.imports.size();
            }

            public Object next() {
                if (!this.hasNext()) {
                    this.lastNext = null;
                    throw new NoSuchElementException();
                }
                this.lastNext = this.next;
                this.advance();
                return this.lastNext;
            }

            @Override
            public void remove() {
                if (this.lastNext != null) {
                    ImportSet.this.remove(this.lastNext);
                    this.initChildren();
                    --this.iteratorNext;
                    this.lastNext = null;
                }
            }

            private void advance() {
                ++this.iteratorNext;
                while (this.iteratorNext < this.imports.size()) {
                    Sym sym = this.imports.get(this.iteratorNext);
                    this.next = ((ImportSym)sym).getName();
                    if (!this.processed.contains(this.next)) break;
                    ++this.iteratorNext;
                }
                if (this.next != null) {
                    this.processed.add(this.next);
                }
            }
        }
    }
}

