/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickHasType;
import oracle.javatools.parser.java.v2.common.QuickLocalVariable;
import oracle.javatools.parser.java.v2.common.QuickMethod;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.write.SourceComparator;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public final class ClassBodySym
extends TreeSym
implements SourceClassBody {
    public List getSourceMembers() {
        return this.getChildren(86);
    }

    public Collection getSourceMemberVariables() {
        return this.getSyms((byte)98);
    }

    public SourceMemberVariable getSourceMemberVariable(String name) {
        for (EnumConstantSym thing : this.getSourceEnumConstants()) {
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        for (FieldSym fieldSym : this.getSourceFieldVariables()) {
            if (!name.equals(fieldSym.getName())) continue;
            return fieldSym;
        }
        return null;
    }

    public List getSourceEnumConstants() {
        return this.getChildren(7);
    }

    public List getSourceFieldDeclarations() {
        return this.getChildren(9);
    }

    public Collection getSourceFieldVariables() {
        return this.getSyms((byte)99);
    }

    public SourceFieldVariable getSourceFieldVariable(String name) {
        for (FieldSym fieldSym : this.getSourceFieldVariables()) {
            if (!name.equals(fieldSym.getName())) continue;
            return fieldSym;
        }
        return null;
    }

    public List getSourceMethods() {
        return this.getChildren(19);
    }

    public Collection getSourceMethods(String name) {
        ArrayList<MethodSym> list = new ArrayList<MethodSym>();
        for (MethodSym sym : this.getSourceMethods()) {
            if (!name.equals(sym.getName())) continue;
            list.add(sym);
        }
        return list;
    }

    public List getSourceConstructors() {
        return this.getChildren(6);
    }

    @Override
    public List<SourceClass> getSourceClasses() {
        return this.getChildren(3);
    }

    @Override
    public List<SourceClass> getSourceAnonymousClasses() {
        return Collections.unmodifiableList(CommonUtilities.getSourceAnonymousClasses(this));
    }

    @Override
    public List<SourceClass> getSourceLocalClasses() {
        return Collections.unmodifiableList(CommonUtilities.getSourceLocalClasses(this));
    }

    public SourceClass getSourceClass(String name) {
        for (ClassSym classSym : this.getSourceClasses()) {
            if (!name.equals(classSym.getName())) continue;
            return classSym;
        }
        return null;
    }

    public List getSourceInitializers() {
        return this.getChildren(5);
    }

    protected Collection getDeclaredConstructors() {
        List constructors = this.getObjects((byte)6);
        if (!constructors.isEmpty()) {
            return constructors;
        }
        ArrayList<QuickMethod> constructorList = new ArrayList<QuickMethod>(1);
        QuickMethod defaultConstructor = this.getDefaultConstructor();
        if (defaultConstructor != null) {
            constructorList.add(defaultConstructor);
        }
        return constructorList;
    }

    protected Collection getDeclaredMethods() {
        List methods = this.getObjects((byte)19);
        Sym parentSym = this.getParentSym();
        if (parentSym != null && parentSym.symKind == 3) {
            ClassSym sourceClass = (ClassSym)parentSym;
            if (sourceClass.isEnum()) {
                return this.addEnumMethods(sourceClass, methods);
            }
            if (sourceClass.isInterface() && !sourceClass.isAnnotation() && sourceClass.getInterfaces().isEmpty()) {
                return this.addObjectMethodsToInterface(sourceClass, methods);
            }
        }
        return methods;
    }

    protected Collection getDeclaredClasses() {
        return this.getObjects((byte)3);
    }

    protected Collection getDeclaredAnonymousClasses() {
        return this.getCompiledObjects(this.getSourceAnonymousClasses());
    }

    protected Collection getDeclaredLocalClasses() {
        return this.getCompiledObjects(this.getSourceLocalClasses());
    }

    private Collection getCompiledObjects(List<SourceClass> sourceClasses) {
        ArrayList<JavaElement> declaredClasses = new ArrayList<JavaElement>();
        for (SourceClass sourceClass : sourceClasses) {
            JavaElement compiledObject = sourceClass.getCompiledObject();
            if (compiledObject == null) continue;
            declaredClasses.add(compiledObject);
        }
        return declaredClasses;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 19: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected int getTargetIndex(Sym target, byte filter) {
        int i;
        if (target.isFilter((byte)87) && (i = this.indexOf((byte)87)) != -1) {
            int next;
            Sym firstSym;
            SourcePreferences p = this.symFile.getPreferences();
            Comparator comparator = p != null ? p.getMemberComparator() : SourceComparator.memberComparator();
            if (comparator.compare(target, firstSym = this.getNthChild(i)) < 0) {
                return i;
            }
            while ((next = this.indexOf((byte)87, i + 1)) != -1) {
                Sym sym = this.getNthChild(next);
                if (comparator.compare(target, sym) < 0) {
                    return i + 1;
                }
                i = next;
            }
        }
        return super.getTargetIndex(target, filter);
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        super.linkChildTrigger(added, filter);
        switch (added.symKind) {
            case 19: {
                this.clearMethodCache();
                break;
            }
            case 9: {
                this.clearFieldCache();
                break;
            }
            case 3: {
                this.clearClassCache();
            }
        }
    }

    @Override
    protected void unlinkChildTrigger(Sym removed, byte filter) {
        super.unlinkChildTrigger(removed, filter);
        switch (removed.symKind) {
            case 19: {
                this.clearMethodCache();
                break;
            }
            case 9: {
                this.clearFieldCache();
                break;
            }
            case 3: {
                this.clearClassCache();
            }
        }
    }

    private void clearMethodCache() {
        Sym parent = this.getParentSym();
        if (parent != null) {
            parent.clearInternalBinding(18);
            parent.clearInternalBinding(19);
        }
    }

    private void clearFieldCache() {
        Sym parent = this.getParentSym();
        if (parent != null) {
            parent.clearInternalBinding(20);
        }
    }

    private void clearClassCache() {
        Sym parent = this.getParentSym();
        if (parent != null) {
            this.clearInternalBinding(21);
        }
    }

    private QuickMethod getDefaultConstructor() {
        ClassSym classSym;
        Sym parentSym = this.getParentSym();
        if (parentSym != null && parentSym.symKind == 3 && !(classSym = (ClassSym)this.symParent).isInterface()) {
            char access;
            if (classSym.isEnum()) {
                access = '\u0002';
            } else {
                access = classSym.symAccess;
                access = (char)(access & 7);
            }
            access = (char)(access | 0x1000);
            List<JavaVariable> parameters = null;
            JavaType outerClass = ClassBodySym.getOuterClassOfNonstaticInner(classSym);
            if (outerClass != null) {
                QuickLocalVariable parameter = QuickLocalVariable.createLocalVariable(outerClass, "this$0");
                parameters = Arrays.asList(parameter);
            }
            return QuickMethod.createMethod(classSym, access, null, "<init>", parameters, null);
        }
        return null;
    }

    private List<JavaMethod> addEnumMethods(ClassSym owningSym, Collection otherMethods) {
        int access = 4105;
        JavaType arrayOfOwning = ClassBodySym.createArrayType(this.symFile.getProvider(), owningSym, 1);
        QuickMethod valuesMethod = QuickMethod.createMethod(owningSym, '\u1009', arrayOfOwning, "values", null, null);
        ArrayList<QuickLocalVariable> parameterList = new ArrayList<QuickLocalVariable>();
        QuickHasType stringType = QuickHasType.createHasTypeByVMName(this.symFile, "java/lang/String");
        QuickLocalVariable nameParameter = QuickLocalVariable.createLocalVariable(stringType, "name");
        parameterList.add(nameParameter);
        QuickMethod valueOfMethod = QuickMethod.createMethod(owningSym, '\u1009', owningSym, "valueOf", parameterList, null);
        ArrayList<JavaMethod> methods = new ArrayList<JavaMethod>(otherMethods);
        methods.add(valuesMethod);
        methods.add(valueOfMethod);
        return methods;
    }

    private Collection addObjectMethodsToInterface(ClassSym owningInterface, Collection existingMethods) {
        JavaClass objectClazz;
        JavaProvider provider = this.symFile.getProvider();
        JavaClass javaClass = objectClazz = provider == null ? null : provider.getClassByVMName("java/lang/Object");
        if (objectClazz != null) {
            ArrayList<QuickMethod> finalMethods = new ArrayList<QuickMethod>(existingMethods);
            Collection<JavaMethod> objectMethods = objectClazz.getDeclaredMethods();
            block0: for (JavaMethod objectMethod : objectMethods) {
                if (objectMethod.isConstructor() || !objectMethod.isPublic()) continue;
                String objectMethodName = objectMethod.getName();
                JavaType[] objectMethodParameterTypes = objectMethod.getParameterTypes();
                for (Object existingMethod : existingMethods) {
                    if (!objectMethodName.equals(((JavaMethod)existingMethod).getName()) || !CommonUtilities.matchMethod((JavaMethod)existingMethod, objectMethodParameterTypes)) continue;
                    continue block0;
                }
                finalMethods.add(QuickMethod.createMethod(owningInterface, (char)(objectMethod.getModifiers() | 0x400 | 0x1000), objectMethod.getReturnType(), objectMethod.getName(), objectMethod.getParameters(), objectMethod.getExceptions()));
            }
            return finalMethods;
        }
        return existingMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (compiler.skipCompilations()) {
            return super.compileImpl(compiler);
        }
        HashMap<ChildKind, List<Sym>> children = new HashMap<ChildKind, List<Sym>>();
        int count = this.getChildCount(458752);
        for (int i = 0; i < count; ++i) {
            ChildKind target;
            Sym child = this.getNthChild(i);
            if (child == null) continue;
            switch (child.symKind) {
                case 6: {
                    target = ChildKind.CONSTRUCTOR;
                    break;
                }
                case 9: {
                    if (child.isStatic()) {
                        if (child.isFinal()) {
                            target = ChildKind.STATIC_FINAL_FIELD;
                            break;
                        }
                        target = ChildKind.STATIC_FIELD;
                        break;
                    }
                    if (child.isFinal()) {
                        target = ChildKind.FINAL_FIELD;
                        break;
                    }
                    target = ChildKind.FIELD;
                    break;
                }
                case 5: {
                    if (child.isStatic()) {
                        target = ChildKind.STATIC_INITIALIZER;
                        break;
                    }
                    target = ChildKind.INITIALIZER;
                    break;
                }
                default: {
                    target = ChildKind.OTHER;
                }
            }
            ArrayList<Sym> mappedChildren = (ArrayList<Sym>)children.get((Object)target);
            if (mappedChildren == null) {
                mappedChildren = new ArrayList<Sym>();
                children.put(target, mappedChildren);
            }
            mappedChildren.add(child);
        }
        this.reorderConstructors((List)children.get((Object)ChildKind.CONSTRUCTOR));
        Sym parentSym = this.getParentSym();
        ClassSym classSym = null;
        if (parentSym != null && parentSym.symKind == 3) {
            classSym = (ClassSym)parentSym;
        }
        this.compile(ChildKind.STATIC_FINAL_FIELD, children, compiler);
        this.compile(ChildKind.STATIC_FIELD, children, compiler);
        this.compile(ChildKind.FINAL_FIELD, children, compiler);
        this.compile(ChildKind.FIELD, children, compiler);
        if (classSym != null) {
            compiler.startStaticInitializersFlowAnalysis(classSym);
        }
        try {
            this.compile(ChildKind.STATIC_INITIALIZER, children, compiler);
        }
        finally {
            if (classSym != null) {
                compiler.endStaticInitializersFlowAnalysis(classSym);
            }
        }
        this.compile(ChildKind.INITIALIZER, children, compiler);
        if (classSym != null) {
            compiler.startConstructorsFlowAnalysis(classSym);
        }
        try {
            this.compile(ChildKind.CONSTRUCTOR, children, compiler);
        }
        finally {
            if (classSym != null) {
                compiler.endConstructorsFlowAnalysis(classSym);
            }
        }
        this.compile(ChildKind.OTHER, children, compiler);
        return compiler.compile(this);
    }

    private void compile(ChildKind kind, Map<ChildKind, List<Sym>> children, CompilerDriver compiler) {
        List<Sym> syms = children.get((Object)kind);
        if (syms != null) {
            for (Sym sym : syms) {
                sym.compile(compiler);
            }
        }
    }

    private void reorderConstructors(List<Sym> constructors) {
        if (constructors == null) {
            return;
        }
        LinkedHashMap<Sym, SourceElement> map = new LinkedHashMap<Sym, SourceElement>();
        for (Sym constructor : constructors) {
            SourceMethod sourceMethod;
            SourceMethodCallExpression methodCall;
            JavaMethod javaMethod;
            SourceExpression expr;
            SourceElement firstStmt;
            List<SourceElement> codeElements;
            SourceBlock block = ((SourceMethod)((Object)constructor)).getBlock();
            if (block != null && (codeElements = block.getCodeElements()).size() != 0 && (firstStmt = codeElements.get(0)).getSymbolKind() == 40 && (expr = ((SourceExpressionStatement)firstStmt).getExpression()) != null && expr.getSymbolKind() == 57 && (javaMethod = (methodCall = (SourceMethodCallExpression)expr).getResolvedMethod()) != null && javaMethod.isConstructor() && javaMethod.getOwner() == constructor.getOwner() && (sourceMethod = javaMethod.getSourceElement()) != null) {
                map.put(constructor, sourceMethod);
                continue;
            }
            map.put(constructor, constructor);
        }
        constructors.clear();
        while (!map.isEmpty()) {
            int size = map.size();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getKey() != entry.getValue() && !constructors.contains(entry.getValue())) continue;
                constructors.add((Sym)entry.getKey());
                iterator.remove();
            }
            if (size != map.size()) continue;
            constructors.addAll(map.keySet());
            break;
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    private static enum ChildKind {
        CONSTRUCTOR,
        FIELD,
        FINAL_FIELD,
        INITIALIZER,
        OTHER,
        STATIC_FIELD,
        STATIC_FINAL_FIELD,
        STATIC_INITIALIZER;

    }
}

