/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.InternalAnnotationComponent;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.resource.BundleHelper;

public abstract class InternalUtilities
extends CommonUtilities
implements InternalConstants {
    protected static BundleHelper resources;
    protected static final String[] ERROR_loaded;

    public static boolean isCommentToken(int tk) {
        switch (tk) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public static boolean srcIsMemberD(int k) {
        switch (k) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public static boolean srcIsBlockElement(int k) {
        switch (k) {
            case 3: 
            case 18: 
            case 23: {
                return true;
            }
        }
        return InternalUtilities.srcIsStmt(k);
    }

    public static boolean srcIsStmt(int k) {
        return 32 <= k && k < 50;
    }

    public static boolean srcIsExpr(int k) {
        return 50 <= k && k < 70;
    }

    public static boolean srcIsLexical(int k) {
        return 77 <= k && k < 80;
    }

    public static boolean srcIsDoc(int k) {
        return 70 <= k && k < 77;
    }

    public static String op2text(short op) {
        return OP_words[op - 32];
    }

    public static String kw2text(short kw) {
        return KW_words[kw - 96];
    }

    public static char ty2access(byte tykind) {
        switch (tykind) {
            case 0: {
                return '\u0000';
            }
            case 1: {
                return '\u0200';
            }
            case 2: {
                return '\u4000';
            }
            case 3: {
                return '\u2200';
            }
        }
        throw new IllegalArgumentException("Unknown tykind: " + tykind);
    }

    public static byte access2ty(char access) {
        if ((access & 0x2000) != 0) {
            return 3;
        }
        if ((access & 0x4000) != 0) {
            return 2;
        }
        if ((access & 0x200) != 0) {
            return 1;
        }
        return 0;
    }

    public static short accessModifierToKeyword(char access) {
        switch (access) {
            case '\u0800': {
                return 132;
            }
            case '\u0400': {
                return 96;
            }
            case '\u0100': {
                return 123;
            }
            case '\u0080': {
                return 139;
            }
            case '@': {
                return 142;
            }
            case ' ': {
                return 135;
            }
            case '\u0010': {
                return 111;
            }
            case '\b': {
                return 131;
            }
            case '\u0004': {
                return 127;
            }
            case '\u0002': {
                return 126;
            }
            case '\u0001': {
                return 128;
            }
            case '\u0200': {
                return 106;
            }
        }
        return -1;
    }

    public static String tag2name(short tag) {
        if (202 <= tag && tag < 222) {
            return TAG_words[tag - 202];
        }
        return "@unknown";
    }

    public static int error2severity(int error) {
        if (error == 2) {
            return 5;
        }
        if (error == 121) {
            return 1;
        }
        int warningCount = ERROR_warnings.length;
        for (int i = 0; i < warningCount; ++i) {
            if (error != ERROR_warnings[i]) continue;
            return 3;
        }
        return 4;
    }

    public static int error2category(int error) {
        if (4 <= error && error < 12) {
            return 1;
        }
        if (12 <= error && error < 39) {
            return 2;
        }
        if (39 <= error && error < 128) {
            return 4;
        }
        return 0;
    }

    private static String loadErrorMessage(int index) {
        if (resources != null) {
            String key = ERROR_keys[index];
            String value = resources.getString(key);
            if (value != null) {
                return value;
            }
            return "Missing resource '" + key + "'";
        }
        return ERROR_words[index];
    }

    public static String error2message(int error) {
        if (1 <= error && error < 128) {
            String loaded;
            int index = error - 1;
            String alreadyLoaded = ERROR_loaded[index];
            if (alreadyLoaded != null) {
                return alreadyLoaded;
            }
            InternalUtilities.ERROR_loaded[index] = loaded = InternalUtilities.loadErrorMessage(index);
            return loaded;
        }
        return "Error";
    }

    public static JavaType getOuterClassOfNonstaticInner(ClassSym classSym) {
        Sym parentSym = classSym.getParentSym();
        if (parentSym == null) {
            return null;
        }
        switch (parentSym.symKind) {
            case 80: {
                return null;
            }
            case 4: {
                if (classSym.isStatic()) {
                    return null;
                }
                return classSym.getOwningClassSym();
            }
        }
        Sym sym = parentSym;
        while (sym != null) {
            switch (sym.symKind) {
                case 4: {
                    return sym.getOwningClassSym();
                }
            }
            if (sym.isStatic()) {
                return null;
            }
            sym = sym.symParent;
        }
        return null;
    }

    protected static JavaType getOuterClassOfNonstaticInner(JavaType subject) {
        if (subject == null) {
            return null;
        }
        if (subject instanceof ClassSym) {
            return InternalUtilities.getOuterClassOfNonstaticInner((ClassSym)subject);
        }
        if (subject.isExported()) {
            if (subject.isStatic()) {
                return null;
            }
        } else {
            boolean nonstatic;
            JavaField thisDollarZero = subject.getDeclaredField("this$0");
            boolean bl = nonstatic = thisDollarZero != null && thisDollarZero.isSynthetic();
            if (!nonstatic) {
                return null;
            }
        }
        JavaClass owningClass = subject.getOwningClass();
        return owningClass;
    }

    public static Map<String, Object> getAnnotationArguments(JavaAnnotation javaAnnotation) {
        return InternalUtilities.getAnnotationArguments(javaAnnotation, true);
    }

    public static Map<String, Object> getUnresolvedAnnotationArguments(JavaAnnotation javaAnnotation) {
        return InternalUtilities.getAnnotationArguments(javaAnnotation, false);
    }

    private static Map<String, Object> getAnnotationArguments(JavaAnnotation javaAnnotation, boolean resolved) {
        Map componentMap = javaAnnotation.getComponents();
        if (componentMap == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> argumentMap = new HashMap<String, Object>(componentMap.size());
        Set entrySet = componentMap.entrySet();
        for (InternalAnnotationComponent internalAnnotationComponent : entrySet) {
            Object value;
            if (!internalAnnotationComponent.isAnnotationArgument() || (value = resolved ? internalAnnotationComponent.getValue() : internalAnnotationComponent.unresolvedValue) == null) continue;
            argumentMap.put(internalAnnotationComponent.getKey().toString(), value);
        }
        return argumentMap;
    }

    public static boolean hasTypeParameter(JavaType javaType, JavaType[] typeParameters) {
        if (javaType == null) {
            return false;
        }
        switch (javaType.getElementKind()) {
            case 10: {
                if (typeParameters == null || typeParameters.length == 0) {
                    return true;
                }
                int count = typeParameters.length;
                for (int i = 0; i < count; ++i) {
                    if (!javaType.equals(typeParameters[i])) continue;
                    return true;
                }
                break;
            }
            case 11: {
                JavaWildcardType fw = (JavaWildcardType)javaType;
                for (JavaType bound : fw.getUpperBounds()) {
                    if (!InternalUtilities.hasTypeParameter(bound, typeParameters)) continue;
                    return true;
                }
                for (JavaType bound : fw.getLowerBounds()) {
                    if (!InternalUtilities.hasTypeParameter(bound, typeParameters)) continue;
                    return true;
                }
                break;
            }
            case 3: {
                if (javaType.isPrimitive()) {
                    return false;
                }
                if (javaType.isArray()) {
                    return InternalUtilities.hasTypeParameter(javaType.getComponentType(), typeParameters);
                }
                if (!javaType.hasActualTypeArguments()) break;
                for (JavaType y : javaType.getActualTypeArguments()) {
                    if (!InternalUtilities.hasTypeParameter(y, typeParameters)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    static {
        try {
            resources = new BundleHelper("oracle.javatools.parser.resource.ParserBundle");
        }
        catch (MissingResourceException mre) {
            resources = null;
        }
        ERROR_loaded = new String[ERROR_words.length];
    }
}

