/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.WrapperField;
import oracle.javatools.parser.java.v2.common.WrapperLocalVariable;
import oracle.javatools.parser.java.v2.common.WrapperMethod;
import oracle.javatools.parser.java.v2.internal.model.WrappedJavaType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceClass;

final class TypeErasedClass
extends WrappedJavaType
implements JavaClass {
    private JavaType erasedSuperClass;
    private Collection<JavaType> erasedInterfaces;
    private Collection<JavaMethod> erasedConstructors;
    private Collection<JavaMethod> erasedMethods;
    private Collection<JavaField> erasedFields;
    private JavaProvider provider;

    TypeErasedClass(JavaProvider provider, JavaType baseType) {
        super(baseType);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaType getSuperclass() {
        if (this.erasedSuperClass == null) {
            TypeErasedClass typeErasedClass = this;
            synchronized (typeErasedClass) {
                if (this.erasedSuperClass == null) {
                    JavaType superType = super.getSuperclass();
                    this.erasedSuperClass = this.eraseSuper(superType) ? new TypeErasedClass(this.provider, superType) : superType;
                }
            }
        }
        return this.erasedSuperClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getInterfaces() {
        if (this.erasedInterfaces == null) {
            TypeErasedClass typeErasedClass = this;
            synchronized (typeErasedClass) {
                if (this.erasedInterfaces == null) {
                    Collection interfaces = super.getInterfaces();
                    if (interfaces.isEmpty()) {
                        this.erasedInterfaces = Collections.emptyList();
                    } else {
                        ArrayList<JavaType> interfacesFound = new ArrayList<JavaType>();
                        for (JavaType type : interfaces) {
                            if (this.eraseSuper(type)) {
                                interfacesFound.add(new TypeErasedClass(this.provider, type));
                                continue;
                            }
                            interfacesFound.add(type);
                        }
                        this.erasedInterfaces = interfacesFound;
                    }
                }
            }
        }
        return this.erasedInterfaces;
    }

    @Override
    public JavaClass getTypeErasure() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getDeclaredConstructors() {
        if (this.erasedConstructors == null) {
            TypeErasedClass typeErasedClass = this;
            synchronized (typeErasedClass) {
                if (this.erasedConstructors == null) {
                    Collection thingConstructors = super.getDeclaredConstructors();
                    if (thingConstructors.isEmpty()) {
                        this.erasedConstructors = Collections.emptyList();
                    } else {
                        ArrayList<JavaMethod> constructorsFound = new ArrayList<JavaMethod>();
                        for (JavaMethod thingConstructor : thingConstructors) {
                            constructorsFound.add(new TypeErasedMethod(thingConstructor.getMethodErasure()));
                        }
                        this.erasedConstructors = constructorsFound;
                    }
                }
            }
        }
        return this.erasedConstructors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getDeclaredMethods() {
        if (this.erasedMethods == null) {
            TypeErasedClass typeErasedClass = this;
            synchronized (typeErasedClass) {
                if (this.erasedMethods == null) {
                    Collection thingMethods = super.getDeclaredMethods();
                    if (thingMethods.isEmpty()) {
                        this.erasedMethods = thingMethods;
                    } else {
                        ArrayList<JavaMethod> methodsFound = new ArrayList<JavaMethod>();
                        for (JavaMethod thingMethod : thingMethods) {
                            if (!this.eraseMember(thingMethod)) {
                                methodsFound.add(new TypeErasedMethod(thingMethod));
                                continue;
                            }
                            methodsFound.add(new TypeErasedMethod(thingMethod.getMethodErasure()));
                        }
                        this.erasedMethods = methodsFound;
                    }
                }
            }
        }
        return this.erasedMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getDeclaredFields() {
        if (this.erasedFields == null) {
            TypeErasedClass typeErasedClass = this;
            synchronized (typeErasedClass) {
                if (this.erasedFields == null) {
                    Collection fields = super.getDeclaredFields();
                    if (fields.isEmpty()) {
                        this.erasedFields = Collections.emptyList();
                    } else {
                        ArrayList<JavaField> fieldsFound = new ArrayList<JavaField>();
                        for (JavaField field : fields) {
                            JavaType fieldType = field.getResolvedType();
                            if (this.eraseMember(field) && fieldType != null && (fieldType.hasTypeParameters() || fieldType.getElementKind() == 10)) {
                                fieldsFound.add(new TypeErasedField(field.getFieldErasure()));
                                continue;
                            }
                            fieldsFound.add(field);
                        }
                        this.erasedFields = fieldsFound;
                    }
                }
            }
        }
        return this.erasedFields;
    }

    @Override
    public boolean hasActualTypeArguments() {
        return false;
    }

    @Override
    public Collection getActualTypeArguments() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean hasTypeParameters() {
        return this.wrappedType.hasTypeParameters();
    }

    @Override
    public Collection<JavaTypeVariable> getTypeParameters() {
        return this.wrappedType.getTypeParameters();
    }

    @Override
    public JavaTypeVariable getTypeParameter(String name) {
        return this.wrappedType.getTypeParameter(name);
    }

    @Override
    public boolean isErasedType() {
        return true;
    }

    @Override
    public String getUnqualifiedName() {
        return this.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.getRawName();
    }

    @Override
    public void clearCompiledInfo() {
        if (this.wrappedType instanceof JavaClass) {
            ((JavaClass)this.wrappedType).clearCompiledInfo();
        }
    }

    @Override
    public SourceClass getSourceElement() {
        if (this.wrappedType instanceof JavaClass) {
            return ((JavaClass)this.wrappedType).getSourceElement();
        }
        return null;
    }

    private boolean eraseMember(JavaMember javaMember) {
        if (!javaMember.isStatic()) {
            return true;
        }
        JavaClass owningClass = javaMember.getOwningClass();
        return owningClass != null && owningClass.isStatic();
    }

    private boolean eraseSuper(JavaType superType) {
        if (superType == null || !superType.hasTypeParameters()) {
            return false;
        }
        if (!superType.hasActualTypeArguments()) {
            return true;
        }
        Collection<JavaTypeVariable> typeParams = this.getTypeParameters();
        return this.typeArgMatchesAnyTypeParameter(superType, typeParams);
    }

    private boolean typeArgMatchesAnyTypeParameter(JavaType typeArg, Collection typeParams) {
        block7: {
            block6: {
                if (typeArg == null) {
                    return false;
                }
                if (typeParams.contains(typeArg)) {
                    return true;
                }
                if (typeArg.getElementKind() != 11) break block6;
                JavaWildcardType wildcard = (JavaWildcardType)typeArg;
                Collection<JavaType> bounds = wildcard.getLowerBounds();
                if (!bounds.isEmpty()) {
                    bounds.addAll(wildcard.getUpperBounds());
                } else {
                    bounds = wildcard.getUpperBounds();
                }
                Iterator<JavaType> boundIter = bounds.iterator();
                while (boundIter.hasNext()) {
                    if (!this.typeArgMatchesAnyTypeParameter(boundIter.next(), typeParams)) continue;
                    return true;
                }
                break block7;
            }
            if (!typeArg.hasActualTypeArguments()) break block7;
            Collection<JavaType> actualTypeArgs = typeArg.getActualTypeArguments();
            for (JavaType actualTypeArg : actualTypeArgs) {
                if (!this.typeArgMatchesAnyTypeParameter(actualTypeArg, typeParams)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JavaType getQualifyingType() {
        return this.wrappedType.getQualifyingType();
    }

    @Override
    public void setQualifyingType(JavaType qualifyingType) {
        this.wrappedType.setQualifyingType(qualifyingType);
    }

    private class TypeErasedField
    extends WrapperField {
        private TypeErasedField(JavaField baseField) {
            super(baseField);
        }

        private JavaType eraseResolvedType(JavaType resolvedType) {
            if (resolvedType != null) {
                if (resolvedType.isArray()) {
                    JavaType resolvedComponentType = this.eraseResolvedType(resolvedType.getComponentType());
                    return CommonUtilities.createArrayType(TypeErasedClass.this.provider, resolvedComponentType, 1);
                }
                if (resolvedType.getElementKind() == 10) {
                    return resolvedType.getTypeErasure();
                }
                if (resolvedType.hasTypeParameters()) {
                    return new TypeErasedClass(TypeErasedClass.this.provider, resolvedType);
                }
            }
            return resolvedType;
        }

        @Override
        public JavaType getResolvedType() {
            return this.eraseResolvedType(super.getResolvedType());
        }

        @Override
        public JavaClass getOwningClass() {
            return TypeErasedClass.this;
        }

        @Override
        public JavaField getFieldErasure() {
            return this.thing;
        }
    }

    private class TypeErasedMethod
    extends WrapperMethod {
        private Collection<JavaLocalVariable> erasedParameters;

        private TypeErasedMethod(JavaMethod baseMethod) {
            super(baseMethod);
            this.erasedParameters = null;
        }

        @Override
        public JavaType getResolvedType() {
            return this.eraseResolvedType(this.thing.getResolvedType());
        }

        private JavaType eraseResolvedType(JavaType resolvedType) {
            if (!TypeErasedClass.this.eraseMember(this.thing)) {
                return resolvedType;
            }
            if (resolvedType != null) {
                if (resolvedType.isArray()) {
                    JavaType resolvedComponentType = this.eraseResolvedType(resolvedType.getComponentType());
                    return CommonUtilities.createArrayType(TypeErasedClass.this.provider, resolvedComponentType, 1);
                }
                if (resolvedType.getElementKind() == 10) {
                    return resolvedType.getTypeErasure();
                }
                if (resolvedType.hasTypeParameters()) {
                    return new TypeErasedClass(TypeErasedClass.this.provider, resolvedType);
                }
            }
            return resolvedType;
        }

        @Override
        public JavaType getReturnType() {
            return this.eraseResolvedType(this.thing.getReturnType());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection getParameters() {
            if (this.erasedParameters == null) {
                TypeErasedMethod typeErasedMethod = this;
                synchronized (typeErasedMethod) {
                    if (this.erasedParameters == null) {
                        Collection parameters = super.getParameters();
                        if (parameters.isEmpty()) {
                            this.erasedParameters = Collections.emptyList();
                        } else {
                            ArrayList<JavaLocalVariable> parametersFound = new ArrayList<JavaLocalVariable>();
                            for (JavaLocalVariable param : parameters) {
                                JavaType paramType = param.getResolvedType();
                                if (TypeErasedClass.this.eraseMember(this) && paramType != null && (paramType.hasTypeParameters() || paramType.getElementKind() == 10)) {
                                    parametersFound.add(new TypeErasedParameter(param.getLocalVariableErasure()));
                                    continue;
                                }
                                parametersFound.add(param);
                            }
                            this.erasedParameters = parametersFound;
                        }
                    }
                }
            }
            return this.erasedParameters;
        }

        @Override
        public JavaMethod getMethodErasure() {
            return this;
        }

        @Override
        public Collection<JavaTypeVariable> getTypeParameters() {
            if (!TypeErasedClass.this.eraseMember(this)) {
                return super.getTypeParameters();
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        public JavaTypeVariable getTypeParameter(String name) {
            if (!TypeErasedClass.this.eraseMember(this)) {
                return super.getTypeParameter(name);
            }
            return null;
        }

        @Override
        public boolean hasTypeParameters() {
            if (!TypeErasedClass.this.eraseMember(this)) {
                return super.hasTypeParameters();
            }
            return false;
        }

        private class TypeErasedParameter
        extends WrapperLocalVariable {
            private TypeErasedParameter(JavaLocalVariable baseVariable) {
                super(baseVariable);
            }

            private JavaType eraseResolvedType(JavaType resolvedType) {
                if (!TypeErasedClass.this.eraseMember(TypeErasedMethod.this)) {
                    return resolvedType;
                }
                if (resolvedType != null) {
                    if (resolvedType.isArray()) {
                        JavaType resolvedComponentType = this.eraseResolvedType(resolvedType.getComponentType());
                        return CommonUtilities.createArrayType(TypeErasedClass.this.provider, resolvedComponentType, 1);
                    }
                    if (resolvedType.getElementKind() == 10) {
                        return resolvedType.getTypeErasure();
                    }
                    if (resolvedType.hasTypeParameters()) {
                        return new TypeErasedClass(TypeErasedClass.this.provider, resolvedType);
                    }
                }
                return resolvedType;
            }

            @Override
            public JavaType getResolvedType() {
                return this.eraseResolvedType(super.getResolvedType());
            }

            @Override
            public JavaElement getOwner() {
                return TypeErasedMethod.this;
            }

            @Override
            public JavaLocalVariable getLocalVariableErasure() {
                return this;
            }
        }
    }
}

