/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.AbstractType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.util.Conversions;

public class IntersectionType
extends AbstractType {
    private List<JavaType> javaTypes;
    private JavaProvider provider;

    public IntersectionType(List<JavaType> javaTypes, JavaProvider provider) {
        this.javaTypes = javaTypes;
        this.provider = provider;
    }

    public List<JavaType> getTypes() {
        return new ArrayList<JavaType>(this.javaTypes);
    }

    @Override
    public int getElementKind() {
        return 12;
    }

    @Override
    public String getName() {
        return this.getBuffer(0);
    }

    @Override
    public String getQualifiedName() {
        return this.getBuffer(1);
    }

    @Override
    public String getVMName() {
        return this.getBuffer(2);
    }

    @Override
    public String getDescriptor() {
        return this.getBuffer(3);
    }

    @Override
    public String getUniqueIdentifier() {
        return this.getBuffer(4);
    }

    @Override
    public JavaClass getTypeErasure() {
        return this.provider.getClassByVMName("java/lang/Object");
    }

    @Override
    public String getTypeSignature() {
        return this.getBuffer(5);
    }

    @Override
    public String getRawName() {
        return this.getBuffer(6);
    }

    @Override
    public JavaFile getFile() {
        return null;
    }

    @Override
    public Set getHierarchy() {
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean isSubtypeOf(JavaType superType) {
        return Conversions.isSubtypeOf(this, superType);
    }

    @Override
    public JavaProvider getProvider() {
        return this.provider;
    }

    private String getBuffer(int whichOne) {
        StringBuilder buf = new StringBuilder();
        boolean addAnd = false;
        block9: for (JavaType javaType : this.javaTypes) {
            if (javaType == null) continue;
            if (addAnd) {
                buf.append(" & ");
            } else {
                addAnd = true;
            }
            switch (whichOne) {
                case 0: {
                    buf.append(javaType.getName());
                    continue block9;
                }
                case 1: {
                    buf.append(javaType.getQualifiedName());
                    continue block9;
                }
                case 2: {
                    buf.append(javaType.getVMName());
                    continue block9;
                }
                case 3: {
                    buf.append(javaType.getDescriptor());
                    continue block9;
                }
                case 4: {
                    buf.append(javaType.getUniqueIdentifier());
                    continue block9;
                }
                case 5: {
                    buf.append(javaType.getTypeSignature());
                    continue block9;
                }
                case 6: {
                    buf.append(javaType.getRawName());
                    continue block9;
                }
            }
            assert (false);
        }
        return buf.toString();
    }

    @Override
    public JavaType getQualifyingType() {
        return null;
    }

    @Override
    public void setQualifyingType(JavaType qualifyingType) {
    }
}

