/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.internal.InternalAnnotationComponent;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;

public class AnnotationComponents
extends AbstractMap {
    private final JavaType annotationType;
    private final ComponentSet entries = new ComponentSet();

    public static AnnotationComponents createInstance(JavaType annotationType) {
        return new AnnotationComponents(annotationType);
    }

    private AnnotationComponents(JavaType annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Set entrySet() {
        return this.entries;
    }

    public void assignValue(String key, Object value) {
        this.assignValue(key, value, null);
    }

    public void assignValue(String key, Object value, Object unresolvedValue) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        for (InternalAnnotationComponent c : this.entries.getEntries()) {
            if (!key.equals(c.getKey())) continue;
            c.value = value;
            c.unresolvedValue = unresolvedValue;
            return;
        }
    }

    private class ComponentSet
    extends AbstractSet {
        private List entries = null;

        private ComponentSet() {
        }

        @Override
        public int size() {
            return this.getEntries().size();
        }

        @Override
        public void clear() {
            this.entries = null;
        }

        @Override
        public Iterator iterator() {
            return this.getEntries().iterator();
        }

        private List getEntries() {
            if (this.entries == null) {
                this.buildEntries();
            }
            return this.entries;
        }

        private void buildEntries() {
            if (AnnotationComponents.this.annotationType == null || !AnnotationComponents.this.annotationType.isAnnotation()) {
                this.entries = Collections.EMPTY_LIST;
            } else {
                Collection<JavaMethod> things = AnnotationComponents.this.annotationType.getDeclaredMethods();
                int count = things.size();
                InternalAnnotationComponent[] array = new InternalAnnotationComponent[count];
                Iterator<JavaMethod> iterator = AnnotationComponents.this.annotationType.getDeclaredMethods().iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    JavaMethod thing = iterator.next();
                    array[i++] = new InternalAnnotationComponent(thing);
                }
                this.entries = Arrays.asList(array);
            }
        }
    }
}

