/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.util.Date;
import java.util.GregorianCalendar;

public class JarIndexEntry {
    private final String _name;
    private final long _compressedSize;
    private final byte[] _size;
    private final Date _time;

    JarIndexEntry(String name, int compressedSize, int size, int dostime) {
        this._name = name;
        this._compressedSize = compressedSize;
        this._size = JarIndexEntry.sizeToByteArray(size);
        this._time = JarIndexEntry.dostime2Date(dostime);
    }

    JarIndexEntry(String name, long compressedSize, long size, long time) {
        this._name = name;
        this._compressedSize = compressedSize;
        this._size = JarIndexEntry.sizeToByteArray(size);
        this._time = new Date(time);
    }

    public String getName() {
        return this._name;
    }

    public long getSize() {
        return JarIndexEntry.sizeToLong(this._size);
    }

    @Deprecated
    public long getCompressedSize() {
        return this._compressedSize;
    }

    public Date getTime() {
        return this._time;
    }

    private static Date dostime2Date(int dostime) {
        GregorianCalendar cal = new GregorianCalendar((dostime >> 25 & 0x7F) + 80, (dostime >> 21 & 0xF) - 1, dostime >> 16 & 0x1F, dostime >> 11 & 0x1F, dostime >> 5 & 0x3F, dostime << 1 & 0x3E);
        return cal.getTime();
    }

    private static long sizeToLong(byte[] size) {
        long ret = 0L;
        for (int i = 3; i >= 0; --i) {
            ret = ret << 8 | (long)(size[i] & 0xFF);
        }
        return ret;
    }

    private static byte[] sizeToByteArray(long size) {
        byte[] ret = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ret[i] = (byte)(size & 0xFFL);
            size >>= 8;
        }
        return ret;
    }
}

