/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import oracle.javatools.ui.themes.Themes;

public final class TaskButton
extends JButton {
    private static final HashMap<String, List<TaskButton>> _buttonGroup2ActiveTaskButtons = new HashMap();
    private static final HashMap<String, List<TaskButton>> _allMembersOfThisGroup = new HashMap();
    private static final String PART_ID = "taskbutton";
    private final Rectangle _scratch = new Rectangle();
    private final String _buttonGroupName;

    public TaskButton() {
        this("none");
    }

    public TaskButton(String buttonGroup) {
        this.setOpaque(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 5));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        String string = this._buttonGroupName = buttonGroup != null ? buttonGroup : "default";
        if (!_buttonGroup2ActiveTaskButtons.containsKey(this._buttonGroupName)) {
            _buttonGroup2ActiveTaskButtons.put(this._buttonGroupName, new ArrayList());
        }
        if (!_allMembersOfThisGroup.containsKey(this._buttonGroupName)) {
            _allMembersOfThisGroup.put(this._buttonGroupName, new ArrayList());
        }
        _allMembersOfThisGroup.get(this._buttonGroupName).add(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ((List)_buttonGroup2ActiveTaskButtons.get(TaskButton.this._buttonGroupName)).add(TaskButton.this);
                TaskButton.this.repaintAllFromButtonGroup();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((List)_buttonGroup2ActiveTaskButtons.get(TaskButton.this._buttonGroupName)).remove(TaskButton.this);
                TaskButton.this.repaintAllFromButtonGroup();
            }
        });
    }

    private void repaintAllFromButtonGroup() {
        for (TaskButton taskButton : _allMembersOfThisGroup.get(this._buttonGroupName)) {
            taskButton.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.updateForeground();
        Themes.paintBackground((Graphics)g, (String)PART_ID, (String)this.themeState(), (Rectangle)this.rectangle(0, 0, this.getWidth(), this.getHeight()));
        super.paintComponent(g);
        g.setColor(this.themeColor("linecolor"));
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    private void updateForeground() {
        this.setForeground(this.themeColor("foreground"));
    }

    private Color themeColor(String colorName) {
        return this.themeColor(colorName, this.themeState());
    }

    private Color themeColor(String colorName, String themeState) {
        return Themes.getActiveTheme().getStateProperties(PART_ID, themeState).getColor(colorName);
    }

    private String themeState() {
        if (this.getModel().isArmed() || this.getModel().isPressed()) {
            return "mousedown";
        }
        if (this.getModel().isRollover() || this.hasFocusAndOthersAreNotRollover().booleanValue()) {
            return "mouseover";
        }
        return "normal";
    }

    private Boolean hasFocusAndOthersAreNotRollover() {
        return this.hasFocus() && _buttonGroup2ActiveTaskButtons.get(this._buttonGroupName).size() == 0;
    }

    private Rectangle rectangle(int x, int y, int width, int height) {
        this._scratch.setBounds(x, y, width, height);
        return this._scratch;
    }
}

