/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.file.LibraryPaths;
import oracle.ide.file.Path;
import oracle.ide.file.ProjectCache;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.ContentFilterCustomizer;
import oracle.ide.model.ContentSet;
import oracle.ide.model.DefaultFilter;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.ApplicationChangeEvent;
import oracle.ide.navigator.ApplicationChangeListener;
import oracle.ide.navigator.ApplicationNavigatorWindow;
import oracle.ide.navigator.ApplicationWrapper;
import oracle.ide.navigator.AsyncNavigatorWindow;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.Res;
import oracle.ide.navigator.ViewSupport;
import oracle.ide.net.URLPath;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.PropertyAccess;
import oracle.ideimpl.navigator.NavigatorArb;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.file.JavaProjectCache;

public final class ProjectNavigatorWindow
extends DefaultNavigatorWindow
implements ContentFilterCustomizer,
ApplicationChangeListener,
AsyncNavigatorWindow {
    private final List _inits;
    private String _tabName;
    private final ApplicationWrapper _applicationWrapper;
    private static final String NAVIGATOR_ID = "project-navigator";
    private static boolean FORCE_ROOT_VISIBLE = Boolean.getBoolean("ide.navigator.show.root");
    private final Map _expansionStates = new WeakHashMap();
    private final Map _selectionStates = new WeakHashMap();
    private Workspace _currentWorkspace;
    private Controller _controller;
    private static final String CONFIRM_SEARCH_APPLICATION_KEY = DefaultNavigatorManager.class.getName() + "confirmSearch";
    private static final String CONFIRM_ADD_TO_WORKING_SET_KEY = DefaultNavigatorManager.class.getName() + "confirmAddToWorkingSet";

    ProjectNavigatorWindow(ApplicationWrapper wrapper, Context context, ViewId viewId, List initFactories) {
        super(ProjectNavigatorWindow.initContext(context, wrapper), viewId.getId());
        this._inits = ProjectNavigatorWindow.newNavigatorInits(initFactories, this, context);
        this._applicationWrapper = wrapper;
        this._tabName = Res.getString(11);
    }

    ProjectNavigatorWindow(Context context, ViewId viewId, List initFactories, String tabName) {
        super(context, viewId.getId());
        this._inits = ProjectNavigatorWindow.newNavigatorInits(initFactories, this, context);
        this._applicationWrapper = null;
        this._tabName = tabName;
    }

    @Override
    protected String getNavigatorID() {
        return NAVIGATOR_ID;
    }

    @Override
    public String getTabName() {
        return this._tabName;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    protected boolean isSaveExpansionState() {
        return true;
    }

    private void initComparator(TNode tnode) {
        if (tnode != null) {
            tnode.setComparator(DefaultFilter.folderFirstComparator);
        }
    }

    private static Context initContext(Context context, ApplicationWrapper wrapper) {
        context.setElement((Element)wrapper);
        return context;
    }

    private static ArrayList newNavigatorInits(List initFactories, ProjectNavigatorWindow navWin, Context context) {
        ArrayList<NavigatorInit> inits;
        if (initFactories != null) {
            inits = new ArrayList(initFactories.size());
            for (NavigatorInitFactory initFactory : initFactories) {
                try {
                    NavigatorInit init = initFactory.newNavigatorInit(navWin, context);
                    inits.add(init);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            inits.trimToSize();
        } else {
            inits = new ArrayList<NavigatorInit>(0);
        }
        return inits;
    }

    public void applicationChanged(ApplicationChangeEvent e) {
        TreeExplorer treeExplorer = this.getTreeExplorer();
        if (FORCE_ROOT_VISIBLE) {
            this.setRootVisible(true);
        }
        Workspace workspace = e.getApplication();
        int stateChange = e.getStateChange();
        if (stateChange == 1) {
            if (workspace != null && Ide.getWorkspaces().containsChild((Element)workspace)) {
                URL workspaceURL = workspace.getURL();
                TNode root = treeExplorer.getRoot();
                List expansionState = ExplorerContext.storeExpansionState((TNode)root, (TreeExplorer)treeExplorer);
                this._expansionStates.put(workspaceURL, expansionState);
                List selectionState = ExplorerContext.storeSelectionState((TreeExplorer)treeExplorer);
                this._selectionStates.put(workspaceURL, selectionState);
            }
            this._applicationWrapper.setApplication(null);
            this._currentWorkspace = null;
        } else if (stateChange == 2) {
            this._currentWorkspace = workspace;
            this._applicationWrapper.setApplication(this._currentWorkspace);
            UpdateMessage.fireStructureChanged((Subject)this._applicationWrapper);
            treeExplorer.getContext();
            this.fireTitleChangeListener();
            if (workspace != null) {
                Enumeration tns;
                URL workspaceURL = workspace.getURL();
                List expansionState = (List)this._expansionStates.remove(workspaceURL);
                ViewSupport viewSupport = this.getNavigatorInit(ViewSupport.class);
                if (viewSupport != null) {
                    ViewSupport.updateView(workspace);
                }
                Context newApplicationWrapperContext = Context.newIdeContext((Element)this._applicationWrapper);
                newApplicationWrapperContext.setBoolean("NAVIGATOR.ForceExplorerReroot", true);
                treeExplorer.setContext(newApplicationWrapperContext);
                TNode root = treeExplorer.getRoot();
                this.initComparator(root);
                ExplorerContext.restoreExpansionState((TNode)root, (TreeExplorer)treeExplorer, (List)expansionState);
                List<TreePath> selectionState = (List<TreePath>)this._selectionStates.remove(workspaceURL);
                if (selectionState == null && (tns = root.getChildTNodes()).hasMoreElements()) {
                    TNode firstChild = (TNode)tns.nextElement();
                    TreePath path = new TreePath(firstChild.getPath());
                    selectionState = Collections.singletonList(path);
                }
                ExplorerContext.restoreSelectionState((TreeExplorer)treeExplorer, (List)selectionState);
            }
        }
    }

    @Override
    public final Context getContext(EventObject event) {
        Context context = super.getContext(event);
        context.setWorkspace(this._currentWorkspace);
        TreePath[] paths = this.getTree().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            context.setProject(null);
        }
        this.copyPreferencesTo(context);
        return context;
    }

    @Override
    public final Controller getController() {
        if (this._controller == null) {
            ArrayList<Controller> controllers = new ArrayList<Controller>();
            for (NavigatorInit init : this._inits) {
                try {
                    Controller initController = init.getController();
                    if (initController == null) continue;
                    controllers.add(initController);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            try {
                Controller superController = super.getController();
                if (superController != null) {
                    controllers.add(superController);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this._controller = new ChainedController(controllers);
        }
        return this._controller;
    }

    @Override
    protected void showPopupInBlankSpace(ContextMenu contextMenu, MouseEvent e) {
        Context context = this.getContext(e);
        Workspace workspace = context.getWorkspace();
        context.setElement((Element)workspace);
        context.setNode((Node)workspace);
        contextMenu.show(context);
    }

    public final void copyPreferencesTo(Context context) {
        for (NavigatorInit init : this._inits) {
            try {
                init.copyPreferencesTo(context);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public final void setToolbarVisible(boolean visible) {
        Toolbar toolbar;
        boolean toolbarJustCreated = visible && this.getToolbar() == null;
        super.setToolbarVisible(visible);
        if (toolbarJustCreated && (toolbar = this.getToolbar()) != null) {
            for (NavigatorInit init : this._inits) {
                try {
                    init.initToolbar(toolbar);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    @Override
    public final void loadLayout(PropertyAccess layout) {
        super.loadLayout(layout);
        for (NavigatorInit init : this._inits) {
            try {
                init.loadPreferences(layout);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public final void saveLayout(PropertyAccess layout) {
        super.saveLayout(layout);
        for (NavigatorInit init : this._inits) {
            try {
                init.savePreferences(layout);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_ideprojectspanel_html");
    }

    public boolean openContext(Context context) {
        return this.openContext(context, true);
    }

    public boolean openContext(Context context, boolean activateDockable) {
        TreeExplorer explorer;
        if (context != null && context.getWorkspace() != null && (explorer = this.getTreeExplorer()) != null) {
            Workspaces folder;
            Node element;
            JTree tree;
            explorer.getContext();
            if (context.getBoolean("requestFocus") && (tree = explorer.getJTree()) != null) {
                tree.requestFocus();
            }
            if ((element = context.getNode()) == null) {
                element = (Node)NavigatorManager.getFolderFromContext((Context)context);
            }
            Project project = context.getProject();
            if (element instanceof Workspace) {
                project = null;
                folder = Ide.getWorkspaces();
            } else {
                if (element instanceof Project) {
                    project = null;
                    Workspace folder2 = context.getWorkspace();
                    TNode rootNode = explorer.searchTNode((Element)folder2, null, context);
                    this.searchInEntireApp((Element)element, rootNode, context);
                    return false;
                }
                final boolean inProject = ProjectNavigatorWindow.containsNode(context.getWorkspace(), project, element);
                if (inProject) {
                    final Project fProject = project;
                    final Node fElement = element;
                    final Context fContext = context;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TNode projectNode = explorer.searchTNode((Element)fProject, explorer.getRoot(), fContext);
                            if (!ProjectNavigatorWindow.shouldAddToWorkingSet((Element)fElement, fProject, ProjectNavigatorWindow.this)) {
                                return;
                            }
                            projectNode = explorer.searchTNode((Element)fProject, explorer.getRoot(), fContext);
                            if (inProject && projectNode != null) {
                                ProjectNavigatorWindow.this.searchInEntireApp((Element)fElement, projectNode, fContext);
                            }
                        }
                    });
                    return true;
                }
                folder = project;
            }
            SearchScope searchScope = SearchScope.SEARCH_CURRENT_PROJECT;
            if (folder == null) {
                folder = ProjectNavigatorWindow.findProject(context.getWorkspace(), null, element);
                if (folder == null) {
                    return false;
                }
            } else {
                if (context.getBoolean("oracle.ide.model.ProjectContent.AutoSelecter")) {
                    return false;
                }
                String libName = ProjectNavigatorWindow.findLibraries(context.getWorkspace(), project, element);
                if (libName != null) {
                    this.copyPreferencesTo(context);
                    if (!context.getBoolean("show-libs")) {
                        String prompt = NavigatorArb.format(17, element.getShortLabel(), libName);
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)prompt, (String)NavigatorArb.getString(16), null);
                        return true;
                    }
                } else {
                    String prompt = NavigatorArb.format(6, element.getShortLabel(), folder.getShortLabel(), context.getWorkspace().getShortLabel());
                    String title = NavigatorArb.getString(5);
                    if (!MessageDialog.optionalConfirm((String)CONFIRM_SEARCH_APPLICATION_KEY, (Component)Ide.getMainWindow(), (Object)prompt, (String)title, null)) {
                        return false;
                    }
                    searchScope = SearchScope.SEARCH_CURRENT_WORKSPACE;
                    Project elementProject = ProjectNavigatorWindow.findProject(context.getWorkspace(), project, element);
                    if (context.getBoolean("REFRESH_CMD_ID.promptUserWhenNotFound")) {
                        this.displayNodeNotFound(element.getShortLabel(), context.getWorkspace().getShortLabel());
                    }
                    if (elementProject == null) {
                        return false;
                    }
                    project = elementProject;
                }
            }
            TNode rootNode = null;
            if (project != null) {
                Workspace workspace = context.getWorkspace();
                TNode workspaceNode = explorer.getRoot();
                TNode projectNode = null;
                if (searchScope != SearchScope.SEARCH_ALL_WORKSPACES) {
                    if (workspace != null && workspaceNode != null) {
                        NavigatorManager navMan;
                        NavigatorWindow navWin;
                        if (workspaceNode.getData().getData() != workspace && (navWin = (navMan = this.getManager()).getNavigatorWindow()) instanceof ApplicationNavigatorWindow) {
                            ((ApplicationNavigatorWindow)navWin).selectApplication(workspace);
                        }
                        explorer.open(workspaceNode);
                    }
                    if (project != null && (projectNode = explorer.searchTNode((Element)project, workspaceNode, context)) != null) {
                        explorer.open(projectNode);
                    }
                    if (projectNode == null) {
                        projectNode = workspaceNode;
                    }
                }
                if (element instanceof Workspace) {
                    rootNode = workspaceNode;
                } else if (element instanceof Project) {
                    rootNode = element == project ? projectNode : workspaceNode;
                } else if (projectNode != null) {
                    rootNode = projectNode;
                }
            } else {
                rootNode = explorer.searchTNode((Element)folder, null, context);
            }
            if (ProjectNavigatorWindow.hasWorkingSetSupport(this)) {
                if (!ProjectNavigatorWindow.shouldAddToWorkingSet((Element)element, project, this)) {
                    return false;
                }
                TNode n = explorer.searchTNode((Element)project, explorer.getRoot(), context);
                if (n != null) {
                    rootNode = n;
                }
            }
            this.searchInEntireApp((Element)element, rootNode, context);
            return true;
        }
        return false;
    }

    public boolean openContext_Original(Context context, boolean activateDockable) {
        TreeExplorer explorer;
        if (context != null && context.getWorkspace() != null && (explorer = this.getTreeExplorer()) != null) {
            SearchScope searchScope;
            Workspaces folder;
            Node element;
            JTree tree;
            explorer.getContext();
            if (context.getBoolean("requestFocus") && (tree = explorer.getJTree()) != null) {
                tree.requestFocus();
            }
            if ((element = context.getNode()) == null) {
                element = NavigatorManager.getFolderFromContext((Context)context);
            }
            Project project = context.getProject();
            if (element instanceof Workspace) {
                project = null;
                folder = Ide.getWorkspaces();
            } else if (element instanceof Project) {
                project = null;
                folder = context.getWorkspace();
            } else {
                folder = project;
            }
            if (folder == null) {
                project = this.findParentProjectInWorkspace(context.getWorkspace(), (Element)element);
                if (project != null) {
                    folder = project;
                    searchScope = SearchScope.SEARCH_CURRENT_PROJECT;
                } else {
                    searchScope = SearchScope.SEARCH_ALL_WORKSPACES;
                }
            } else if (folder.containsChild((Element)element) || context.getWorkspace().size() <= 1) {
                searchScope = SearchScope.SEARCH_CURRENT_PROJECT;
            } else {
                if (context.getBoolean("oracle.ide.model.ProjectContent.AutoSelecter")) {
                    return false;
                }
                String prompt = NavigatorArb.format(6, element.getShortLabel(), folder.getShortLabel(), context.getWorkspace().getShortLabel());
                String title = NavigatorArb.getString(5);
                if (!MessageDialog.optionalConfirm((String)CONFIRM_SEARCH_APPLICATION_KEY, (Component)Ide.getMainWindow(), (Object)prompt, (String)title, null)) {
                    return false;
                }
                searchScope = SearchScope.SEARCH_CURRENT_WORKSPACE;
                DependencyConfiguration dc = DependencyConfiguration.getInstance((Project)project);
                List dependencyList = dc.getAllDependenciesList();
                Project projectFromDependablesList = this.findParentProjectFromDependablesList(dependencyList, (Element)element);
                if (projectFromDependablesList != null) {
                    project = projectFromDependablesList;
                }
                if (!project.containsChild((Element)element)) {
                    Project projectContainingElementInWorkspace = this.findParentProjectInWorkspace(context.getWorkspace(), (Element)element);
                    if (projectContainingElementInWorkspace != null) {
                        project = projectContainingElementInWorkspace;
                    }
                    if (context.getBoolean("REFRESH_CMD_ID.promptUserWhenNotFound") && projectContainingElementInWorkspace == null) {
                        this.displayNodeNotFound(element.getShortLabel(), context.getWorkspace().getShortLabel());
                        return false;
                    }
                }
            }
            TNode rootNode = null;
            if (project != null) {
                Workspace workspace = context.getWorkspace();
                TNode workspaceNode = explorer.getRoot();
                TNode projectNode = null;
                if (searchScope != SearchScope.SEARCH_ALL_WORKSPACES) {
                    if (workspace != null && workspaceNode != null) {
                        NavigatorManager navMan;
                        NavigatorWindow navWin;
                        if (workspaceNode.getData().getData() != workspace && (navWin = (navMan = this.getManager()).getNavigatorWindow()) instanceof ApplicationNavigatorWindow) {
                            ((ApplicationNavigatorWindow)navWin).selectApplication(workspace);
                        }
                        explorer.open(workspaceNode);
                    }
                    if (project != null && (projectNode = explorer.searchTNode((Element)project, workspaceNode, context)) != null) {
                        explorer.open(projectNode);
                    }
                    if (projectNode == null) {
                        projectNode = workspaceNode;
                    }
                }
                if (element instanceof Workspace) {
                    rootNode = workspaceNode;
                } else if (element instanceof Project) {
                    rootNode = element == project ? projectNode : workspaceNode;
                } else if (projectNode != null) {
                    rootNode = projectNode;
                }
            } else {
                rootNode = explorer.searchTNode((Element)folder, null, context);
            }
            if (ProjectNavigatorWindow.hasWorkingSetSupport(this)) {
                Project parentProject;
                if (rootNode == null) {
                    parentProject = ProjectNavigatorWindow.findContainingProject((Element)element, explorer);
                } else {
                    Object rootData = rootNode.getData().getData();
                    if (rootData instanceof Workspace) {
                        parentProject = ProjectNavigatorWindow.findContainingProject((Element)element, (Workspace)rootData);
                    } else {
                        Object object = parentProject = project.containsChild((Element)element) ? project : null;
                    }
                }
                if (parentProject != null) {
                    if (!ProjectNavigatorWindow.shouldAddToWorkingSet((Element)element, parentProject, this)) {
                        return false;
                    }
                    TNode n = explorer.searchTNode((Element)project, explorer.getRoot(), context);
                    if (n != null) {
                        rootNode = n;
                    }
                }
            }
            this.searchInEntireApp((Element)element, rootNode, context);
            return true;
        }
        return false;
    }

    private void searchInEntireApp(final Element element, final TNode rootNode, final Context context) {
        Runnable explorerSearch = new Runnable(){

            @Override
            public void run() {
                TNode tnode = ProjectNavigatorWindow.this.getTreeExplorer().findTNode(element, rootNode, context);
                if (tnode != null) {
                    Workspace actualWorkspace = (Workspace)tnode.getAncestor(Workspace.class, true);
                    Project actualProject = (Project)tnode.getAncestor(Project.class, true);
                    if (actualProject != context.getProject() || actualWorkspace != context.getWorkspace()) {
                        Context newContext = new Context(context);
                        newContext.setProject(actualProject);
                        if (actualWorkspace != null) {
                            newContext.setWorkspace(actualWorkspace);
                        }
                        EditorManager.getEditorManager().replaceEditors(context, newContext);
                    }
                    ProjectNavigatorWindow.this.getTreeExplorer().setSelected(tnode);
                    return;
                }
                if (context.getBoolean("REFRESH_CMD_ID.promptUserWhenNotFound")) {
                    if (rootNode != null && rootNode.getData() != null) {
                        ProjectNavigatorWindow.this.displayNodeNotFound(element.getShortLabel(), rootNode.getData().getShortLabel());
                    } else {
                        ProjectNavigatorWindow.this.displayNodeNotFound(element.getShortLabel(), context.getWorkspace().getShortLabel());
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            explorerSearch.run();
        } else {
            SwingUtilities.invokeLater(explorerSearch);
        }
    }

    private void displayNodeNotFound(String target, String searchSpaceName) {
        String prompt = NavigatorArb.format(7, target, searchSpaceName);
        String title = StringUtils.stripMnemonic((String)IdeArb.getString((int)354));
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)prompt, (String)title, null);
    }

    private Project findParentProjectInWorkspace(Workspace workspace, Element targetElement) {
        Project project = null;
        if (workspace != null) {
            Iterator projectsIterator = workspace.projects().iterator();
            while (project == null && projectsIterator.hasNext()) {
                Project p = (Project)projectsIterator.next();
                if (!p.containsChild(targetElement)) continue;
                project = p;
            }
        }
        return project;
    }

    private Project findParentProjectFromDependablesList(List<Dependable> dependables, Element targetElement) {
        Project project = null;
        if (dependables != null) {
            Iterator<Dependable> dependablesIterator = dependables.iterator();
            while (project == null && dependablesIterator.hasNext()) {
                Project p;
                Dependable dependable = dependablesIterator.next();
                Element source = dependable.getSource();
                if (!(source instanceof Project) || !(p = (Project)source).containsChild(targetElement)) continue;
                project = p;
            }
        }
        return project;
    }

    private static boolean shouldAddToWorkingSet(Element element, Project project, NavigatorWindow navigator) {
        WorkingSet activeWorkingSet;
        if (ProjectNavigatorWindow.hasWorkingSetSupport(navigator) && (activeWorkingSet = ProjectNavigatorWindow.getEditableWorkingSet()) != null) {
            PatternFilters workingSetFilters = activeWorkingSet.getPatternFilters(project);
            boolean projectExcluded = activeWorkingSet.isExcluded(project);
            if (!projectExcluded && workingSetFilters == null) {
                return true;
            }
            ArrayList<String> relPaths = new ArrayList<String>();
            if (workingSetFilters == null && projectExcluded) {
                workingSetFilters = activeWorkingSet.getOrCreatePatternFilters(project);
                workingSetFilters.setFilters(new PatternFilter[0]);
            }
            if (workingSetFilters != null) {
                URL url = ((Locatable)element).getURL();
                ProjectContent projectContent = ProjectContent.getInstance((PropertyStorage)project);
                ListStructure contentSets = projectContent.getContentSetList();
                boolean foundPotentialContentsetOwner = false;
                for (int i = 0; i < contentSets.size(); ++i) {
                    URL[] allURLs;
                    ContentSet contentSet;
                    String contentSetKey = contentSets.get(i).toString();
                    if ("oracle.ide.model.ResourcePaths/resourcesContentSet".equals(contentSetKey) || !(contentSet = projectContent.getContentSet(contentSetKey)).canHaveMember(url)) continue;
                    foundPotentialContentsetOwner = true;
                    URLPath srcPath = contentSet.getAllRootDirs();
                    for (URL nextURL : allURLs = srcPath.getEntries()) {
                        String relPath = new URLPath(nextURL).toRelativePath(url);
                        if (relPath == null || workingSetFilters.isIncluded(relPath)) continue;
                        relPaths.add(relPath);
                    }
                }
                if (!foundPotentialContentsetOwner || relPaths.size() > 0) {
                    URL[] allURLs;
                    ContentSet resourcesContentSet = projectContent.getContentSet("oracle.ide.model.ResourcePaths/resourcesContentSet");
                    URLPath srcPath = resourcesContentSet.getAllRootDirs();
                    for (URL nextURL : allURLs = srcPath.getEntries()) {
                        String relPath = new URLPath(nextURL).toRelativePath(url);
                        if (relPath == null || workingSetFilters.isIncluded(relPath)) continue;
                        relPaths.add(relPath);
                    }
                }
            }
            if (relPaths.size() > 0 || projectExcluded) {
                String prompt = NavigatorArb.format(10, element.getShortLabel(), project.getShortLabel());
                String title = NavigatorArb.getString(9);
                if (MessageDialog.optionalConfirm((String)CONFIRM_ADD_TO_WORKING_SET_KEY, (Component)Ide.getMainWindow(), (Object)prompt, (String)title, (String)"f1_idedaddtoworkingset_html")) {
                    if (projectExcluded) {
                        activeWorkingSet.includeProject(project);
                        Workspace workspace = project.getWorkspace();
                        if (workspace != null) {
                            UpdateMessage.fireStructureChanged((Subject)workspace);
                        }
                    }
                    if (relPaths.size() > 0) {
                        for (String path : relPaths) {
                            workingSetFilters.addInclude(path);
                        }
                        UpdateMessage.fireStructureChanged((Subject)project);
                    }
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    private <T> T getNavigatorInit(Class<T> clazz) {
        for (Object init : this._inits) {
            if (!clazz.isInstance(init)) continue;
            return clazz.cast(init);
        }
        return null;
    }

    private static WorkingSet getEditableWorkingSet() {
        WorkingSet activeWorkingSet;
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        if (activeWorkspace != null && (activeWorkingSet = WorkingSets.getInstance((Workspace)activeWorkspace).getCurrentWorkingSet()) != null && !WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(activeWorkingSet.getName())) {
            return activeWorkingSet;
        }
        return null;
    }

    private static Project findContainingProject(Element element, TreeExplorer explorer) {
        Enumeration enumeration = explorer.getRoot().getChildTNodes();
        while (enumeration.hasMoreElements()) {
            Workspace workspace;
            Project project;
            TNode tnode = (TNode)enumeration.nextElement();
            Element data = tnode.getData();
            if (!(data instanceof Workspace) || (project = ProjectNavigatorWindow.findContainingProject(element, workspace = (Workspace)data)) == null) continue;
            return project;
        }
        return null;
    }

    private static Project findContainingProject(Element element, Workspace workspace) {
        Iterator iterator = workspace.getChildren();
        while (iterator.hasNext()) {
            Project project;
            Element e = (Element)iterator.next();
            if (!(e instanceof Project) || !(project = (Project)e).containsChild(element)) continue;
            return project;
        }
        return null;
    }

    private static boolean hasWorkingSetSupport(NavigatorWindow navigator) {
        Context context = navigator.getContext();
        return context.getBoolean("enable-working-sets");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Project findProject(Workspace workspace, Project p, Node node) {
        PerformanceLogger.get().startTiming(ProjectNavigatorWindow.class.getName() + ".findProject()");
        Project result = null;
        try (ProjectCache cache = ProjectCache.getInstance((Workspace)workspace);){
            List<Project> dependencies = Collections.emptyList();
            if (p != null) {
                dependencies = cache.getTransitiveDependencies(p);
                result = ProjectNavigatorWindow.findProject(cache, node, dependencies);
            }
            if (result == null) {
                ArrayList<Project> allProjects = new ArrayList<Project>(workspace.projects());
                allProjects.removeAll(dependencies);
                result = ProjectNavigatorWindow.findProject(cache, node, allProjects);
            }
        }
        PerformanceLogger.get().stopTiming(ProjectNavigatorWindow.class.getName() + ".findProject()", "end", 10);
        return result;
    }

    private static final Project findProject(ProjectCache cache, Node node, Collection<Project> projects) {
        for (Project p : projects) {
            Path path = cache.getContentPath(p);
            if (!path.contains(node.getURL())) continue;
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean containsNode(Workspace workspace, Project project, Node node) {
        PerformanceLogger.get().startTiming(ProjectNavigatorWindow.class.getName() + ".containsNode()");
        boolean result = false;
        try (ProjectCache cache = ProjectCache.getInstance((Workspace)workspace);){
            Path path = cache.getContentPath(project);
            result = path.contains(node.getURL());
        }
        PerformanceLogger.get().stopTiming(ProjectNavigatorWindow.class.getName() + ".containsNode()", "", 10);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String findLibraries(Workspace workspace, Project project, Node element) {
        try (JavaProjectCache cache = JavaProjectCache.getInstance((Workspace)workspace);){
            String string;
            List libraries = cache.getLibraryPaths(project);
            URL elementURL = element.getURL();
            for (LibraryPaths library : libraries) {
                if (!library.getSourcePath().contains(elementURL) && !library.getClassPath().contains(elementURL)) continue;
                String string2 = library.getLibraryName();
                return string2;
            }
            LibraryPaths jdk = cache.getJdkPaths(project);
            if (jdk.getSourcePath().contains(elementURL)) {
                string = jdk.getLibraryName();
                return string;
            }
            string = null;
            return string;
        }
    }

    private static class ChainedController
    implements Controller {
        private final ArrayList _controllers;

        ChainedController(ArrayList controllers) {
            this._controllers = controllers;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            for (Controller controller : this._controllers) {
                try {
                    if (!controller.handleEvent(action, context)) continue;
                    return true;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            for (Controller controller : this._controllers) {
                try {
                    if (!controller.update(action, context)) continue;
                    action.putValue("controller-handling-update", (Object)controller.getClass().getName());
                    return true;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            return false;
        }
    }

    private static enum SearchScope {
        SEARCH_CURRENT_PROJECT,
        SEARCH_CURRENT_WORKSPACE,
        SEARCH_ALL_WORKSPACES;

    }
}

