/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.DataObject;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.UnresolvedIdentifier;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.Identifier;
import oracle.olapi.syntax.parser.IdentifierResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnresolvedQuery
extends Query
implements UnresolvedIdentifier {
    private Identifier m_Identifier;
    private IdentifierResolver m_IDResolver;

    @Override
    public IdentifierResolver getIDResolver() {
        return this.m_IDResolver;
    }

    @Override
    public Identifier getIdentifier() {
        return this.m_Identifier;
    }

    public UnresolvedQuery(Identifier identifier, IdentifierResolver identifierResolver) {
        this.m_IDResolver = identifierResolver;
        this.m_Identifier = identifier;
        this.initialize();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.appendIdentifier(this.getIdentifier().toString());
    }

    @Override
    public DataObject validate(ValidationContext validationContext) {
        Query query = this.getIDResolver().getQuery(this.getIdentifier());
        if (query instanceof UnresolvedQuery) {
            validationContext.addUnresolvedID((UnresolvedQuery)query);
        } else if (null == query) {
            this.getIDResolver().error(this.getIdentifier());
        }
        return query;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return false;
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitUnresolvedQuery(this, object);
    }

    @Override
    public List<ColumnExpression> getColumnExpressions() {
        return null;
    }

    @Override
    public ColumnExpression getColumnExpression(String string) {
        return null;
    }

    @Override
    public String getName() {
        int n = this.getIdentifier().getNumComponents();
        return this.getIDResolver().getComponent(this.getIdentifier(), n - 1);
    }
}

