/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.BetweenCondition;
import oracle.olapi.syntax.BinaryOperatorExpression;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.IdentifierArgument;
import oracle.olapi.syntax.IsCondition;
import oracle.olapi.syntax.KeywordCatalog;
import oracle.olapi.syntax.LikeCondition;
import oracle.olapi.syntax.ListComparisonCondition;
import oracle.olapi.syntax.NumberExpression;
import oracle.olapi.syntax.RowFunctionExpression;
import oracle.olapi.syntax.StringExpression;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.UnaryOperatorExpression;
import oracle.olapi.syntax.ValueComparisonCondition;

public abstract class TypedExpression
extends Expression {
    private DataType m_DataType = null;

    protected TypedExpression() {
    }

    protected final void setDataType(DataType dataType) {
        this.m_DataType = dataType;
    }

    boolean matchesCategory(int n) {
        return this.getDataType().matchesCategory(n);
    }

    void validateType(int n) {
        this.getDataType().validateType(n);
    }

    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
    }

    public final DataType getDataType() {
        return this.m_DataType;
    }

    public final Condition isNull() {
        return new IsCondition(this);
    }

    public final Condition isNotNull() {
        return new IsCondition(this, true);
    }

    public final Condition isInfinite(boolean bl) {
        return new IsCondition(this, "INFINITE", bl);
    }

    public final Condition isNAN(boolean bl) {
        return new IsCondition(this, "NAN", bl);
    }

    public final Condition between(TypedExpression typedExpression, TypedExpression typedExpression2, boolean bl) {
        return new BetweenCondition(this, typedExpression, typedExpression2, bl);
    }

    public final Condition like(TypedExpression typedExpression) {
        return this.like(typedExpression, null, false);
    }

    public final Condition like(TypedExpression typedExpression, TypedExpression typedExpression2, boolean bl) {
        return new LikeCondition(this, "LIKE", typedExpression, typedExpression2, bl);
    }

    public final Condition like2(TypedExpression typedExpression, TypedExpression typedExpression2, boolean bl) {
        return new LikeCondition(this, "LIKE2", typedExpression, typedExpression2, bl);
    }

    public final Condition like4(TypedExpression typedExpression, TypedExpression typedExpression2, boolean bl) {
        return new LikeCondition(this, "LIKE4", typedExpression, typedExpression2, bl);
    }

    public final Condition likeC(TypedExpression typedExpression, TypedExpression typedExpression2, boolean bl) {
        return new LikeCondition(this, "LIKEC", typedExpression, typedExpression2, bl);
    }

    public final Condition in(TypedExpression[] typedExpressionArray) {
        return new ListComparisonCondition(this, "=", "ANY", typedExpressionArray);
    }

    public final Condition notIn(TypedExpression[] typedExpressionArray) {
        return new ListComparisonCondition(this, "!=", "ANY", typedExpressionArray);
    }

    public final Condition eq(TypedExpression typedExpression) {
        return new ValueComparisonCondition(this, "=", typedExpression);
    }

    public final Condition eq(double d) {
        return this.eq(new NumberExpression(d));
    }

    public final Condition eq(float f) {
        return this.eq(new NumberExpression(f));
    }

    public final Condition eq(int n) {
        return this.eq(new NumberExpression(n));
    }

    public final Condition eq(short s) {
        return this.eq(new NumberExpression(s));
    }

    public final Condition ge(TypedExpression typedExpression) {
        return new ValueComparisonCondition(this, ">=", typedExpression);
    }

    public final Condition ge(double d) {
        return this.ge(new NumberExpression(d));
    }

    public final Condition ge(float f) {
        return this.ge(new NumberExpression(f));
    }

    public final Condition ge(int n) {
        return this.ge(new NumberExpression(n));
    }

    public final Condition ge(short s) {
        return this.ge(new NumberExpression(s));
    }

    public final Condition gt(TypedExpression typedExpression) {
        return new ValueComparisonCondition(this, ">", typedExpression);
    }

    public final Condition gt(double d) {
        return this.gt(new NumberExpression(d));
    }

    public final Condition gt(float f) {
        return this.gt(new NumberExpression(f));
    }

    public final Condition gt(int n) {
        return this.gt(new NumberExpression(n));
    }

    public final Condition gt(short s) {
        return this.gt(new NumberExpression(s));
    }

    public final Condition le(TypedExpression typedExpression) {
        return new ValueComparisonCondition(this, "<=", typedExpression);
    }

    public final Condition le(double d) {
        return this.le(new NumberExpression(d));
    }

    public final Condition le(float f) {
        return this.le(new NumberExpression(f));
    }

    public final Condition le(int n) {
        return this.le(new NumberExpression(n));
    }

    public final Condition le(short s) {
        return this.le(new NumberExpression(s));
    }

    public final Condition lt(TypedExpression typedExpression) {
        return new ValueComparisonCondition(this, "<", typedExpression);
    }

    public final Condition lt(double d) {
        return this.lt(new NumberExpression(d));
    }

    public final Condition lt(float f) {
        return this.lt(new NumberExpression(f));
    }

    public final Condition lt(int n) {
        return this.lt(new NumberExpression(n));
    }

    public final Condition lt(short s) {
        return this.lt(new NumberExpression(s));
    }

    public final Condition ne(TypedExpression typedExpression) {
        return new ValueComparisonCondition(this, "!=", typedExpression);
    }

    public final Condition ne(double d) {
        return this.ne(new NumberExpression(d));
    }

    public final Condition ne(float f) {
        return this.ne(new NumberExpression(f));
    }

    public final Condition ne(int n) {
        return this.ne(new NumberExpression(n));
    }

    public final Condition ne(short s) {
        return this.ne(new NumberExpression(s));
    }

    public final TypedExpression div(double d) {
        return this.div(new NumberExpression(d));
    }

    public final TypedExpression div(float f) {
        return this.div(new NumberExpression(f));
    }

    public final TypedExpression div(int n) {
        return this.div(new NumberExpression(n));
    }

    public final TypedExpression div(TypedExpression typedExpression) {
        return new BinaryOperatorExpression(this, "/", typedExpression);
    }

    public final TypedExpression div(short s) {
        return this.div(new NumberExpression(s));
    }

    public final TypedExpression minus(double d) {
        return this.minus(new NumberExpression(d));
    }

    public final TypedExpression minus(float f) {
        return this.minus(new NumberExpression(f));
    }

    public final TypedExpression minus(int n) {
        return this.minus(new NumberExpression(n));
    }

    public final TypedExpression minus(TypedExpression typedExpression) {
        return new BinaryOperatorExpression(this, "-", typedExpression);
    }

    public final TypedExpression minus(short s) {
        return this.minus(new NumberExpression(s));
    }

    public final TypedExpression minus() {
        return new UnaryOperatorExpression("-", this);
    }

    public final TypedExpression plus(double d) {
        return this.plus(new NumberExpression(d));
    }

    public final TypedExpression plus(float f) {
        return this.plus(new NumberExpression(f));
    }

    public final TypedExpression plus(int n) {
        return this.plus(new NumberExpression(n));
    }

    public final TypedExpression plus(TypedExpression typedExpression) {
        return new BinaryOperatorExpression(this, "+", typedExpression);
    }

    public final TypedExpression plus(short s) {
        return this.plus(new NumberExpression(s));
    }

    public final TypedExpression times(double d) {
        return this.times(new NumberExpression(d));
    }

    public final TypedExpression times(float f) {
        return this.times(new NumberExpression(f));
    }

    public final TypedExpression times(int n) {
        return this.times(new NumberExpression(n));
    }

    public final TypedExpression times(TypedExpression typedExpression) {
        return new BinaryOperatorExpression(this, "*", typedExpression);
    }

    public final TypedExpression times(short s) {
        return this.times(new NumberExpression(s));
    }

    public final TypedExpression abs() {
        return new RowFunctionExpression("ABS", this);
    }

    public final TypedExpression acos() {
        return new RowFunctionExpression("ACOS", this);
    }

    public final TypedExpression asin() {
        return new RowFunctionExpression("ASIN", this);
    }

    public final TypedExpression atan() {
        return new RowFunctionExpression("ATAN", this);
    }

    public final TypedExpression atan2(TypedExpression typedExpression) {
        return new RowFunctionExpression("ATAN2", this, typedExpression);
    }

    public final TypedExpression bitAnd(TypedExpression typedExpression) {
        return new RowFunctionExpression("BITAND", this, typedExpression);
    }

    public final TypedExpression ceil() {
        return new RowFunctionExpression("CEIL", this);
    }

    public final TypedExpression cos() {
        return new RowFunctionExpression("COS", this);
    }

    public final TypedExpression cosh() {
        return new RowFunctionExpression("COSH", this);
    }

    public final TypedExpression exp() {
        return new RowFunctionExpression("EXP", this);
    }

    public final TypedExpression floor() {
        return new RowFunctionExpression("FLOOR", this);
    }

    public final TypedExpression ln() {
        return new RowFunctionExpression("LN", this);
    }

    public final TypedExpression log(TypedExpression typedExpression) {
        return new RowFunctionExpression("LOG", this, typedExpression);
    }

    public final TypedExpression mod(TypedExpression typedExpression) {
        return new RowFunctionExpression("MOD", this, typedExpression);
    }

    public final TypedExpression nanvl(TypedExpression typedExpression) {
        return new RowFunctionExpression("NANVL", this, typedExpression);
    }

    public final TypedExpression power(TypedExpression typedExpression) {
        return new RowFunctionExpression("POWER", this, typedExpression);
    }

    public final TypedExpression remainder(TypedExpression typedExpression) {
        return new RowFunctionExpression("REMAINDER", this, typedExpression);
    }

    public final TypedExpression round(TypedExpression typedExpression) {
        return new RowFunctionExpression("ROUND", this, typedExpression);
    }

    public final TypedExpression sign() {
        return new RowFunctionExpression("SIGN", this);
    }

    public final TypedExpression sin() {
        return new RowFunctionExpression("SIN", this);
    }

    public final TypedExpression sinh() {
        return new RowFunctionExpression("SINH", this);
    }

    public final TypedExpression sqrt() {
        return new RowFunctionExpression("SQRT", this);
    }

    public final TypedExpression tan() {
        return new RowFunctionExpression("TAN", this);
    }

    public final TypedExpression tanh() {
        return new RowFunctionExpression("TANH", this);
    }

    public final TypedExpression trunc(TypedExpression typedExpression) {
        return new RowFunctionExpression("TRUNC", this, typedExpression);
    }

    public final TypedExpression widthBucket(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3) {
        return new RowFunctionExpression("WIDTH_BUCKET", this, typedExpression, typedExpression2, typedExpression3);
    }

    public final TypedExpression ascii() {
        return new RowFunctionExpression("ASCII", this);
    }

    public final TypedExpression chr() {
        return this.chr(false);
    }

    public final TypedExpression chr(boolean bl) {
        if (bl) {
            return new RowFunctionExpression("CHR", this, KeywordCatalog.USING, KeywordCatalog.NCHAR_CS);
        }
        return new RowFunctionExpression("CHR", this);
    }

    public final TypedExpression concat(String string) {
        return this.concat(new StringExpression(string));
    }

    public final TypedExpression concat(TypedExpression typedExpression) {
        return new BinaryOperatorExpression(this, "||", typedExpression);
    }

    public final TypedExpression initcap() {
        return new RowFunctionExpression("INITCAP", this);
    }

    public final TypedExpression instr(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3) {
        return new RowFunctionExpression("INSTR", this, typedExpression, typedExpression2, typedExpression3);
    }

    public final TypedExpression instrB(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3) {
        return new RowFunctionExpression("INSTRB", this, typedExpression, typedExpression2, typedExpression3);
    }

    public final TypedExpression instrC(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3) {
        return new RowFunctionExpression("INSTRC", this, typedExpression, typedExpression2, typedExpression3);
    }

    public final TypedExpression instr2(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3) {
        return new RowFunctionExpression("INSTR2", this, typedExpression, typedExpression2, typedExpression3);
    }

    public final TypedExpression instr4(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3) {
        return new RowFunctionExpression("INSTR4", this, typedExpression, typedExpression2, typedExpression3);
    }

    public final TypedExpression length() {
        return new RowFunctionExpression("LENGTH", this);
    }

    public final TypedExpression lengthB() {
        return new RowFunctionExpression("LENGTHB", this);
    }

    public final TypedExpression lengthC() {
        return new RowFunctionExpression("LENGTHC", this);
    }

    public final TypedExpression length2() {
        return new RowFunctionExpression("LENGTH2", this);
    }

    public final TypedExpression length4() {
        return new RowFunctionExpression("LENGTH4", this);
    }

    public final TypedExpression lower() {
        return new RowFunctionExpression("LOWER", this);
    }

    public final TypedExpression lpad(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("LPAD", this, typedExpression, typedExpression2);
    }

    public final TypedExpression ltrim(TypedExpression typedExpression) {
        return new RowFunctionExpression("LTRIM", this, typedExpression);
    }

    public final TypedExpression nlsInitcap(TypedExpression typedExpression) {
        return new RowFunctionExpression("NLS_INITCAP", this, typedExpression);
    }

    public final TypedExpression nlsLower(TypedExpression typedExpression) {
        return new RowFunctionExpression("NLS_LOWER", this, typedExpression);
    }

    public final TypedExpression nlsSort(TypedExpression typedExpression) {
        return new RowFunctionExpression("NLS_SORT", this, typedExpression);
    }

    public final TypedExpression nlsUpper(TypedExpression typedExpression) {
        return new RowFunctionExpression("NLS_UPPER", this, typedExpression);
    }

    public final TypedExpression regexpInstr(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3, TypedExpression typedExpression4, TypedExpression typedExpression5) {
        return new RowFunctionExpression("REGEXP_INSTR", new FunctionArgument[]{this, typedExpression, typedExpression2, typedExpression3, typedExpression4, typedExpression5});
    }

    public final TypedExpression regexpReplace(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3, TypedExpression typedExpression4, TypedExpression typedExpression5) {
        return new RowFunctionExpression("REGEXP_REPLACE", new FunctionArgument[]{this, typedExpression, typedExpression2, typedExpression3, typedExpression4, typedExpression5});
    }

    public final TypedExpression regexpSubstr(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3, TypedExpression typedExpression4) {
        return new RowFunctionExpression("REGEXP_SUBSTR", new FunctionArgument[]{this, typedExpression, typedExpression2, typedExpression3, typedExpression4});
    }

    public final TypedExpression replace(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("REPLACE", this, typedExpression, typedExpression2);
    }

    public final TypedExpression rpad(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("LPAD", this, typedExpression, typedExpression2);
    }

    public final TypedExpression rtrim(TypedExpression typedExpression) {
        return new RowFunctionExpression("RTRIM", this, typedExpression);
    }

    public final TypedExpression soundex() {
        return new RowFunctionExpression("SOUNDEX", this);
    }

    public final TypedExpression substr(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("SUBSTR", this, typedExpression, typedExpression2);
    }

    public final TypedExpression substrB(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("SUBSTRB", this, typedExpression, typedExpression2);
    }

    public final TypedExpression substrC(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("SUBSTRC", this, typedExpression, typedExpression2);
    }

    public final TypedExpression substr2(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("SUBSTR2", this, typedExpression, typedExpression2);
    }

    public final TypedExpression substr4(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("SUBSTR4", this, typedExpression, typedExpression2);
    }

    public final TypedExpression translate(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("TRANSLATE", this, typedExpression, typedExpression2);
    }

    public final TypedExpression treat(String string, boolean bl) {
        if (bl) {
            return new RowFunctionExpression("TREAT", this, KeywordCatalog.AS, KeywordCatalog.REF, new IdentifierArgument(string));
        }
        return new RowFunctionExpression("TREAT", this, KeywordCatalog.AS, new IdentifierArgument(string));
    }

    public final TypedExpression trim(TypedExpression typedExpression) {
        if (null == typedExpression) {
            return new RowFunctionExpression("TRIM", this);
        }
        return new RowFunctionExpression("TRIM", typedExpression, KeywordCatalog.FROM, this);
    }

    public final TypedExpression trimLeading(TypedExpression typedExpression) {
        if (null == typedExpression) {
            return new RowFunctionExpression("TRIM", KeywordCatalog.LEADING, KeywordCatalog.FROM, this);
        }
        return new RowFunctionExpression("TRIM", KeywordCatalog.LEADING, typedExpression, KeywordCatalog.FROM, this);
    }

    public final TypedExpression trimTrailing(TypedExpression typedExpression) {
        if (null == typedExpression) {
            return new RowFunctionExpression("TRIM", KeywordCatalog.TRAILING, KeywordCatalog.FROM, this);
        }
        return new RowFunctionExpression("TRIM", KeywordCatalog.TRAILING, typedExpression, KeywordCatalog.FROM, this);
    }

    public final TypedExpression upper() {
        return new RowFunctionExpression("UPPER", this);
    }

    public final TypedExpression nlsCharsetDeclLen(TypedExpression typedExpression) {
        return new RowFunctionExpression("NLS_CHARSET_DECL_LEN", this, typedExpression);
    }

    public final TypedExpression nlsCharsetID() {
        return new RowFunctionExpression("NLS_CHARSET_ID", this);
    }

    public final TypedExpression nlsCharsetName() {
        return new RowFunctionExpression("NLS_CHARSET_NAME", this);
    }

    public final TypedExpression addMonths(TypedExpression typedExpression) {
        return new RowFunctionExpression("ADD_MONTHS", this, typedExpression);
    }

    public final TypedExpression addMonths(int n) {
        return this.addMonths(new NumberExpression(n));
    }

    public static final TypedExpression currentDate() {
        return new RowFunctionExpression("CURRENT_DATE");
    }

    public static final TypedExpression currentTime(TypedExpression typedExpression) {
        return new RowFunctionExpression("CURRENT_TIME", typedExpression);
    }

    public static final TypedExpression dbTimeZone() {
        return new RowFunctionExpression("DBTIMEZONE");
    }

    public final TypedExpression extractYear() {
        return new RowFunctionExpression("EXTRACT", KeywordCatalog.YEAR, KeywordCatalog.FROM, this);
    }

    public final TypedExpression extractMonth() {
        return new RowFunctionExpression("EXTRACT", KeywordCatalog.MONTH, KeywordCatalog.FROM, this);
    }

    public final TypedExpression extractDay() {
        return new RowFunctionExpression("EXTRACT", KeywordCatalog.DAY, KeywordCatalog.FROM, this);
    }

    public final TypedExpression extractHour() {
        return new RowFunctionExpression("EXTRACT", KeywordCatalog.HOUR, KeywordCatalog.FROM, this);
    }

    public final TypedExpression extractMinute() {
        return new RowFunctionExpression("EXTRACT", KeywordCatalog.MINUTE, KeywordCatalog.FROM, this);
    }

    public final TypedExpression extractSecond() {
        return new RowFunctionExpression("EXTRACT", KeywordCatalog.SECOND, KeywordCatalog.FROM, this);
    }

    public final TypedExpression extractTimeZoneHour() {
        return new RowFunctionExpression("EXTRACT", KeywordCatalog.TIMEZONE_HOUR, KeywordCatalog.FROM, this);
    }

    public final TypedExpression extractTimeZoneMinute() {
        return new RowFunctionExpression("EXTRACT", KeywordCatalog.TIMEZONE_MINUTE, KeywordCatalog.FROM, this);
    }

    public final TypedExpression extractTimeZoneRegion() {
        return new RowFunctionExpression("EXTRACT", KeywordCatalog.TIMEZONE_REGION, KeywordCatalog.FROM, this);
    }

    public final TypedExpression extractTimeZoneAbbr() {
        return new RowFunctionExpression("EXTRACT", KeywordCatalog.TIMEZONE_ABBR, KeywordCatalog.FROM, this);
    }

    public final TypedExpression fromTZ(TypedExpression typedExpression) {
        return new RowFunctionExpression("FROM_TZ", this, typedExpression);
    }

    public final TypedExpression lastDay() {
        return new RowFunctionExpression("LAST_DAY", this);
    }

    public static final TypedExpression localTimestamp(TypedExpression typedExpression) {
        return new RowFunctionExpression("LOCALTIMESTAMP", typedExpression);
    }

    public final TypedExpression monthsBetween(TypedExpression typedExpression) {
        return new RowFunctionExpression("MONTHS_BETWEEN", this, typedExpression);
    }

    public final TypedExpression newTime(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("NEW_TIME", this, typedExpression, typedExpression2);
    }

    public final TypedExpression nextDay(TypedExpression typedExpression) {
        return new RowFunctionExpression("NEXT_DAY", this, typedExpression);
    }

    public static final TypedExpression sessionTimeZone() {
        return new RowFunctionExpression("SESSIONTIMEZONE");
    }

    public final TypedExpression sysExtractUTC() {
        return new RowFunctionExpression("SYS_EXTRACT_UTC", this);
    }

    public static final TypedExpression sysDate() {
        return new RowFunctionExpression("SYSDATE");
    }

    public static final TypedExpression sysTimestamp() {
        return new RowFunctionExpression("SYSTIMESTAMP");
    }

    public final TypedExpression toDSInterval(TypedExpression typedExpression) {
        return new RowFunctionExpression("TO_DSINTERVAL", this, typedExpression);
    }

    public final TypedExpression toTimestamp(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("TO_TIMESTAMP", this, typedExpression, typedExpression2);
    }

    public final TypedExpression toTimestampTZ(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("TO_TIMESTAMP_TZ", this, typedExpression, typedExpression2);
    }

    public final TypedExpression toYMInterval() {
        return new RowFunctionExpression("TO_YMINTERVAL", this);
    }

    public final TypedExpression tzOffset() {
        return new RowFunctionExpression("TZ_OFFSET", this);
    }

    public static TypedExpression greatest(TypedExpression[] typedExpressionArray) {
        return new RowFunctionExpression("GREATEST", typedExpressionArray);
    }

    public static TypedExpression least(TypedExpression[] typedExpressionArray) {
        return new RowFunctionExpression("LEAST", typedExpressionArray);
    }

    public final TypedExpression asciiStr() {
        return new RowFunctionExpression("ASCIISTR", this);
    }

    public static TypedExpression binToNum(TypedExpression[] typedExpressionArray) {
        return new RowFunctionExpression("BIN_TO_NUM", typedExpressionArray);
    }

    public final TypedExpression cast(String string) {
        return new RowFunctionExpression("CAST", this, KeywordCatalog.AS, new IdentifierArgument(string));
    }

    public final TypedExpression charToROWID() {
        return new RowFunctionExpression("CHARTOROWID", this);
    }

    public final TypedExpression compose() {
        return new RowFunctionExpression("COMPOSE", this);
    }

    public final TypedExpression convert(TypedExpression typedExpression) {
        return this.convert(typedExpression, null);
    }

    public final TypedExpression convert(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("CONVERT", this, typedExpression, typedExpression2);
    }

    public final TypedExpression decompose() {
        return new RowFunctionExpression("DECOMPOSE", this);
    }

    public final TypedExpression decompose(boolean bl) {
        return this.decompose();
    }

    public final TypedExpression hexToRAW() {
        return new RowFunctionExpression("HEXTORAW", this);
    }

    public final TypedExpression numToDSInterval(TypedExpression typedExpression) {
        return new RowFunctionExpression("NUMTODSINTERVAL", this, typedExpression);
    }

    public final TypedExpression numToYMInterval(TypedExpression typedExpression) {
        return new RowFunctionExpression("NUMTOYMINTERVAL", this, typedExpression);
    }

    public final TypedExpression rawToHex() {
        return new RowFunctionExpression("RAWTOHEX", this);
    }

    public final TypedExpression rawToNHex() {
        return new RowFunctionExpression("RAWTONHEX", this);
    }

    public final TypedExpression rowIDToChar() {
        return new RowFunctionExpression("ROWIDTOCHAR", this);
    }

    public final TypedExpression rowIDToNChar() {
        return new RowFunctionExpression("ROWIDTONCHAR", this);
    }

    public final TypedExpression scnToTimestamp() {
        return new RowFunctionExpression("SCN_TO_TIMESTAMP", this);
    }

    public final TypedExpression timestampToSCN() {
        return new RowFunctionExpression("TIMESTAMP_TO_SCN", this);
    }

    public final TypedExpression toBinaryDouble(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("TO_BINARY_DOUBLE", this, typedExpression, typedExpression2);
    }

    public final TypedExpression toBinaryFloat(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("TO_BINARY_FLOAT", this, typedExpression, typedExpression2);
    }

    public final TypedExpression toChar() {
        return new RowFunctionExpression("TO_CHAR", this);
    }

    public final TypedExpression toChar(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("TO_CHAR", this, typedExpression, typedExpression2);
    }

    public final TypedExpression toCLOB() {
        return new RowFunctionExpression("TO_CLOB", this);
    }

    public final TypedExpression toDate() {
        return new RowFunctionExpression("TO_DATE", this);
    }

    public final TypedExpression toDate(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("TO_DATE", this, typedExpression, typedExpression2);
    }

    public final TypedExpression toLOB() {
        return new RowFunctionExpression("TO_LOB", this);
    }

    public final TypedExpression toMultiByte() {
        return new RowFunctionExpression("TO_MULTI_BYTE", this);
    }

    public final TypedExpression toNChar() {
        return new RowFunctionExpression("TO_NCHAR", this);
    }

    public final TypedExpression toNChar(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("TO_NCHAR", this, typedExpression, typedExpression2);
    }

    public final TypedExpression toNCLOB() {
        return new RowFunctionExpression("TO_NCLOB", this);
    }

    public final TypedExpression toNumber() {
        return new RowFunctionExpression("TO_NUMBER", this);
    }

    public final TypedExpression toNumber(TypedExpression typedExpression) {
        return new RowFunctionExpression("TO_NUMBER", this, typedExpression);
    }

    public final TypedExpression toNumber(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("TO_NUMBER", this, typedExpression, typedExpression2);
    }

    public final TypedExpression toSingleByte() {
        return new RowFunctionExpression("TO_SINGLE_BYTE", this);
    }

    public final TypedExpression translateUsingCharCS() {
        return new RowFunctionExpression("TRANSLATE", this, KeywordCatalog.USING, KeywordCatalog.CHAR_CS);
    }

    public final TypedExpression translateUsingNCharCS() {
        return new RowFunctionExpression("TRANSLATE", this, KeywordCatalog.USING, KeywordCatalog.NCHAR_CS);
    }

    public final TypedExpression unistr() {
        return new RowFunctionExpression("UNISTR", this);
    }

    public final TypedExpression decode(TypedExpression[] typedExpressionArray, TypedExpression typedExpression) {
        int n = 1 + typedExpressionArray.length;
        if (null != typedExpression) {
            ++n;
        }
        FunctionArgument[] functionArgumentArray = new TypedExpression[n];
        functionArgumentArray[0] = this;
        System.arraycopy(typedExpressionArray, 0, functionArgumentArray, 1, typedExpressionArray.length);
        if (null != typedExpression) {
            functionArgumentArray[functionArgumentArray.length - 1] = typedExpression;
        }
        return new RowFunctionExpression("DECODE", functionArgumentArray);
    }

    public final TypedExpression oraHash(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("ORA_HASH", this, typedExpression, typedExpression2);
    }

    public final TypedExpression dump(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3) {
        return new RowFunctionExpression("DUMP", this, typedExpression, typedExpression2, typedExpression3);
    }

    public final TypedExpression deref() {
        return new RowFunctionExpression("DEREF", this);
    }

    public final TypedExpression vsize() {
        return new RowFunctionExpression("VSIZE", this);
    }

    public static TypedExpression coalesce(TypedExpression[] typedExpressionArray) {
        return new RowFunctionExpression("COALESCE", typedExpressionArray);
    }

    public final TypedExpression nullIf(TypedExpression typedExpression) {
        return new RowFunctionExpression("NULLIF", this, typedExpression);
    }

    public final TypedExpression nvl(TypedExpression typedExpression) {
        return new RowFunctionExpression("NVL", this, typedExpression);
    }

    public final TypedExpression nvl2(TypedExpression typedExpression, TypedExpression typedExpression2) {
        return new RowFunctionExpression("NVL2", this, typedExpression, typedExpression2);
    }

    public final TypedExpression sysContext(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3) {
        return new RowFunctionExpression("SYS_CONTEXT", this, typedExpression, typedExpression2, typedExpression3);
    }

    public static TypedExpression sysGUID() {
        return new RowFunctionExpression("SYS_GUID");
    }

    public static TypedExpression UID() {
        return new RowFunctionExpression("UID");
    }

    public static TypedExpression USER() {
        return new RowFunctionExpression("USER");
    }

    public final TypedExpression sysTypeID() {
        return new RowFunctionExpression("SYS_TYPEID", this);
    }

    public final TypedExpression userEnv() {
        return new RowFunctionExpression("USERENV", this);
    }
}

