/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.NumberExpression;
import oracle.olapi.syntax.RowExpression;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class IntervalExpression
extends RowExpression {
    public static final String DAY_TO_SECOND = "DAY_TO_SECOND";
    public static final String YEAR_TO_MONTH = "YEAR_TO_MONTH";
    static final String[] ALL_OPERATORS = new String[]{"YEAR_TO_MONTH", "DAY_TO_SECOND"};
    private String m_Operator;
    private TypedExpression m_BaseExpression;
    private TypedExpression m_FirstPrecisionExpression;
    private TypedExpression m_SecondPrecisionExpression;

    public void printPrecision(TypedExpression typedExpression, SyntaxPrintingContext syntaxPrintingContext) {
        if (null == typedExpression) {
            return;
        }
        syntaxPrintingContext.append("(");
        syntaxPrintingContext.print(typedExpression);
        syntaxPrintingContext.append(")");
    }

    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.print(this.getBaseExpression());
        if (DAY_TO_SECOND == this.getOperator()) {
            syntaxPrintingContext.append(" DAY ");
            this.printPrecision(this.getFirstPrecisionExpression(), syntaxPrintingContext);
            syntaxPrintingContext.append(" TO SECOND ");
            this.printPrecision(this.getSecondPrecisionExpression(), syntaxPrintingContext);
        } else {
            syntaxPrintingContext.append(" YEAR ");
            this.printPrecision(this.getFirstPrecisionExpression(), syntaxPrintingContext);
            syntaxPrintingContext.append(" TO MONTH ");
        }
    }

    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_BaseExpression = (TypedExpression)validationContext.validate(this.m_BaseExpression);
        if (null != this.m_FirstPrecisionExpression) {
            this.m_FirstPrecisionExpression = (TypedExpression)validationContext.validate(this.m_FirstPrecisionExpression);
        }
        if (null != this.m_SecondPrecisionExpression) {
            this.m_SecondPrecisionExpression = (TypedExpression)validationContext.validate(this.m_SecondPrecisionExpression);
        }
        validationContext.pop();
        return this;
    }

    protected boolean checkIfDefinitionIsComplete() {
        boolean bl = this.getBaseExpression().isDefinitionComplete();
        if (null != this.getFirstPrecisionExpression()) {
            bl &= this.getFirstPrecisionExpression().isDefinitionComplete();
        }
        if (null != this.getSecondPrecisionExpression()) {
            bl &= this.getSecondPrecisionExpression().isDefinitionComplete();
        }
        return bl;
    }

    public IntervalExpression(TypedExpression typedExpression, String string, TypedExpression typedExpression2, TypedExpression typedExpression3) {
        this.m_Operator = IntervalExpression.validateEnum(string, ALL_OPERATORS);
        IntervalExpression.validateValue(typedExpression);
        if (this.m_Operator == DAY_TO_SECOND) {
            this.setDataType(DataType.DS_INTERVAL);
        } else {
            this.setDataType(DataType.YM_INTERVAL);
        }
        this.m_BaseExpression = typedExpression;
        this.m_FirstPrecisionExpression = typedExpression2;
        if (null != typedExpression2) {
            if (!(typedExpression2 instanceof NumberExpression)) {
                throw new SyntaxException("SyntaxTypeMismatch", NumberExpression.class.getName(), typedExpression2.getClass().getName());
            }
            typedExpression2.validateType(2);
        }
        this.m_SecondPrecisionExpression = typedExpression3;
        if (null != typedExpression3) {
            if (!(typedExpression3 instanceof NumberExpression)) {
                throw new SyntaxException("SyntaxTypeMismatch", NumberExpression.class.getName(), typedExpression3.getClass().getName());
            }
            typedExpression3.validateType(2);
        }
        this.initialize();
    }

    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitIntervalExpression(this, object);
    }

    public String getOperator() {
        return this.m_Operator;
    }

    public TypedExpression getBaseExpression() {
        return this.m_BaseExpression;
    }

    public TypedExpression getFirstPrecisionExpression() {
        return this.m_FirstPrecisionExpression;
    }

    public TypedExpression getSecondPrecisionExpression() {
        return this.m_SecondPrecisionExpression;
    }

    int getPrecedence() {
        return 3;
    }
}

