/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionality;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmSource;
import oracle.olapi.metadata.mdm.MdmXMLTags;

public abstract class MdmDimensionedObject
extends MdmSource {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.DIMENSIONALITY, MdmXMLTags.PRIMARY_DIM_DMLTY_REF, MdmXMLTags.IS_BOOLEAN_VALUED};

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    MdmDimensionedObject(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public MdmDimensionedObject(String string, String string2, short s, BaseMetadataProvider baseMetadataProvider, BaseMetadataObject baseMetadataObject) {
        super(string, string2, s, baseMetadataProvider, baseMetadataObject);
    }

    public final MdmDimensionality addDimension(MdmDimension mdmDimension) {
        if (!this.isServerVersionLaterThan(new int[]{11, 0, 0, 0}) || !this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            this.addToListProperty(MdmXMLTags.PRIMARY_DIM_DMLTY_REF, mdmDimension);
            return null;
        }
        int n = 0;
        Object object = this.getDimensions().iterator();
        while (object.hasNext()) {
            if (mdmDimension != object.next()) continue;
            ++n;
        }
        object = mdmDimension.getName();
        if (n > 0) {
            object = (String)object + "_" + n;
        }
        MdmDimensionality mdmDimensionality = this.findOrCreateDimensionality((String)object);
        mdmDimensionality.setDimension(mdmDimension);
        return mdmDimensionality;
    }

    public final List getDimensions() {
        if (!this.isServerVersionLaterThan(new int[]{11, 0, 0, 0}) || !this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            return this.getPropertyListValues(MdmXMLTags.PRIMARY_DIM_DMLTY_REF);
        }
        List list = this.getDimensionality();
        ArrayList<MdmDimension> arrayList = new ArrayList<MdmDimension>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((MdmDimensionality)iterator.next()).getDimension());
        }
        return arrayList;
    }

    public List getDimensionality() {
        return this.getPropertyListValues(MdmXMLTags.DIMENSIONALITY);
    }

    public void addDimensionality(MdmDimensionality mdmDimensionality) {
        this.addToListProperty(MdmXMLTags.DIMENSIONALITY, mdmDimensionality);
    }

    public void removeDimensionality(MdmDimensionality mdmDimensionality) {
        this.removeFromListProperty(MdmXMLTags.DIMENSIONALITY, mdmDimensionality);
    }

    public final boolean isBooleanValued() {
        if (this.getPropertyBooleanValue(MdmXMLTags.IS_BOOLEAN_VALUED)) {
            return true;
        }
        MetadataObject metadataObject = (MetadataObject)this.getPropertyObjectValue(MdmXMLTags.DATA_TYPE);
        return null != metadataObject && this.getMetadataProvider().getDataProvider().getFundamentalMetadataProvider().getBooleanDataType() == metadataObject;
    }

    public final void setBooleanValued(boolean bl) {
        this.setPropertyBooleanValue(MdmXMLTags.IS_BOOLEAN_VALUED, bl);
    }

    public final MdmDimensionality findOrCreateDimensionality(String string) {
        return this.findOrCreateDimensionality(MdmXMLTags.DIMENSIONALITY, string, (short)0);
    }

    protected final MdmDimensionality findOrCreateDimensionality(XMLTag xMLTag, String string, short s) {
        String string2 = MdmDimensionedObject.generateID((BaseMetadataObject)this, string);
        return (MdmDimensionality)this.findOrCreateContainedObject(string2, string, s, xMLTag, MdmDimensionality.class);
    }
}

