/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mapping.MemberListMap;
import oracle.olapi.metadata.mdm.Mdm11_ObjectVisitor;
import oracle.olapi.metadata.mdm.MdmBaseAttribute;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmInvalidValueException;
import oracle.olapi.metadata.mdm.MdmMemberListMapOwner;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.metadata.mdm.MdmSubDimension;
import oracle.olapi.metadata.mdm.MdmViewColumn;
import oracle.olapi.metadata.mdm.MdmViewColumnOwner;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.SQLDataType;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdmDimensionLevel
extends MdmSubDimension
implements MdmMemberListMapOwner,
MdmViewColumnOwner {
    public static final String LEVEL_TYPE_STANDARD = "STANDARD";
    public static final String LEVEL_TYPE_YEAR = "YEAR";
    public static final String LEVEL_TYPE_HALFYEAR = "HALFYEAR";
    public static final String LEVEL_TYPE_QUARTER = "QUARTER";
    public static final String LEVEL_TYPE_MONTH = "MONTH";
    public static final String LEVEL_TYPE_WEEK = "WEEK";
    public static final String LEVEL_TYPE_DAY = "DAY";
    public static final String LEVEL_TYPE_HOUR = "HOUR";
    public static final String LEVEL_TYPE_MINUTE = "MINUTE";
    public static final String LEVEL_TYPE_SECOND = "SECOND";
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.LEVEL_TYPE, MdmXMLTags.MEMBER_LIST_MAP, MdmXMLTags.UNIQUE_KEY_ATTRIBUTE, MdmXMLTags.ET_KEY_COLUMN_NAME, MdmXMLTags.ET_LOCAL_VALUE_COLUMN_NAME};
    private static String[] LEVEL_TYPE_TRANSLATION_ARRAY = new String[]{"STANDARD", "STANDARD", "TIME_YEAR", "YEAR", "TIME_HALFYEAR", "HALFYEAR", "TIME_QUARTER", "QUARTER", "TIME_MONTH", "MONTH", "TIME_WEEK", "WEEK", "TIME_DAY", "DAY", "TIME_HOUR", "HOUR", "TIME_MINUTE", "MINUTE", "TIME_SECOND", "SECOND"};
    private List m_NativeViewColumns;
    private MdmViewColumn m_LevelKeyColumn = null;
    private MdmViewColumn m_LocalValueColumn = null;

    private synchronized void createViewColumns() {
        if (null != this.m_LevelKeyColumn) {
            return;
        }
        this.m_LevelKeyColumn = new MdmViewColumn(this, this.getName(), MdmXMLTags.ET_KEY_COLUMN_NAME, DataType.VARCHAR2.toSQLDataType());
        this.m_LocalValueColumn = new MdmViewColumn(this, this.getName() + "_LOCAL_VALUE", MdmXMLTags.ET_LOCAL_VALUE_COLUMN_NAME, DataType.VARCHAR2.toSQLDataType());
    }

    final void populateQueryColumns(List<MdmQueryColumn> list) {
        list.add(this.getETViewLevelKeyColumn());
        list.add(this.getETViewLocalValueColumn());
        List<MdmBaseAttribute> list2 = this.getUniqueKeyAttributes();
        if (null == list2) {
            return;
        }
        for (MdmBaseAttribute mdmBaseAttribute : list2) {
            list.add(mdmBaseAttribute.getETAttributeColumn());
        }
    }

    final MdmQueryColumn getQueryColumn(String string) {
        if (this.getName().equals(string)) {
            return this.getETViewLevelKeyColumn();
        }
        if (this.getETViewLocalValueColumn().getName().equals(string)) {
            return this.getETViewLocalValueColumn();
        }
        for (MdmBaseAttribute mdmBaseAttribute : this.getUniqueKeyAttributes()) {
            if (!mdmBaseAttribute.getETAttributeColumn().getName().equals(string)) continue;
            return mdmBaseAttribute.getETAttributeColumn();
        }
        return null;
    }

    private String translateLevelType(String string, boolean bl) {
        if (null == string) {
            return null;
        }
        for (int i = 0; i < LEVEL_TYPE_TRANSLATION_ARRAY.length; i += 2) {
            String string2 = LEVEL_TYPE_TRANSLATION_ARRAY[i];
            String string3 = LEVEL_TYPE_TRANSLATION_ARRAY[i + 1];
            if (bl && string.equalsIgnoreCase(string3)) {
                return string2;
            }
            if (bl || !string.equalsIgnoreCase(string2)) continue;
            return string3;
        }
        if (bl) {
            throw new MdmInvalidValueException();
        }
        return LEVEL_TYPE_STANDARD;
    }

    MdmDimensionLevel(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    MdmDimensionLevel(String string, String string2, short s, BaseMetadataObject baseMetadataObject) {
        super(string2, s, (MdmDimension)baseMetadataObject);
    }

    @Override
    public SQLDataType getSQLDataType() {
        return DataType.VARCHAR2.toSQLDataType();
    }

    @Override
    protected final Set getInputDefinitions() {
        return Collections.EMPTY_SET;
    }

    @Override
    protected final SourceDefinition getTypeDefinition() {
        return this.getPrimaryDimension().getSource().getDefinition();
    }

    @Override
    protected XMLTag getXMLTag() {
        return MdmXMLTags.DIMENSION_LEVEL_TAG;
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public static String generateIDFromXML(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, String string, String string2, String string3, MetadataXMLReader metadataXMLReader) throws SAXException {
        baseMetadataObject = baseMetadataObject.getTopLevelObject(metadataXMLReader.getPersistenceType());
        return MdmSubDimension.generateIDFromXML(baseMetadataObject, xMLTag, string, string2, string3, metadataXMLReader);
    }

    @Override
    public MdmDimension getEnclosingDimension() {
        return this.getPrimaryDimension();
    }

    public void setEnclosingDimension(MdmPrimaryDimension mdmPrimaryDimension) {
        this.setPrimaryDimension(mdmPrimaryDimension);
    }

    final void setPrimaryDimension(MdmPrimaryDimension mdmPrimaryDimension) {
        this.setContainedByObject(mdmPrimaryDimension);
    }

    @Override
    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        if (mdmObjectVisitor instanceof Mdm11_ObjectVisitor) {
            return ((Mdm11_ObjectVisitor)mdmObjectVisitor).visitMdmDimensionLevel(this, object);
        }
        return null;
    }

    public final List<MdmBaseAttribute> getUniqueKeyAttributes() {
        return this.getPropertyListValues(MdmXMLTags.UNIQUE_KEY_ATTRIBUTE);
    }

    public final void addUniqueKeyAttribute(MdmBaseAttribute mdmBaseAttribute) {
        this.addToListProperty(MdmXMLTags.UNIQUE_KEY_ATTRIBUTE, mdmBaseAttribute);
    }

    public final void removeUniqueKeyAttribute(MdmBaseAttribute mdmBaseAttribute) {
        this.removeFromListProperty(MdmXMLTags.UNIQUE_KEY_ATTRIBUTE, mdmBaseAttribute);
    }

    public String getLevelType() throws MetadataNotFoundException {
        String string = this.getPropertyStringValue(MdmXMLTags.LEVEL_TYPE);
        return this.translateLevelType(string, false);
    }

    public void setLevelType(String string) throws MdmInvalidValueException {
        this.setPropertyStringValue(MdmXMLTags.LEVEL_TYPE, this.translateLevelType(string, true));
    }

    @Override
    public final MemberListMap getMemberListMap() {
        return (MemberListMap)this.getPropertyObjectValue(MdmXMLTags.MEMBER_LIST_MAP);
    }

    @Override
    public final void setMemberListMap(MemberListMap memberListMap) {
        this.setPropertyObjectValue(MdmXMLTags.MEMBER_LIST_MAP, memberListMap);
    }

    public final MdmViewColumn getETViewLevelKeyColumn() {
        if (null == this.m_LevelKeyColumn) {
            this.createViewColumns();
        }
        return this.m_LevelKeyColumn;
    }

    public final MdmViewColumn getETViewLocalValueColumn() {
        if (null == this.m_LocalValueColumn) {
            this.createViewColumns();
        }
        return this.m_LocalValueColumn;
    }

    @Override
    public MemberListMap findOrCreateMemberListMap() {
        String string = MdmDimensionLevel.generateID(new String[]{this.getInternalID(), "MAP"});
        return this.findOrCreateMemberListMap(string);
    }
}

