/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAggregationArgument;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLParameter;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.syntax.AggregationCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LegacyXMLConfigurationParameters
extends LegacyXMLAggregationArgument {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.PARAMETERS};

    protected LegacyXMLConfigurationParameters(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    List<LegacyXMLParameter> getParameters() {
        return this.getPropertyListValues(LegacyXMLTags.PARAMETERS);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.CONFIGURATION_PARAMETERS_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        List<LegacyXMLParameter> list = this.getParameters();
        if (null != list) {
            for (LegacyXMLParameter legacyXMLParameter : list) {
                if (legacyXMLParameter.validate(legacyXMLConverter, false)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    boolean getIgnoreNullsValue() {
        String string = this.getValue("NASKIP");
        if ("YES".equalsIgnoreCase(string)) {
            return true;
        }
        if ("NO".equalsIgnoreCase(string)) {
            return false;
        }
        return AggregationCommand.IGNORE_NULLS_DEFAULT;
    }

    @Override
    boolean getAllowOverflowValue() {
        String string = this.getValue("DECIMALOVERFLOW");
        if ("YES".equalsIgnoreCase(string)) {
            return true;
        }
        if ("NO".equalsIgnoreCase(string)) {
            return false;
        }
        return AggregationCommand.ALLOW_OVERFLOW_DEFAULT;
    }

    @Override
    boolean getAllowDivisionByZeroValue() {
        String string = this.getValue("DIVIDEBYZERO");
        if ("YES".equalsIgnoreCase(string)) {
            return true;
        }
        if ("NO".equalsIgnoreCase(string)) {
            return false;
        }
        return AggregationCommand.ALLOW_DIVISION_BY_ZERO_DEFAULT;
    }

    private String getValue(String string) {
        List<LegacyXMLParameter> list = this.getParameters();
        if (null != list) {
            for (LegacyXMLParameter legacyXMLParameter : list) {
                if (legacyXMLParameter.getKeyWord() != string) continue;
                return legacyXMLParameter.getValue();
            }
        }
        return null;
    }
}

