/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import oracle.olapi.data.source.AliasDefinition;
import oracle.olapi.data.source.Assignment;
import oracle.olapi.data.source.ConstantListDefinition;
import oracle.olapi.data.source.CustomModel;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.DynamicDefinition;
import oracle.olapi.data.source.ExtractDefinition;
import oracle.olapi.data.source.HiddenDefinition;
import oracle.olapi.data.source.JoinDefinition;
import oracle.olapi.data.source.LiteralQualification;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.ModelSolutionDefinition;
import oracle.olapi.data.source.NullSourceDefinition;
import oracle.olapi.data.source.ParameterizedSourceDefinition;
import oracle.olapi.data.source.PositionDefinition;
import oracle.olapi.data.source.Qualification;
import oracle.olapi.data.source.RangeDefinition;
import oracle.olapi.data.source.RecursiveJoinDefinition;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.SourcePrinterCatalog;
import oracle.olapi.data.source.ValueDefinition;
import oracle.olapi.metadata.mdm.MdmDimensionCalculationModel;
import oracle.olapi.metadata.mdm.MdmDimensionedObjectModel;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmModel;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.transaction.TransactionalObject;

public class SourcePrinter
extends DataDescriptorDefinitionVisitor {
    private SourcePrinterCatalog _catalog;
    private PrintWriter _printWriter;
    private int _indent;

    public SourcePrinterCatalog getCatalog() {
        return this._catalog;
    }

    public void print(String string) {
        this.getPrintWriter().print(string);
    }

    public PrintWriter getPrintWriter() {
        return this._printWriter;
    }

    public void incrementIndent() {
        ++this._indent;
    }

    public void decrementIndent() {
        --this._indent;
    }

    public void indent() {
        this._printWriter.println();
        for (int i = 0; i < this._indent; ++i) {
            this._printWriter.print("    ");
        }
    }

    private SourcePrinter(SourcePrinterCatalog sourcePrinterCatalog, PrintWriter printWriter) {
        this._catalog = sourcePrinterCatalog;
        this._printWriter = printWriter;
        this._indent = 2;
    }

    public static final void printSource(Source source, PrintWriter printWriter) {
        Model model;
        SourcePrinterCatalog sourcePrinterCatalog = new SourcePrinterCatalog(source.getDefinition());
        SourcePrinter sourcePrinter = new SourcePrinter(sourcePrinterCatalog, printWriter);
        printWriter.println("// Declarations");
        Iterator iterator = sourcePrinterCatalog.getNamedDefinitionsIterator();
        while (iterator.hasNext()) {
            SourceDefinition sourceDefinition = (SourceDefinition)iterator.next();
            sourcePrinter.indent();
            printWriter.print("Source " + sourcePrinterCatalog.getDefinitionName(sourceDefinition) + " = ");
            sourcePrinter.incrementIndent();
            sourcePrinter.indent();
            sourceDefinition.acceptVisitor(sourcePrinter, null);
            printWriter.print(";");
            sourcePrinter.decrementIndent();
        }
        boolean bl = false;
        Iterator iterator2 = sourcePrinterCatalog.getNamedModelsIterator();
        while (iterator2.hasNext()) {
            model = (Model)iterator2.next();
            if (!bl) {
                bl = model.getAssignments().size() > 0;
            }
            sourcePrinter.indent();
            printWriter.print("Model " + sourcePrinterCatalog.getModelName(model) + " = ");
            sourcePrinter.incrementIndent();
            sourcePrinter.indent();
            sourcePrinter.visitModel(model, null);
            printWriter.print(";");
            sourcePrinter.decrementIndent();
        }
        if (bl) {
            sourcePrinter.indent();
            sourcePrinter.indent();
            printWriter.println("// Model Assignments");
            iterator2 = sourcePrinterCatalog.getNamedModelsIterator();
            while (iterator2.hasNext()) {
                model = (Model)iterator2.next();
                sourcePrinter.printModelAssignments(model, sourcePrinterCatalog.getModelName(model));
            }
        }
        sourcePrinter.indent();
        sourcePrinter.indent();
        printWriter.print("Source result = ");
        source.getDefinition().acceptVisitor(sourcePrinter, null);
        printWriter.println(";");
    }

    private void _printDefinition(SourceDefinition sourceDefinition, Object object) {
        String string = this.getCatalog().getDefinitionName(sourceDefinition);
        if (string != null) {
            this.print(string);
        } else {
            sourceDefinition.acceptVisitor(this, object);
        }
    }

    private void _printModel(Model model, Object object) {
        String string = this.getCatalog().getModelName(model);
        if (string != null) {
            this.print(string);
        } else {
            this.visitModel(model, object);
        }
    }

    public Object visitHiddenDefinition(HiddenDefinition hiddenDefinition, Object object) {
        String string = hiddenDefinition.getSource().getMetadataProvider().getID();
        String string2 = hiddenDefinition.getSource().getPersistentID();
        this.print("dataProvider.getMetadataProvider(\"" + string + "\").getSource(\"" + string2 + "\")");
        return null;
    }

    public Object visitDynamicDefinition(DynamicDefinition dynamicDefinition, Object object) {
        this._printDefinition(dynamicDefinition.getCurrent(), object);
        return null;
    }

    public Object visitConstantListDefinition(ConstantListDefinition constantListDefinition, Object object) {
        boolean bl;
        List list = constantListDefinition.getElements();
        boolean bl2 = bl = list.size() != 1;
        if (bl) {
            this.print("dataProvider.createListSource(new ");
        } else {
            this.print("dataProvider.createConstantSource(");
        }
        boolean bl3 = bl;
        this.incrementIndent();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof SourceDefinition) {
                if (bl3) {
                    this.print("Source[] {");
                }
                this._printDefinition((SourceDefinition)e, object);
            } else {
                if (bl3) {
                    this.print(e.getClass().getName());
                    this.print("[] {");
                }
                if (e instanceof String) {
                    this.print("\"" + e + "\"");
                } else {
                    this.getPrintWriter().print(e);
                }
            }
            bl3 = false;
            if (!iterator.hasNext()) break;
            this.print(",");
            this.indent();
        }
        this.decrementIndent();
        if (bl) {
            this.print("}");
        }
        this.print(")");
        return null;
    }

    public Object visitRangeDefinition(RangeDefinition rangeDefinition, Object object) {
        this.print("dataProvider.createRangeSource(");
        this._printDefinition(rangeDefinition.getBottom(), object);
        this.print(", ");
        this._printDefinition(rangeDefinition.getTop(), object);
        this.print(")");
        return null;
    }

    public Object visitAliasDefinition(AliasDefinition aliasDefinition, Object object) {
        this._printDefinition(aliasDefinition.getBase(), object);
        this.print(".alias()");
        return null;
    }

    public Object visitJoinDefinition(JoinDefinition joinDefinition, Object object) {
        this._printDefinition(joinDefinition.getBase(), object);
        this.print(".join(");
        this.incrementIndent();
        this.indent();
        this._printDefinition(joinDefinition.getJoined(), object);
        if (joinDefinition.getComparison().getSource().equals(joinDefinition.getSource().getDataProvider().getEmptySource()) && joinDefinition.getComparisonRule() == 3 && joinDefinition.isVisible()) {
            this.decrementIndent();
            this.indent();
            this.print(")");
            return null;
        }
        this.print(", ");
        this.indent();
        this._printDefinition(joinDefinition.getComparison(), object);
        switch (joinDefinition.getComparisonRule()) {
            case 0: {
                break;
            }
            case 3: {
                this.indent();
                this.print(", Source.COMPARISON_RULE_REMOVE");
                break;
            }
            case 1: {
                this.indent();
                this.print(", Source.COMPARISON_RULE_ASCENDING");
                break;
            }
            case 2: {
                this.indent();
                this.print(", Source.COMPARISON_RULE_DESCENDING");
            }
        }
        if (joinDefinition.isVisible()) {
            this.print(", true");
        }
        this.decrementIndent();
        this.indent();
        this.print(")");
        return null;
    }

    public Object visitExtractDefinition(ExtractDefinition extractDefinition, Object object) {
        this._printDefinition(extractDefinition.getBase(), object);
        this.print(".extract()");
        return null;
    }

    public Object visitPositionDefinition(PositionDefinition positionDefinition, Object object) {
        this._printDefinition(positionDefinition.getBase(), object);
        this.print(".position()");
        return null;
    }

    public Object visitValueDefinition(ValueDefinition valueDefinition, Object object) {
        this._printDefinition(valueDefinition.getBase(), object);
        this.print(".value(");
        if (valueDefinition.getBase() != valueDefinition.getInput()) {
            this._printDefinition(valueDefinition.getInput(), object);
        }
        this.print(")");
        return null;
    }

    public Object visitRecursiveJoinDefinition(RecursiveJoinDefinition recursiveJoinDefinition, Object object) {
        this._printDefinition(recursiveJoinDefinition.getBase(), object);
        this.print(".recursiveJoin(");
        this.incrementIndent();
        this.indent();
        this._printDefinition(recursiveJoinDefinition.getJoined(), object);
        this.print(", ");
        this.indent();
        this._printDefinition(recursiveJoinDefinition.getComparison(), object);
        this.print(", ");
        this.indent();
        this._printDefinition(recursiveJoinDefinition.getParent(), object);
        switch (recursiveJoinDefinition.getComparisonRule()) {
            case 0: {
                this.indent();
                this.print(", Source.COMPARISON_RULE_SELECT");
                break;
            }
            case 3: {
                this.indent();
                this.print(", Source.COMPARISON_RULE_REMOVE");
                break;
            }
            case 1: {
                this.indent();
                this.print(", Source.COMPARISON_RULE_ASCENDING");
                break;
            }
            case 2: {
                this.indent();
                this.print(", Source.COMPARISON_RULE_DESCENDING");
            }
        }
        if (recursiveJoinDefinition.isParentsFirst()) {
            this.print(", true");
        } else {
            this.print(", false");
        }
        if (recursiveJoinDefinition.isParentsRestrictedToBase()) {
            this.print(", true, ");
        } else {
            this.print(", false, ");
        }
        this.getPrintWriter().print(recursiveJoinDefinition.getMaxRecursions());
        if (recursiveJoinDefinition.isVisible()) {
            this.print(", true)");
        } else {
            this.print(", false)");
        }
        this.decrementIndent();
        this.indent();
        return null;
    }

    public Object visitParameterizedSourceDefinition(ParameterizedSourceDefinition parameterizedSourceDefinition, Object object) {
        this.print("parameter");
        return null;
    }

    public Object visitNullDefinition(NullSourceDefinition nullSourceDefinition, Object object) {
        this._printDefinition(nullSourceDefinition.getBase(), object);
        this.print(".nullSource()");
        return null;
    }

    public Object visitModelSolutionDefinition(ModelSolutionDefinition modelSolutionDefinition, Object object) {
        this._printModel(modelSolutionDefinition.getModel(), object);
        this.print(".createSolvedSource(");
        this._printDefinition(modelSolutionDefinition.getDefaultValuesDefinition(), object);
        this.print(")");
        return null;
    }

    private void visitModel(Model model, Object object) {
        if (model instanceof CustomModel) {
            this.visitCustomModel((CustomModel)model, object);
        } else {
            this.visitMdmModel((MdmModel)model, object);
        }
    }

    private void visitMdmModel(MdmModel mdmModel, Object object) {
        if (mdmModel instanceof MdmDimensionedObjectModel) {
            MdmDimensionedObjectModel mdmDimensionedObjectModel = (MdmDimensionedObjectModel)mdmModel;
            SourceDefinition sourceDefinition = mdmDimensionedObjectModel.getMdmDimensionedObject().getSource().getDefinition();
            this._printDefinition(sourceDefinition, object);
            this.print(".getModel()");
            return;
        }
        MdmDimensionCalculationModel mdmDimensionCalculationModel = (MdmDimensionCalculationModel)mdmModel;
        MdmPrimaryDimension mdmPrimaryDimension = mdmDimensionCalculationModel.getMdmDimension();
        SourceDefinition sourceDefinition = mdmPrimaryDimension.getSource().getDefinition();
        this._printDefinition(sourceDefinition, object);
        if (mdmDimensionCalculationModel == mdmPrimaryDimension.getNumberCalcModel()) {
            this.print(".getNumberCalcModel()");
        } else if (mdmDimensionCalculationModel == mdmPrimaryDimension.getStringCalcModel()) {
            this.print(".getStringCalcModel()");
        } else if (mdmDimensionCalculationModel == mdmPrimaryDimension.getDateCalcModel()) {
            this.print(".getDateCalcModel()");
        } else if (mdmDimensionCalculationModel == mdmPrimaryDimension.getBooleanCalcModel()) {
            this.print(".getBooleanCalcModel()");
        } else if (mdmPrimaryDimension instanceof MdmMeasureDimension && mdmDimensionCalculationModel == ((MdmMeasureDimension)mdmPrimaryDimension).getValueCalcModel()) {
            this.print(".getValueCalcModel()");
        }
    }

    private void visitCustomModel(CustomModel customModel, Object object) {
        this.print("dataProvider.createModel(");
        this.incrementIndent();
        this.indent();
        this.print("new Source[]{");
        this.incrementIndent();
        this.indent();
        boolean bl = true;
        for (TransactionalObject transactionalObject : customModel.getInputs()) {
            if (bl) {
                bl = false;
            } else {
                this.print(",");
            }
            this.indent();
            this._printDefinition(transactionalObject.getDefinition(), object);
        }
        this.print("}  // Inputs");
        this.decrementIndent();
        this.indent();
        this._printDefinition(customModel.getType().getDefinition(), object);
        this.print(",  // Type");
        this.indent();
        if (customModel.getOutputs().size() == 0) {
            this.print("null,  // Outputs");
        } else {
            this.print("new Source[]{");
            this.incrementIndent();
            bl = true;
            for (TransactionalObject transactionalObject : customModel.getOutputs()) {
                if (bl) {
                    bl = false;
                } else {
                    this.print(",");
                }
                this.indent();
                this._printDefinition(transactionalObject.getDefinition(), object);
            }
            this.print("}  // Outputs");
            this.decrementIndent();
        }
        this.indent();
        if (customModel.getParentModels().size() == 0) {
            this.print("null)  // ParentModels");
        } else {
            this.print("new Model[]{");
            this.incrementIndent();
            bl = true;
            for (TransactionalObject transactionalObject : customModel.getParentModels()) {
                if (bl) {
                    bl = false;
                } else {
                    this.print(",");
                }
                this.indent();
                this._printModel((Model)transactionalObject, object);
            }
            this.print("})  // ParentModels");
            this.decrementIndent();
        }
        this.decrementIndent();
    }

    private void printModelAssignments(Model model, String string) {
        String string2 = string + ".assign(";
        for (Assignment assignment : model.getAssignments()) {
            this.indent();
            this.print(string2);
            this.incrementIndent();
            this.printQualifications(model, assignment);
            this.indent();
            this._printDefinition(assignment.getAssignedSource().getDefinition(), null);
            this.print(",");
            this.indent();
            this.print(assignment.getPrecedence() + ");  // Precedence");
            this.decrementIndent();
        }
    }

    private void printQualifications(Model model, Assignment assignment) {
        boolean bl = false;
        if (model.getInputs().size() == assignment.getQualifications().size()) {
            bl = true;
            Iterator iterator = assignment.getQualifications().iterator();
            Iterator iterator2 = model.getInputs().iterator();
            while (iterator.hasNext()) {
                LiteralQualification literalQualification = (LiteralQualification)iterator.next();
                Object object = (Source)iterator2.next();
                if (literalQualification.getQualifiedSource() == object && literalQualification.getLiteral() instanceof String) continue;
                bl = false;
                break;
            }
        }
        this.indent();
        boolean bl2 = false;
        if (!bl) {
            this.print("new Qualification[]{");
            bl2 = true;
        } else if (assignment.getQualifications().size() > 1) {
            this.print("new String[]{");
            bl2 = true;
        }
        if (bl2) {
            this.incrementIndent();
        }
        boolean bl3 = true;
        for (Object object : assignment.getQualifications()) {
            if (bl3) {
                bl3 = false;
            } else {
                this.print(",");
            }
            if (bl2) {
                this.indent();
            }
            if (!bl) {
                this.print("new LiteralQualification(");
                this._printDefinition(((Qualification)object).getQualifiedSource().getDefinition(), null);
                this.print(", ");
            }
            if (((LiteralQualification)object).getLiteral() instanceof String) {
                this.print("\"" + ((LiteralQualification)object).getLiteral() + "\"");
            } else if (((LiteralQualification)object).getLiteral() instanceof Short) {
                this.print("new Short(" + ((LiteralQualification)object).getLiteral() + ")");
            } else if (((LiteralQualification)object).getLiteral() instanceof Integer) {
                this.print("new Integer(" + ((LiteralQualification)object).getLiteral() + ")");
            } else if (((LiteralQualification)object).getLiteral() instanceof Float) {
                this.print("new Float(" + ((LiteralQualification)object).getLiteral() + ")");
            } else if (((LiteralQualification)object).getLiteral() instanceof Double) {
                this.print("new Double(" + ((LiteralQualification)object).getLiteral() + ")");
            } else if (((LiteralQualification)object).getLiteral() instanceof Date) {
                this.print("new java.util.Date(" + ((LiteralQualification)object).getLiteral() + ")");
            } else if (((LiteralQualification)object).getLiteral() instanceof Boolean) {
                if (((Boolean)((LiteralQualification)object).getLiteral()).booleanValue()) {
                    this.print("new Boolean(true)");
                } else {
                    this.print("new Boolean(false)");
                }
            }
            if (bl) continue;
            this.print(")");
        }
        if (bl2) {
            this.indent();
            this.print("},");
            this.decrementIndent();
        } else {
            this.print(",");
        }
    }
}

