/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.ArrayList;
import java.util.List;
import oracle.express.idl.util.XMLWriter;
import oracle.olapi.data.source.Assignment;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.ModelAssignmentManager;
import oracle.olapi.data.source.Qualification;
import oracle.olapi.data.source.Source;
import oracle.olapi.transaction.Transaction;

public final class CustomModel
implements Model {
    private DataProvider m_DataProvider = null;
    private String m_ID = null;
    private List m_Inputs = null;
    private List m_Outputs = null;
    private Source m_Type = null;
    private List m_ParentModels = null;
    private ModelAssignmentManager m_Manager = null;

    public CustomModel(DataProvider dataProvider, Source[] sourceArray, Source source, Source[] sourceArray2, Model[] modelArray, Transaction transaction) {
        this.m_Manager = new ModelAssignmentManager(this, dataProvider);
        this.setID(dataProvider._getSourceIDProvider().createCustomModelID());
        this.setDataProvider(dataProvider);
        this.setInputs(sourceArray);
        this.setOutputs(sourceArray2);
        this.setType(source);
        this.setParentModels(modelArray);
    }

    private ModelAssignmentManager getManager() {
        return this.m_Manager;
    }

    private void setID(String string) {
        this.m_ID = string;
    }

    public final String getID() {
        return this.m_ID;
    }

    private void setInputs(Source[] sourceArray) {
        this.m_Inputs = new ArrayList();
        if (sourceArray != null) {
            for (int i = 0; i < sourceArray.length; ++i) {
                this.m_Inputs.add(sourceArray[i]);
            }
        }
    }

    private void setOutputs(Source[] sourceArray) {
        this.m_Outputs = new ArrayList();
        if (sourceArray != null) {
            for (int i = 0; i < sourceArray.length; ++i) {
                this.m_Outputs.add(sourceArray[i]);
            }
        }
    }

    private void setType(Source source) {
        this.m_Type = source;
    }

    private void setParentModels(Model[] modelArray) {
        this.m_ParentModels = new ArrayList();
        if (modelArray != null) {
            for (int i = 0; i < modelArray.length; ++i) {
                this.m_ParentModels.add(modelArray[i]);
            }
        }
    }

    public final DataProvider getDataProvider() {
        return this.m_DataProvider;
    }

    public final Source getType() {
        return this.m_Type;
    }

    public final List getInputs() {
        return this.m_Inputs;
    }

    public final List getOutputs() {
        return this.m_Outputs;
    }

    public final List getParentModels() {
        return this.m_ParentModels;
    }

    private void setDataProvider(DataProvider dataProvider) {
        this.m_DataProvider = dataProvider;
    }

    public List getAssignments() {
        return this.getManager().getAssignments();
    }

    public List getAssignments(Transaction transaction) {
        return this.getManager().getAssignments(transaction);
    }

    public List getAutoAssignments() {
        return new ArrayList();
    }

    public void assign(Qualification[] qualificationArray, Source source) {
        this.getManager().assign(qualificationArray, source);
    }

    public void assign(Qualification[] qualificationArray, Source source, int n) {
        this.getManager().assign(qualificationArray, source, n);
    }

    public void assign(String string, Source source) {
        this.getManager().assign(string, source);
    }

    public void assign(String string, Source source, int n) {
        this.getManager().assign(string, source, n);
    }

    public void assign(String[] stringArray, Source source) {
        this.getManager().assign(stringArray, source);
    }

    public void assign(String[] stringArray, Source source, int n) {
        this.getManager().assign(stringArray, source, n);
    }

    public void unassign(Assignment assignment) {
        this.getManager().unassign(assignment);
    }

    public int getDefaultPrecedence() {
        return this.getManager().getDefaultPrecedence();
    }

    public void setDefaultPrecedence(int n) {
        this.getManager().setDefaultPrecedence(n);
    }

    public final void gatherSourcesInAssignments(List list) {
        this.getManager().gatherReferencedSources(list);
    }

    public final void gatherSourcesInAssignments(List list, Transaction transaction) {
        this.getManager().gatherReferencedSources(list, transaction);
    }

    public final void writeXMLForAssignments(XMLWriter xMLWriter) {
        this.getManager().writeXML(xMLWriter);
    }

    public final void writeXMLForAssignments(XMLWriter xMLWriter, Transaction transaction) {
        this.getManager().writeXML(xMLWriter, transaction);
    }

    public final Source createSolvedSource() {
        return this.getManager().createSolvedSource();
    }

    public final Source createSolvedSource(Source source) {
        return this.getManager().createSolvedSource(source);
    }

    public Transaction getActiveTransaction() {
        return this.getManager().getActiveTransaction();
    }

    public boolean isModified(Transaction transaction) {
        return this.getManager().isModified(transaction);
    }

    public Object getTransactionalState(Transaction transaction) {
        return this.getManager().getTransactionalState(transaction);
    }
}

