/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import java.util.HashMap;
import java.util.Map;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.JoinDefinition;
import oracle.olapi.data.source.RangeDefinition;
import oracle.olapi.data.source.SourceDefinition;

class VisitedNameSource
extends DataDescriptorDefinitionVisitor {
    private NameContext context = new NameContext();
    private Map givenName = new HashMap();

    VisitedNameSource() {
    }

    public String makeName(SourceDefinition sourceDefinition) {
        String string = (String)this.givenName.get(sourceDefinition);
        if (string == null) {
            string = (String)sourceDefinition.acceptVisitor(this, this.context);
            this.givenName.put(sourceDefinition, string);
        }
        return string;
    }

    public boolean hasElement(SourceDefinition sourceDefinition) {
        return this.givenName.containsKey(sourceDefinition);
    }

    protected String createName(String string, Object object) {
        return ((NameContext)object).makeName(string);
    }

    public Object visitJoinDefinition(JoinDefinition joinDefinition, Object object) {
        return this.createName("join", object);
    }

    public Object visitRangeDefinition(RangeDefinition rangeDefinition, Object object) {
        return this.createName("range", object);
    }

    public Object visitSourceDefinition(SourceDefinition sourceDefinition, Object object) {
        return this.createName("source", object);
    }

    class NameContext {
        private Map typeIndex = new HashMap();

        NameContext() {
        }

        public String makeName(String string) {
            int n = this.getIndex(string) + 1;
            this.setIndex(string, n);
            return string + n;
        }

        private int getIndex(String string) {
            try {
                int n = (Integer)this.typeIndex.get(string);
                return n;
            }
            catch (Exception exception) {
                return 0;
            }
        }

        private void setIndex(String string, int n) {
            this.typeIndex.put(string, new Integer(n));
        }
    }
}

