/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.io.Reader;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;

public class ServerXMLReader
extends DefaultHandler {
    XMLReader m_XMLReader = null;
    ServerXMLReaderState m_State = null;

    ServerXMLReaderState getState() {
        return this.m_State;
    }

    void setState(ServerXMLReaderState serverXMLReaderState) {
        this.m_State = serverXMLReaderState;
    }

    XMLReader getXMLReader() {
        return this.m_XMLReader;
    }

    void setXMLReader(XMLReader xMLReader) {
        this.m_XMLReader = xMLReader;
    }

    ServerXMLReader() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("ServerData")) {
            return;
        }
        if (!string2.equals("CursorManagerResults")) {
            throw new SAXException(string2);
        }
        int n = this.getState().getCursorManagerCount();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4 = attributes.getValue(i);
            if (attributes.getLocalName(i).equals("CursorManagerID")) {
                if (n >= this.getState().getCursorManagerIDs().length) {
                    throw new SAXException("");
                }
                this.getState().getCursorManagerIDs()[n] = new Long(string4);
                continue;
            }
            if (attributes.getLocalName(i).equals("SQLStatement")) {
                if (n >= this.getState().getGeneratedSQLStatements().length) {
                    throw new SAXException("");
                }
                this.getState().getGeneratedSQLStatements()[n] = string4;
                continue;
            }
            throw new SAXException(attributes.getLocalName(i));
        }
        this.getState().incrementCursorManagerCount();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    void init() {
        ParserAdapter parserAdapter = new ParserAdapter((Parser)new SAXParser());
        parserAdapter.setContentHandler(this);
        parserAdapter.setEntityResolver(this);
        parserAdapter.setErrorHandler(this);
        this.setXMLReader(parserAdapter);
    }

    boolean readGeneratedSQLStatements(Reader reader, String[] stringArray, long[] lArray) {
        ServerXMLReaderState serverXMLReaderState = new ServerXMLReaderState(stringArray, lArray);
        this.setState(serverXMLReaderState);
        try {
            InputSource inputSource = new InputSource(reader);
            this.getXMLReader().parse(inputSource);
        }
        catch (Exception exception) {
            return false;
        }
        this.setState(null);
        return true;
    }

    public class ServerXMLReaderState {
        String[] m_GeneratedSQLStatements = null;
        long[] m_CursorManagerIDs = null;
        int m_CursorManagerCount = 0;

        ServerXMLReaderState(String[] stringArray, long[] lArray) {
            this.m_GeneratedSQLStatements = stringArray;
            this.m_CursorManagerIDs = lArray;
            this.m_CursorManagerCount = 0;
        }

        String[] getGeneratedSQLStatements() {
            return this.m_GeneratedSQLStatements;
        }

        void setGeneratedSQLStatements(String[] stringArray) {
            this.m_GeneratedSQLStatements = stringArray;
        }

        long[] getCursorManagerIDs() {
            return this.m_CursorManagerIDs;
        }

        void setCursorManagerIDs(long[] lArray) {
            this.m_CursorManagerIDs = lArray;
        }

        int getCursorManagerCount() {
            return this.m_CursorManagerCount;
        }

        void incrementCursorManagerCount() {
            ++this.m_CursorManagerCount;
        }
    }
}

