/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import java.io.ByteArrayOutputStream;
import oracle.express.idl.util.OlapiTracer;

class SegmentedByteArrayOutputStream
extends ByteArrayOutputStream {
    private byte[][] _buffers;
    private int _count;

    SegmentedByteArrayOutputStream() {
        OlapiTracer.enter("SegmentedByteArrayOutputStream.constructor");
        this._buffers = new byte[1][0];
        this._buffers[0] = null;
        this._count = this.count;
        OlapiTracer.leave("SegmentedByteArrayOutputStream.constructor");
    }

    SegmentedByteArrayOutputStream(int n) {
        super(n);
        OlapiTracer.enter("SegmentedByteArrayOutputStream.constructor");
        OlapiTracer.log("init size = " + n);
        this._buffers = new byte[1][0];
        this._buffers[0] = null;
        this._count = this.count;
        OlapiTracer.leave("SegmentedByteArrayOutputStream.constructor");
    }

    public void write(int n) {
        OlapiTracer.enter("SegmentedByteArrayOutputStream.write");
        if (OlapiTracer.isTracingEnabled()) {
            OlapiTracer.log("writing at: <" + (this._buffers.length - 1) + ", " + super.size() + ">");
        }
        super.write(n);
        if (Short.MAX_VALUE <= super.size()) {
            OlapiTracer.log("add new segment");
            byte[][] byArrayArray = new byte[this._buffers.length + 1][];
            System.arraycopy(this._buffers, 0, byArrayArray, 0, this._buffers.length - 1);
            if (Short.MAX_VALUE < this.buf.length) {
                byArrayArray[this._buffers.length - 1] = super.toByteArray();
            } else {
                byArrayArray[this._buffers.length - 1] = this.buf;
                this.buf = new byte[32];
            }
            super.reset();
            byArrayArray[this._buffers.length] = null;
            this._buffers = byArrayArray;
        }
        ++this._count;
        OlapiTracer.leave("SegmentedByteArrayOutputStream.write");
    }

    public void write(byte[] byArray, int n, int n2) {
        OlapiTracer.enter("SegmentedByteArrayOutputStream.write");
        int n3 = Math.min(n2, Short.MAX_VALUE - super.size());
        if (OlapiTracer.isTracingEnabled()) {
            OlapiTracer.log("writing from <" + (this._buffers.length - 1) + ", " + super.size() + "> to <" + (this._buffers.length - 1) + ", " + (super.size() + n3 - 1) + ">");
        }
        super.write(byArray, n, n3);
        int n4 = n + n3;
        n3 = n2 - n3;
        if (Short.MAX_VALUE <= super.size() || 0 != n3) {
            int n5 = n3 / Short.MAX_VALUE + 1;
            byte[][] byArrayArray = new byte[this._buffers.length + n5][];
            System.arraycopy(this._buffers, 0, byArrayArray, 0, this._buffers.length - 1);
            if (Short.MAX_VALUE < this.buf.length) {
                byArrayArray[this._buffers.length - 1] = super.toByteArray();
            } else {
                byArrayArray[this._buffers.length - 1] = this.buf;
                this.buf = new byte[32];
            }
            OlapiTracer.log("add " + n5 + " new segments");
            for (int i = 0; i < n5; ++i) {
                int n6 = Math.min(Short.MAX_VALUE, n3);
                byte[] byArray2 = null;
                if (Short.MAX_VALUE <= n6) {
                    byArray2 = new byte[n6];
                    System.arraycopy(byArray, n4, byArray2, 0, n6);
                } else {
                    super.reset();
                    super.write(byArray, n4, n6);
                }
                if (OlapiTracer.isTracingEnabled()) {
                    OlapiTracer.log("writing from <" + (this._buffers.length + i) + ", 0> to <" + (this._buffers.length + i) + ", " + (n6 - 1) + ">");
                }
                if (Short.MAX_VALUE <= n6) {
                    byArrayArray[this._buffers.length + i] = byArray2;
                }
                n4 += n6;
                n3 -= n6;
            }
            byArrayArray[this._buffers.length + n5 - 1] = null;
            this._buffers = byArrayArray;
        }
        this._count += n2;
        OlapiTracer.leave("SegmentedByteArrayOutputStream.write");
    }

    public void append(byte[][] byArray) {
        OlapiTracer.enter("SegmentedByteArrayOutputStream.append");
        byte[][] byArrayArray = new byte[this._buffers.length + byArray.length + (0 != super.size() ? 1 : 0)][];
        System.arraycopy(this._buffers, 0, byArrayArray, 0, this._buffers.length - 1);
        if (0 != super.size()) {
            byArrayArray[this._buffers.length - 1] = super.toByteArray();
        }
        System.arraycopy(byArray, 0, byArrayArray, this._buffers.length - (0 != super.size() ? 0 : 1), byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            this._count += byArray[i].length;
        }
        byArrayArray[this._buffers.length + byArray.length - (0 != super.size() ? 0 : 1)] = null;
        super.reset();
        this._buffers = byArrayArray;
        OlapiTracer.log("append " + byArray.length + " segments");
        OlapiTracer.leave("SegmentedByteArrayOutputStream.append");
    }

    public int size() {
        return this._count;
    }

    public byte[][] getBuffers() {
        OlapiTracer.enter("SegmentedByteArrayOutputStream.getBuffers");
        if (0 != super.size()) {
            this._buffers[this._buffers.length - 1] = super.toByteArray();
        } else {
            byte[][] byArrayArray = new byte[this._buffers.length - 1][];
            System.arraycopy(this._buffers, 0, byArrayArray, 0, this._buffers.length - 1);
            this._buffers = byArrayArray;
        }
        OlapiTracer.log("There are " + this._buffers.length + " segments");
        OlapiTracer.leave("SegmentedByteArrayOutputStream.getBuffers");
        return this._buffers;
    }
}

