/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;

public class IndentPrintWriter
extends PrintWriter {
    static final char newLineChar = '\n';
    Stack indents = new Stack();
    String prefix = null;
    String defaultIndent = "    ";
    boolean atLeftMargin = true;

    public IndentPrintWriter(OutputStream out) {
        super(out);
    }

    public IndentPrintWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public IndentPrintWriter(Writer out) {
        super(out);
    }

    public IndentPrintWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public void setDefaultIndent(String defaultIndent) {
        this.defaultIndent = defaultIndent;
    }

    public void print(boolean b) {
        this.checkMargin();
        super.print(b);
    }

    public void print(char c) {
        this.checkMargin();
        super.print(c);
        if (c == '\n') {
            this.atLeftMargin = true;
        }
    }

    public void print(char[] s) {
        for (int x = 0; x < s.length; ++x) {
            this.print(s[x]);
        }
    }

    public void print(double d) {
        this.checkMargin();
        super.print(d);
    }

    public void print(float f) {
        this.checkMargin();
        super.print(f);
    }

    public void print(int i) {
        this.checkMargin();
        super.print(i);
    }

    public void print(Object obj) {
        this.checkMargin();
        this.print(String.valueOf(obj));
    }

    public void print(String s) {
        int xNewLine = s.indexOf(10);
        int xStart = 0;
        while (xNewLine > 0) {
            this.checkMargin();
            super.print(s.substring(xStart, xNewLine));
            this.println();
            xStart = xNewLine + 1;
            xNewLine = s.indexOf(10, xStart);
        }
        this.checkMargin();
        super.print(s.substring(xStart));
    }

    public void println() {
        this.checkMargin();
        super.println();
        this.atLeftMargin = true;
    }

    public void indent() {
        this.indent(this.defaultIndent);
    }

    public void indent(String more) {
        if (this.prefix == null) {
            this.prefix = more;
        } else {
            this.indents.push(this.prefix);
            this.prefix = this.prefix + more;
        }
    }

    public void predent(String more) {
        if (this.prefix == null) {
            this.prefix = more;
        } else {
            this.indents.push(this.prefix);
            this.prefix = more + this.prefix;
        }
    }

    public void outdent() {
        this.prefix = this.indents.empty() ? null : (String)this.indents.pop();
    }

    public void push() {
        this.indent();
    }

    public void push(String more) {
        this.indent(more);
    }

    public void prePush(String more) {
        this.predent(more);
    }

    public void pop() {
        this.outdent();
    }

    void doPrefix() {
        if (this.prefix != null) {
            super.print(this.prefix);
        }
    }

    void checkMargin() {
        if (this.atLeftMargin) {
            this.doPrefix();
            this.atLeftMargin = false;
        }
    }

    public static void main(String[] argv) {
        IndentPrintWriter w = new IndentPrintWriter(System.out);
        w.setDefaultIndent("....");
        for (int xArg = 0; xArg < argv.length; ++xArg) {
            if (argv[xArg].equals("+")) {
                w.indent();
                continue;
            }
            if (argv[xArg].equals("-")) {
                w.outdent();
                continue;
            }
            w.println(argv[xArg]);
        }
        w.flush();
    }
}

