/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.raptor.ExtrasMessages;
import oracle.javatools.controls.completionfield.FieldInsightProvider;

public class LoggerNameCompletion
implements FieldInsightProvider {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private DefaultListCellRenderer _renderer;

    public void completeInsight(Document document, int n, Object object) {
        try {
            document.remove(0, document.getLength());
            document.insertString(0, (String)object, null);
        }
        catch (BadLocationException badLocationException) {
            this.logger.log(Level.SEVERE, ExtrasMessages.getString((String)"LoggerNameCompletion.0"), badLocationException);
        }
    }

    public ListCellRenderer getCellRenderer() {
        if (this._renderer == null) {
            this._renderer = new DefaultListCellRenderer();
        }
        return this._renderer;
    }

    public Object[] getInsightData(Document document, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        String string = null;
        try {
            string = document.getText(0, n);
        }
        catch (BadLocationException badLocationException) {
            this.logger.log(Level.SEVERE, ExtrasMessages.getString((String)"LoggerNameCompletion.1"), badLocationException);
        }
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray();
    }

    public boolean handlesInsight(Document document, int n) {
        return true;
    }

    public boolean isAutoPopupChar(char c) {
        return true;
    }
}

