/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.offline;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistenceException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLHandler
extends DefaultHandler {
    private String[] values;
    private int count = 0;
    private boolean start = false;
    private StringBuffer lastValue = null;
    private String _endRowDelimiter;
    private String _endColumnDelimiter;

    public XMLHandler(int n) {
        this.values = new String[n];
        this._endRowDelimiter = "row";
        this._endColumnDelimiter = "col";
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.start = this._endColumnDelimiter.equals(string3);
        this.lastValue = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this._endColumnDelimiter.equals(string3)) {
            String string4 = this.values[this.count++] = this.lastValue == null ? null : this.lastValue.toString().trim();
        }
        if (this._endRowDelimiter.equals(string3)) {
            try {
                this.rowCompleted();
                Arrays.fill(this.values, null);
            }
            catch (PersistenceException persistenceException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
            }
            finally {
                this.count = 0;
                this.start = false;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = String.valueOf(cArray, n, n2);
        if (!this.start) {
            return;
        }
        if (this.lastValue == null) {
            this.lastValue = new StringBuffer();
        }
        this.lastValue.append(string);
    }

    public abstract void rowCompleted() throws PersistenceException;

    public String[] getRowData() {
        return this.values;
    }
}

