/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import oracle.mapviewer.share.RenderingRule;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.LocalThemeDefinition;

public class LocalTheme
extends Theme
implements Serializable {
    public LocalTheme(String name, Vector sfs) {
        this.setDefinition(new LocalThemeDefinition());
        this.definition.setName(name);
        this.setProducer(new LocalThemeDataProducer(this));
        ((LocalThemeDataProducer)this.producer).setStyledFeatures(sfs);
    }

    public LocalTheme(String name, ArrayList sfs) {
        this.setDefinition(new LocalThemeDefinition());
        this.definition.setName(name);
        this.setProducer(new LocalThemeDataProducer(this));
        ((LocalThemeDataProducer)this.producer).setStyledFeatures(sfs);
    }

    public LocalTheme(String name, StyledFeatureI[] sfs) {
        this.setDefinition(new LocalThemeDefinition());
        this.definition.setName(name);
        this.setProducer(new LocalThemeDataProducer(this));
        ((LocalThemeDataProducer)this.producer).setStyledFeatures(sfs);
    }

    public LocalTheme(String name) {
        this.setDefinition(new LocalThemeDefinition());
        this.definition.setName(name);
        this.setProducer(new LocalThemeDataProducer(this));
    }

    @Override
    public boolean isTextLabelPresent() {
        return ((LocalThemeDataProducer)this.producer).isTextLabelPresent();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.definition.getName());
        out.writeDouble(this.decorator.getMinScale());
        out.writeDouble(this.decorator.getMaxScale());
        StyledFeatureI[] sfs = this.producer.getStyledFeatures();
        int nStyledFeatures = sfs != null ? sfs.length : 0;
        out.writeInt(nStyledFeatures);
        for (int i = 0; i < nStyledFeatures; ++i) {
            out.writeObject(sfs[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.setDefinition(new LocalThemeDefinition());
        String name = in.readUTF();
        this.definition.setName(name);
        this.decorator.setMinScale(in.readDouble());
        this.decorator.setMaxScale(in.readDouble());
        int nStyledFeatures = in.readInt();
        if (nStyledFeatures == 0) {
            return;
        }
        StyledFeatureI[] sfs = new StyledFeatureI[nStyledFeatures];
        for (int i = 0; i < nStyledFeatures; ++i) {
            sfs[i] = (StyledFeature)in.readObject();
        }
        this.setProducer(new LocalThemeDataProducer(this));
        ((LocalThemeDataProducer)this.producer).setStyledFeatures(sfs);
    }

    @Override
    public void destroy() {
    }

    @Override
    public String[] getRenderingStyles() {
        StyledFeatureI[] sfs = ((LocalThemeDataProducer)this.producer).getStyledFeatures();
        if (sfs == null || sfs.length < 1) {
            return null;
        }
        ArrayList<String> styleNames = new ArrayList<String>();
        for (int i = 0; i < sfs.length; ++i) {
            RenderingRule[] rrules;
            String style = sfs[i].getFeatureStyleName();
            if (style != null && !styleNames.contains(style.toUpperCase())) {
                styleNames.add(style.toUpperCase());
            }
            if ((rrules = sfs[i].getRenderingRules()) == null) continue;
            for (int j = 0; j < rrules.length; ++j) {
                style = rrules[j].getStyleName();
                if (style == null || styleNames.contains(style.toUpperCase())) continue;
                styleNames.add(style.toUpperCase());
            }
        }
        if (styleNames.size() < 1) {
            return null;
        }
        return styleNames.toArray(new String[styleNames.size()]);
    }

    @Override
    public String[] getLabelingStyles() {
        StyledFeatureI[] sfs = ((LocalThemeDataProducer)this.producer).getStyledFeatures();
        if (sfs == null || sfs.length < 1) {
            return null;
        }
        ArrayList<String> styleNames = new ArrayList<String>();
        for (int i = 0; i < sfs.length; ++i) {
            String style = sfs[i].getLabelStyleName();
            if (style == null || styleNames.contains(style.toUpperCase())) continue;
            styleNames.add(style.toUpperCase());
        }
        if (styleNames.size() < 1) {
            return null;
        }
        return styleNames.toArray(new String[styleNames.size()]);
    }
}

