/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.utils;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.utils.MapCSBean;
import oracle.sdovis.JSDOGeometry;
import oracle.spatial.geometry.JGeometry;

public class CSTransformUtils {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.MAPVIEWER);
    static String host;
    static String port;
    static String sid;
    static String user;
    static String passwd;
    static String origTable;
    static String origColumn;
    static String destTable;
    static final double P1 = Math.PI / 360;
    static final double P2 = Math.PI / 180;
    static final double P3 = 111319.49079333333;
    static final double P4 = 1.5707963267948966;

    public static void toGoogleMercator(double lon, double lat, double[] res) {
        double x = lon * 111319.49079333333;
        double y = Math.log(Math.tan((90.0 + lat) * (Math.PI / 360))) / (Math.PI / 180);
        res[0] = x;
        res[1] = y *= 111319.49079333333;
    }

    public static void inverseGoogleMercator(double x, double y, double[] res) {
        double lon = x / 2.003750834E7 * 180.0;
        double lat = y / 2.003750834E7 * 180.0;
        lat = 57.29577951308232 * (2.0 * Math.atan(Math.exp(lat * (Math.PI / 180))) - 1.5707963267948966);
        res[0] = lon;
        res[1] = lat;
    }

    public static JSDOGeometry doGoogleMercatorTransform(JSDOGeometry geom, boolean inverse) {
        int outputSRID = 0;
        if (geom == null) {
            return geom;
        }
        int origSrid = geom.getSRID();
        if (!inverse) {
            outputSRID = 3857;
            if (origSrid != 8307 || origSrid == 0) {
                return geom;
            }
        } else {
            outputSRID = 8307;
        }
        double[] temp = new double[2];
        if (geom.isPoint()) {
            double[] coords = geom.getPoint();
            if (!inverse) {
                CSTransformUtils.toGoogleMercator(coords[0], coords[1], temp);
            } else {
                CSTransformUtils.inverseGoogleMercator(coords[0], coords[1], temp);
            }
            double[] ordsArray = geom.getOrdinatesArray();
            if (ordsArray != null) {
                double[] ordsArrayCopy = new double[ordsArray.length];
                System.arraycopy(ordsArray, 0, ordsArrayCopy, 0, ordsArray.length);
                ordsArrayCopy[0] = temp[0];
                ordsArrayCopy[1] = temp[1];
                double[] lp = geom.getLabelPointXYZ();
                if (lp != null && lp.length >= 2) {
                    if (!inverse) {
                        CSTransformUtils.toGoogleMercator(lp[0], lp[1], lp);
                    } else {
                        CSTransformUtils.inverseGoogleMercator(lp[0], lp[1], lp);
                    }
                }
                int gt = geom.getType();
                int dim = geom.getDimensions();
                int lrm = geom.getLRMDimension();
                int gtype = dim * 1000 + lrm * 100 + gt;
                JSDOGeometry ng = new JSDOGeometry(gtype, outputSRID, lp[0], lp[1], lp[2], geom.getElemInfo(), ordsArrayCopy);
                return ng;
            }
            return JSDOGeometry.recast(JGeometry.createPoint((double[])temp, (int)2, (int)outputSRID));
        }
        int gtype = geom.getType();
        double[] coords = geom.getOrdinatesArray();
        double[] coordsCopy = new double[coords.length];
        System.arraycopy(coords, 0, coordsCopy, 0, coords.length);
        int dim = geom.getDimensions();
        int lrm = geom.getLRMDimension();
        int increment = dim + lrm;
        int count = coords.length / increment;
        for (int i = 0; i < count; ++i) {
            double x = coords[i * increment];
            double y = coords[i * increment + 1];
            if (!inverse) {
                CSTransformUtils.toGoogleMercator(x, y, temp);
            } else {
                CSTransformUtils.inverseGoogleMercator(x, y, temp);
            }
            coordsCopy[i * increment] = temp[0];
            coordsCopy[i * increment + 1] = temp[1];
        }
        double[] lp = geom.getLabelPointXYZ();
        if (lp != null && lp.length >= 2) {
            if (!inverse) {
                CSTransformUtils.toGoogleMercator(lp[0], lp[1], lp);
            } else {
                CSTransformUtils.inverseGoogleMercator(lp[0], lp[1], lp);
            }
        }
        int gt = geom.getType();
        gtype = dim * 1000 + lrm * 100 + gt;
        JSDOGeometry ng = new JSDOGeometry(gtype, outputSRID, lp[0], lp[1], lp[2], geom.getElemInfo(), coordsCopy);
        return ng;
    }

    public static void doTransform(double x, double y, String fromSRID, String toSRID, double[] res) {
        if ("8307".equalsIgnoreCase(fromSRID) && "3857".equalsIgnoreCase(toSRID)) {
            CSTransformUtils.toGoogleMercator(x, y, res);
            return;
        }
        if ("3857".equalsIgnoreCase(fromSRID) && "8307".equalsIgnoreCase(toSRID)) {
            CSTransformUtils.inverseGoogleMercator(x, y, res);
            return;
        }
        Method m = null;
        Double zero = new Double(0.0);
        try {
            m = MapCSBean.getTransformMethod(fromSRID, toSRID);
            m.invoke(null, new Double(x), new Double(y), zero, res);
        }
        catch (Exception e1) {
            log.severe("Error transforming. " + e1.getMessage());
            return;
        }
    }

    public static JSDOGeometry doTransform(JSDOGeometry geom, String fromSRID, String toSRID) {
        if ("8307".equalsIgnoreCase(fromSRID) && "3857".equalsIgnoreCase(toSRID)) {
            return CSTransformUtils.doGoogleMercatorTransform(geom, false);
        }
        if ("3857".equalsIgnoreCase(fromSRID) && "8307".equalsIgnoreCase(toSRID)) {
            return CSTransformUtils.doGoogleMercatorTransform(geom, true);
        }
        Method m = null;
        Double zero = new Double(0.0);
        try {
            m = MapCSBean.getTransformMethod(fromSRID, toSRID);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return geom;
        }
        if (geom == null) {
            return geom;
        }
        int origSrid = geom.getSRID();
        if (origSrid != 8307 || origSrid == 0) {
            return geom;
        }
        double[] temp = new double[2];
        if (geom.isPoint()) {
            double[] coords = geom.getPoint();
            try {
                m.invoke(null, new Double(coords[0]), new Double(coords[1]), zero, temp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            double[] ordsArray = geom.getOrdinatesArray();
            if (ordsArray != null) {
                double[] ordsArrayCopy = new double[ordsArray.length];
                System.arraycopy(ordsArray, 0, ordsArrayCopy, 0, ordsArray.length);
                ordsArrayCopy[0] = temp[0];
                ordsArrayCopy[1] = temp[1];
                double[] lp = geom.getLabelPointXYZ();
                int gt = geom.getType();
                int dim = geom.getDimensions();
                int lrm = geom.getLRMDimension();
                int gtype = dim * 1000 + lrm * 100 + gt;
                JSDOGeometry ng = new JSDOGeometry(gtype, Integer.parseInt(toSRID), lp[0], lp[1], lp[2], geom.getElemInfo(), ordsArrayCopy);
                return ng;
            }
            return JSDOGeometry.recast(JGeometry.createPoint((double[])temp, (int)2, (int)Integer.parseInt(toSRID)));
        }
        int gtype = geom.getType();
        double[] coords = geom.getOrdinatesArray();
        double[] coordsCopy = new double[coords.length];
        System.arraycopy(coords, 0, coordsCopy, 0, coords.length);
        int dim = geom.getDimensions();
        int lrm = geom.getLRMDimension();
        int increment = dim + lrm;
        int count = coords.length / increment;
        for (int i = 0; i < count; ++i) {
            double x = coords[i * increment];
            double y = coords[i * increment + 1];
            try {
                m.invoke(null, new Double(x), new Double(y), zero, temp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            coordsCopy[i * increment] = temp[0];
            coordsCopy[i * increment + 1] = temp[1];
        }
        double[] lp = geom.getLabelPointXYZ();
        int gt = geom.getType();
        gtype = dim * 1000 + lrm * 100 + gt;
        JSDOGeometry ng = new JSDOGeometry(gtype, Integer.parseInt(toSRID), lp[0], lp[1], lp[2], geom.getElemInfo(), coordsCopy);
        return ng;
    }

    public static void main(String[] args) {
        JSDOGeometry res = null;
        Random rand = new Random();
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            double nex = rand.nextDouble() * 20.0;
            JSDOGeometry geom = JSDOGeometry.recast(JGeometry.createPoint((double[])new double[]{-120.0 + nex, 27.5 + nex}, (int)2, (int)8307));
            res = CSTransformUtils.doTransform(geom, "8307", "3857");
        }
        long t2 = System.currentTimeMillis();
        System.out.println(res.toStringFull());
        System.out.println("Time spent on transform:" + (t2 - t1) + "ms.");
        double[] mbr = res.getMBR();
        System.out.println("mbr:" + mbr[0] + "," + mbr[1] + ", " + mbr[2] + "," + mbr[3]);
    }
}

