/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.was;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import java.io.File;
import java.util.Set;
import javax.management.ObjectName;
import oracle.jrf.AbstractServerPlatformSupport;
import oracle.jrf.Application;
import oracle.jrf.ApplicationIdentifier;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public abstract class WasServerPlatformSupport
extends AbstractServerPlatformSupport {
    public static String ORACLE_ADMIN_SERVER_NAME = "oracle.admin.server.name";
    public static String WAS_CELL_NAME_PROPERTY = "was.cell.name";

    @Override
    public String getPlatformName() {
        return "websphere";
    }

    @Override
    public String getServerConfigDirectory(String cellName, String serverName) throws PortabilityLayerException {
        return this.getServerConfigDirectory();
    }

    @Override
    public boolean isWebSphere() {
        return true;
    }

    @Override
    public String getServerName() throws PortabilityLayerException {
        if (this.serverName == null) {
            AdminService adminservice = AdminServiceFactory.getAdminService();
            ObjectName objectname = adminservice.getLocalServer();
            try {
                this.serverName = (String)adminservice.getAttribute(objectname, "name");
            }
            catch (Exception ex) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10003", new String[]{ex.getMessage()}), ex);
            }
        }
        return this.serverName;
    }

    @Override
    public String getServerLogPath() throws PortabilityLayerException {
        if (this.serverLogPath == null) {
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName queryName = new ObjectName("WebSphere:*,type=AdminOperations");
                Set objs = adminService.queryNames(queryName, null);
                if (!objs.isEmpty()) {
                    ObjectName thisObj = (ObjectName)objs.iterator().next();
                    this.serverLogPath = (String)adminService.invoke(thisObj, "expandVariable", (Object[])new String[]{"${LOG_ROOT}"}, new String[]{"java.lang.String"});
                    this.serverLogPath = this.serverLogPath + File.separator + this.getServerName();
                }
            }
            catch (Exception ex) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10005", new String[]{ex.getMessage()}), ex);
            }
        }
        return this.serverLogPath;
    }

    @Override
    public String getDomainName() throws PortabilityLayerException {
        if (this.domainName == null) {
            this.domainName = System.getProperty(WAS_CELL_NAME_PROPERTY);
            if (this.domainName == null) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20012", new String[]{WAS_CELL_NAME_PROPERTY}));
            }
        }
        return this.domainName;
    }

    @Override
    public Application getApplication() throws PortabilityLayerException {
        throw new PortabilityLayerException("getApplication is not supported");
    }

    @Override
    public ApplicationIdentifier getApplicationIdentifier() throws PortabilityLayerException {
        ApplicationIdentifier appIdentifier = null;
        try {
            String deploymentName = this.getApplicationName();
            appIdentifier = new ApplicationIdentifier(deploymentName, null, null, true);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10001", new String[]{e.getMessage()}), e);
        }
        return appIdentifier;
    }

    public static boolean isND() throws PortabilityLayerException {
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            String nodeName = adminService.getNodeName();
            ManagedObjectMetadataAccessor accessor = ManagedObjectMetadataAccessorFactory.createAccessor(null);
            ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(accessor);
            String serverEdition = helper.getNodeBaseProductShortName(nodeName);
            return serverEdition.equalsIgnoreCase("ND");
        }
        catch (Exception ex) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10026"), ex);
        }
    }

    private String getApplicationName() throws PortabilityLayerException {
        String applicationName = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (int i = 0; applicationName == null && i < 20; ++i) {
                applicationName = this.getApplicationNameFromClassLoader(loader);
                ClassLoader parent = loader.getParent();
                if (parent != null && parent != loader) {
                    loader = parent;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return applicationName;
    }

    private String getApplicationNameFromClassLoader(ClassLoader loader) {
        String firstLine;
        int appPos;
        String applicationName = null;
        String loaderString = loader.toString().trim();
        while (loaderString.startsWith("\n") && loaderString.length() > 0) {
            loaderString = loaderString.substring(1).trim();
        }
        String[] loaderStringLines = loaderString.split("\n", 2);
        if (loaderStringLines.length > 0 && (appPos = (firstLine = loaderStringLines[0].trim()).indexOf("[app:")) >= 0 && appPos + 5 < firstLine.length()) {
            String appNameSegment = firstLine.substring(appPos + 5);
            int closingBracketPosition = appNameSegment.indexOf(93);
            applicationName = closingBracketPosition > 0 ? appNameSegment.substring(0, closingBracketPosition) : appNameSegment;
        }
        return applicationName;
    }
}

