/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.templates;

import java.util.jar.JarFile;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.templates.AbstractTemplateBuilder;
import oracle.jrf.templates.Application;
import oracle.jrf.templates.EnvConfig;
import oracle.jrf.templates.Library;
import oracle.jrf.templates.StartupClass;
import oracle.jrf.templates.URLProvider;
import oracle.jrf.templates.WasTemplate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WasTemplateBuilder
extends AbstractTemplateBuilder {
    private static final String JVM_CONFIG_XML = "jvm-config.xml";
    private static final String SERVER_TOPOLOGY = "server-topology";
    private static final String ENV_CONFIG = "env-config";
    private static final String SYSTEM_PROPERTY = "java-system-property";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String POST_CLASSPATH = "post-classpath";
    private static final String PATH = "path";
    private static final String INITIAL_HEAP_SIZE = "initial-heap-size";
    private static final String MAX_HEAP_SIZE = "max-heap-size";
    private static final String PERM_HEAP_SIZE = "perm-size";
    private static final String MAX_PERM_HEAP_SIZE = "max-perm-size";
    private static final String HEAP_SIZE_32 = "heap-size-32";
    private static final String HEAP_SIZE_64 = "heap-size-64";
    private static final String WAS_CONFIG_XML = "config-was/config.xml";
    private static final String WAS_APPLICATION = "application";
    private static final String WAS_CUSTOM_SERVICE = "customService";
    private static final String WAS_CLASS_PATH = "classPath";
    private static final String WAS_SOURCE_PATH = "sourcePath";
    private static final String WAS_ISOLATED_CLASSLOADER = "isolatedClassLoader";
    private static final String WAS_ENABLE_DISTRIBUTION = "enableDistribution";
    private static final String WAS_STARTING_WEIGHT = "startingWeight";
    private static final String WAS_CLASS_NAME = "classname";
    private static final String WAS_ENABLE = "enable";
    private static final String WAS_URL_PROVIDER = "URLProvider";
    private static final String WAS_STREAM_HANDLER_CLASS_NAME = "streamHandlerClassName";
    private static final String WAS_PROTOCOL = "protocol";

    public WasTemplateBuilder() {
        this.template = new WasTemplate();
    }

    @Override
    protected void readConfigXml(JarFile templateJar) throws PortabilityLayerException {
        Element root = this.getDocumentElement(templateJar, WAS_CONFIG_XML);
        this.readApplications(root.getElementsByTagName(WAS_APPLICATION));
        this.readLibraries(root.getElementsByTagName("library"));
        this.readCustomServices(root.getElementsByTagName(WAS_CUSTOM_SERVICE));
        this.readUrlProviders(root.getElementsByTagName(WAS_URL_PROVIDER));
    }

    protected void readCustomServices(NodeList customServices) {
        for (int i = 0; i < customServices.getLength(); ++i) {
            StartupClass startup = new StartupClass();
            NodeList children = customServices.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (children.item(j).getNodeName().equals("name")) {
                    startup.name = children.item(j).getTextContent();
                    continue;
                }
                if (children.item(j).getNodeName().equals(WAS_CLASS_PATH)) {
                    startup.classPath = children.item(j).getTextContent();
                    continue;
                }
                if (children.item(j).getNodeName().equals(WAS_CLASS_NAME)) {
                    startup.className = children.item(j).getTextContent();
                    continue;
                }
                if (!children.item(j).getNodeName().equals(WAS_ENABLE)) continue;
                startup.enable = children.item(j).getTextContent();
            }
            this.template.allStartupClasses.put(startup.getName(), startup);
        }
    }

    protected void readUrlProviders(NodeList urlProviders) {
        for (int i = 0; i < urlProviders.getLength(); ++i) {
            URLProvider urlProvider = new URLProvider();
            NodeList children = urlProviders.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeName().equals("name")) {
                    urlProvider.name = child.getTextContent();
                    continue;
                }
                if (child.getNodeName().equals(WAS_STREAM_HANDLER_CLASS_NAME)) {
                    urlProvider.streamHandlerClassName = child.getTextContent();
                    continue;
                }
                if (!child.getNodeName().equals(WAS_PROTOCOL)) continue;
                urlProvider.protocol = child.getTextContent();
            }
            this.template.allUrlProviders.put(urlProvider.getName(), urlProvider);
        }
    }

    @Override
    protected void processApplicationChildNode(Application app, String nodeName, String nodeValue) {
        if (nodeName.equals("name")) {
            app.name = nodeValue;
        } else if (nodeName.equals(WAS_SOURCE_PATH)) {
            app.sourcePath = nodeValue;
        } else if (nodeName.equals(WAS_ENABLE_DISTRIBUTION)) {
            app.enableDistribution = nodeValue;
        } else if (nodeName.equals(WAS_STARTING_WEIGHT)) {
            app.startingWeight = nodeValue;
        }
    }

    @Override
    protected void processLibraryChildNode(Library lib, String nodeName, String nodeValue) {
        if (nodeName.equals("name")) {
            lib.name = nodeValue;
        } else if (nodeName.equals(WAS_CLASS_PATH)) {
            lib.sourcePath = nodeValue;
        } else if (nodeName.equals(WAS_ISOLATED_CLASSLOADER)) {
            lib.isolatedClassLoader = nodeValue;
        }
    }

    @Override
    protected void processConfigGroupResource(String nodeName, String nodeValue, String groupName) {
        if (nodeName.equals(WAS_APPLICATION)) {
            this.template.applications.get(groupName).add(this.template.allApplications.get(nodeValue));
        } else if (nodeName.equals(WAS_CUSTOM_SERVICE)) {
            this.template.startupClasses.get(groupName).add(this.template.allStartupClasses.get(nodeValue));
        } else if (nodeName.equals(WAS_URL_PROVIDER)) {
            this.template.urlProviders.get(groupName).add(this.template.allUrlProviders.get(nodeValue));
        } else {
            super.processConfigGroupResource(nodeName, nodeValue, groupName);
        }
    }

    @Override
    protected void readJvmConfig(JarFile templateJar) throws PortabilityLayerException {
        Element root = this.getDocumentElement(templateJar, JVM_CONFIG_XML);
        NodeList topos = root.getElementsByTagName(SERVER_TOPOLOGY);
        for (int i = 0; i < topos.getLength(); ++i) {
            EnvConfig config = new EnvConfig();
            config.name = topos.item(i).getAttributes().getNamedItem("name").getNodeValue();
            NodeList children = ((Element)topos.item(i)).getElementsByTagName(ENV_CONFIG).item(0).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                String nodeName = children.item(j).getNodeName();
                if (nodeName.equals(SYSTEM_PROPERTY)) {
                    config.properties.put(((Element)children.item(j)).getElementsByTagName(KEY).item(0).getTextContent(), ((Element)children.item(j)).getElementsByTagName(VALUE).item(0).getTextContent());
                    continue;
                }
                if (nodeName.equals(POST_CLASSPATH)) {
                    config.postClassPath = ((Element)children.item(j)).getElementsByTagName(PATH).item(0).getTextContent();
                    continue;
                }
                if (nodeName.equals(INITIAL_HEAP_SIZE)) {
                    config.initialHeapSize32 = ((Element)children.item(j)).getElementsByTagName(HEAP_SIZE_32).item(0).getTextContent();
                    config.initialHeapSize64 = ((Element)children.item(j)).getElementsByTagName(HEAP_SIZE_64).item(0).getTextContent();
                    continue;
                }
                if (nodeName.equals(MAX_HEAP_SIZE)) {
                    config.maxHeapSize32 = ((Element)children.item(j)).getElementsByTagName(HEAP_SIZE_32).item(0).getTextContent();
                    config.maxHeapSize64 = ((Element)children.item(j)).getElementsByTagName(HEAP_SIZE_64).item(0).getTextContent();
                    continue;
                }
                if (nodeName.equals(PERM_HEAP_SIZE)) {
                    config.permSize32 = ((Element)children.item(j)).getElementsByTagName(HEAP_SIZE_32).item(0).getTextContent();
                    config.permSize64 = ((Element)children.item(j)).getElementsByTagName(HEAP_SIZE_64).item(0).getTextContent();
                    continue;
                }
                if (!nodeName.equals(MAX_PERM_HEAP_SIZE)) continue;
                config.maxPermSize32 = ((Element)children.item(j)).getElementsByTagName(HEAP_SIZE_32).item(0).getTextContent();
                config.maxPermSize64 = ((Element)children.item(j)).getElementsByTagName(HEAP_SIZE_64).item(0).getTextContent();
            }
            this.template.allEnvConfigs.put(config.getName(), config);
        }
    }
}

