/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.io.File;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public abstract class AbstractServerPlatformSupport
implements ServerPlatformSupport {
    public static final String ORACLE_DOMAIN_CONFIG_DIR = "oracle.domain.config.dir";
    public static final String ORACLE_SERVER_CONFIG_DIR = "oracle.server.config.dir";
    protected String serverName = null;
    protected String adminServerName = null;
    protected String serverLogPath = null;
    protected String domainConfigDir = null;
    protected String serverConfigDir = null;
    protected String domainName = null;
    protected Boolean isExalogicOptimizationsEnabled = null;
    protected String commonComponentsHome = null;
    private PortConfig portConfig = null;
    private NotificationListener portConfigListener = null;

    @Override
    public String[] getSupportedPlatformNames() {
        return new String[]{"weblogic", "websphere", "jboss"};
    }

    @Override
    public boolean isWebLogic() {
        return false;
    }

    @Override
    public boolean isWebSphere() {
        return false;
    }

    @Override
    public boolean isJBoss() {
        return false;
    }

    @Override
    public boolean isAdminServer() throws PortabilityLayerException {
        return this.getServerName().equals(this.getAdminServerName());
    }

    @Override
    public String getDomainConfigDirectory() throws PortabilityLayerException {
        if (this.domainConfigDir == null) {
            this.domainConfigDir = System.getProperty(ORACLE_DOMAIN_CONFIG_DIR);
            if (this.domainConfigDir == null) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10022"));
            }
        }
        return this.domainConfigDir;
    }

    @Override
    public String getServerConfigDirectory() throws PortabilityLayerException {
        if (this.serverConfigDir == null) {
            this.serverConfigDir = System.getProperty(ORACLE_SERVER_CONFIG_DIR);
            if (this.serverConfigDir == null) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10023"));
            }
        }
        return this.serverConfigDir;
    }

    @Override
    public boolean isWebSphereND() {
        return false;
    }

    @Override
    public boolean isWebSphereAS() {
        return false;
    }

    public void init() throws PortabilityLayerException {
        this.getServerLogPath();
        this.getServerName();
        this.getDomainConfigDirectory();
        this.getServerConfigDirectory();
        this.isExalogicOptimizationsEnabled();
    }

    protected NotificationListener getPortConfigNotificationListener() {
        if (this.portConfigListener == null) {
            this.portConfigListener = new NotificationListener(){

                @Override
                public void handleNotification(Notification notification, Object handback) {
                    if (notification instanceof AttributeChangeNotification) {
                        AbstractServerPlatformSupport.this.handlePortConfigChangeNotification(notification, handback);
                    }
                }
            };
        }
        return this.portConfigListener;
    }

    protected abstract PortConfig getNewPortConfig() throws PortabilityLayerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortConfig getPortConfig() throws PortabilityLayerException {
        boolean isListenerNotRegistered;
        boolean bl = isListenerNotRegistered = this.portConfigListener == null;
        if (isListenerNotRegistered) {
            this.getPortConfigNotificationListener();
        }
        NotificationListener notificationListener = this.portConfigListener;
        synchronized (notificationListener) {
            if (this.portConfig == null) {
                this.portConfig = this.getNewPortConfig();
            }
            if (isListenerNotRegistered) {
                this.portConfig.registerPortConfigChangeListener(this.portConfigListener);
            }
            return this.portConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePortConfigChangeNotification(Notification notification, Object handback) {
        NotificationListener notificationListener = this.portConfigListener;
        synchronized (notificationListener) {
            this.portConfig = null;
        }
    }

    @Override
    public boolean isExalogicOptimizationsEnabled() {
        return false;
    }

    @Override
    public String getCommonComponentsHome() throws PortabilityLayerException {
        if (this.commonComponentsHome == null) {
            String cch = System.getProperty("common.components.home");
            if (cch == null) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10012"));
            }
            if (!new File(cch).exists()) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10012", new String[]{cch}));
            }
            this.commonComponentsHome = cch;
        }
        return this.commonComponentsHome;
    }

    @Override
    public String getPartitionName() throws PortabilityLayerException {
        return null;
    }

    @Override
    public boolean isRestricted() {
        return Boolean.getBoolean("oracle.jrf.restrictedMode");
    }
}

