/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.javatools.ui.table.GenericTablePersistentSettings;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;

public abstract class GITBranchPanel
extends DefaultTraversablePanel {
    private JMultiLineLabel _hintText = new JMultiLineLabel();
    private GenericTable _table = new GenericTable((TableModel)new BranchTableModel());
    private JButton _btnSelect = new JButton();
    private JButton _btnDeselect = new JButton();

    public GITBranchPanel() {
        this.init();
        this.addListeners();
    }

    protected abstract String getHintText();

    protected abstract String getBranchPersistKey();

    private void init() {
        Insets ins = new Insets(5, 5, 5, 5);
        this._hintText.setText(this.getHintText());
        ResourceUtils.resButton((AbstractButton)this._btnSelect, (String)Resource.get("BRANCH_SELECT_ALL"));
        ResourceUtils.resButton((AbstractButton)this._btnDeselect, (String)Resource.get("BRANCH_DESELECT_ALL"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hintText, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(new JScrollPane((Component)this._table), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(this._btnSelect, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add(this._btnDeselect, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
    }

    private void addListeners() {
        this._btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITBranchPanel.this.selectAllBranches(true);
            }
        });
        this._btnDeselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITBranchPanel.this.selectAllBranches(false);
            }
        });
    }

    private void selectAllBranches(boolean enable) {
        TableModel model = this._table.getModel();
        for (int r = 0; r < model.getRowCount(); ++r) {
            model.setValueAt(enable, r, 0);
        }
    }

    public void onEntry(TraversableContext dataContext) {
        if (dataContext.getDirection() == 1) {
            Map branches = (Map)dataContext.get("git.remote-branches");
            String remoteName = (String)dataContext.get("git.remote-name");
            ((BranchTableModel)this._table.getModel()).addData(branches.keySet(), remoteName);
            Map activebranch = (Map)dataContext.get("git.use-branches");
            if (activebranch != null && !activebranch.isEmpty() && activebranch.keySet().size() == 1) {
                String[] activeBranch = activebranch.keySet().toArray(new String[0]);
                ((BranchTableModel)this._table.getModel()).setBranchSelect(activeBranch[0]);
            }
            this._table.setSortColumn(1, true);
            Map settings = (Map)Ide.getDTCache().getData(this.getBranchPersistKey());
            if (settings != null) {
                this._table.setPersistentSettings(new GenericTablePersistentSettings(settings));
            }
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            Map branches = ((BranchTableModel)this._table.getModel()).getIncludeBranches();
            if (branches.isEmpty()) {
                throw new TraversalException(Resource.get("WZ_NO_BRANCH"), Resource.get("WZ_NO_BRANCH_TITLE"));
            }
            dataContext.put("git.use-branches", (Object)branches);
            GenericTablePersistentSettings settings = this._table.getPersistentSettings();
            Ide.getDTCache().putData(this.getBranchPersistKey(), settings.toMap());
        }
    }

    private static class BranchTableModel
    extends DefaultTableModel
    implements GenericTableModel {
        private String[] _columns = new String[]{Resource.get("WZ_BRANCH_COLUMN1"), Resource.get("WZ_BRANCH_COLUMN2"), Resource.get("WZ_BRANCH_COLUMN3")};
        private String[] _fromBranch;
        private Boolean[] _include;
        private String _remoteName;

        private BranchTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this._columns.length;
        }

        @Override
        public String getColumnName(int col) {
            return this._columns[col];
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                this._include[row] = (Boolean)value;
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0 && row < this._include.length) {
                return this._include[row];
            }
            if (col == 1) {
                return this._fromBranch[row];
            }
            if (col == 2) {
                return this.getToBranch(row);
            }
            return new Object();
        }

        private String getToBranch(int row) {
            return GITUtil.getRemoteBranchName(this._remoteName, this._fromBranch[row]);
        }

        @Override
        public int getRowCount() {
            if (this._fromBranch == null || this._fromBranch.length == 0) {
                return 0;
            }
            return this._fromBranch.length;
        }

        private void addData(Set<String> branches, String remote) {
            this._fromBranch = branches.toArray(new String[0]);
            this._remoteName = remote;
            this._include = new Boolean[branches.size()];
            for (int b = 0; b < this._include.length; ++b) {
                this._include[b] = Boolean.FALSE;
            }
            this.fireTableDataChanged();
        }

        private Map<String, String> getIncludeBranches() {
            HashMap<String, String> branches = new HashMap<String, String>();
            for (int b = 0; b < this._include.length; ++b) {
                if (!this._include[b].booleanValue()) continue;
                branches.put(this._fromBranch[b], this.getToBranch(b));
            }
            return branches;
        }

        private void setBranchSelect(String branch) {
            for (int b = 0; b < this._fromBranch.length; ++b) {
                if (!this._fromBranch[b].equals(branch)) continue;
                this._include[b] = Boolean.TRUE;
                return;
            }
        }

        public int getColumnAlignment(int column) {
            if (column == 0) {
                return 0;
            }
            return 2;
        }

        public boolean canHide(int column) {
            return column == 2;
        }
    }
}

