/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITResetCustomizer;
import oracle.jdevimpl.vcs.xspi.VCSBugTrackingManager;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationReset
extends GITExtendedAbstractOperation {
    private static final String OPTION_RESET = "git-reset-option";
    private static final Integer OPTION_MIXED = 1;
    private static final Integer OPTION_HARD = 2;
    private static final Integer OPTION_SOFT = 3;
    private static final String COMMAND_ID = "oracle.jdeveloper.git.reset";
    private URL _root;
    private String _activeBranch;

    public GITOperationReset() {
        super(COMMAND_ID);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        return this.getLocatableFromNavOrProfile(profile);
    }

    protected String getDialogHint() {
        if (this._activeBranch != null) {
            return Resource.format("OPERATION_RESET_DIALOG_HINT", this._activeBranch);
        }
        return super.getDialogHint();
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        try {
            Locatable[] locatables = this.getOperands(this.getProfile());
            if (locatables.length > 0) {
                Map<String, Object> options = null;
                this._root = locatables[0].getURL();
                Map<String, GitBranch> branches = GITUtil.getBranches(this._root, false);
                GitBranch active = GITUtil.getActiveBranch(branches);
                if (active != null) {
                    this._activeBranch = active.getName();
                    options = this.getBranchRevisionOptions(this._root, this._activeBranch, false);
                    options.putAll(this.getResetOptions());
                }
                GITResetCustomizer customizer = new GITResetCustomizer();
                customizer.setOptions(options);
                return customizer;
            }
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITOperationReset.class.getName()).log(Level.WARNING, "Merge Operation failed ", e);
        }
        return null;
    }

    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        String revision = (String)options.get("Git-use-revision");
        GITResetCustomizer.ResetOption resetOpt = (GITResetCustomizer.ResetOption)((Object)options.get("git-reset"));
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("RESET_OPERATION"));
        final IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)IdeUtil.getMainWindow(), Resource.get("RESET_PROGRESS_TITLE"), (Object)Resource.get("RESET_PROGRESS"), null);
        VCSCancellable cancellable = new VCSCancellable(){

            public boolean isCancelled() {
                return progress.isCanceled();
            }
        };
        progress.start();
        GitClient client = null;
        try {
            monitor.setLog(true);
            monitor.setCancellable(cancellable);
            client = GITClientAdaptor.getClient(this._root);
            Collection<String> revisions = this.getRevisions(client, revision, monitor);
            Collection<File> modifiedFiles = GITUtil.getModifiedFiles(client, revision, this._activeBranch, monitor);
            this.setProcessedUrls(commandState, GITUtil.convertFileToUrl(modifiedFiles.toArray(new File[0])).toArray(new URL[0]));
            client.reset(revision, this.getGitResetType(resetOpt), (ProgressMonitor)monitor);
            this.persistResetType(resetOpt);
            VCSBugTrackingManager.getInstance().removeCommits(revisions, "Git");
        }
        catch (GitException e) {
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_RESET_ERROR"), e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
            monitor.logCompleted();
            progress.finish();
        }
        return true;
    }

    private Map<String, Object> getResetOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        Integer type = Ide.getDTCache().getInteger(OPTION_RESET, OPTION_MIXED.intValue());
        if (type == OPTION_MIXED) {
            options.put("git-reset", (Object)GITResetCustomizer.ResetOption.MIXED);
        } else if (type == OPTION_HARD) {
            options.put("git-reset", (Object)GITResetCustomizer.ResetOption.HARD);
        } else if (type == OPTION_SOFT) {
            options.put("git-reset", (Object)GITResetCustomizer.ResetOption.SOFT);
        }
        return options;
    }

    private void persistResetType(GITResetCustomizer.ResetOption resetOpt) {
        if (resetOpt == GITResetCustomizer.ResetOption.MIXED) {
            Ide.getDTCache().putInteger(OPTION_RESET, OPTION_MIXED);
        } else if (resetOpt == GITResetCustomizer.ResetOption.HARD) {
            Ide.getDTCache().putInteger(OPTION_RESET, OPTION_HARD);
        } else if (resetOpt == GITResetCustomizer.ResetOption.SOFT) {
            Ide.getDTCache().putInteger(OPTION_RESET, OPTION_SOFT);
        }
    }

    private GitClient.ResetType getGitResetType(GITResetCustomizer.ResetOption resetOpt) {
        if (resetOpt == GITResetCustomizer.ResetOption.MIXED) {
            return GitClient.ResetType.MIXED;
        }
        if (resetOpt == GITResetCustomizer.ResetOption.HARD) {
            return GitClient.ResetType.HARD;
        }
        if (resetOpt == GITResetCustomizer.ResetOption.SOFT) {
            return GitClient.ResetType.SOFT;
        }
        return null;
    }
}

