/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.tracking.VCSBugTrackingContext;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITExportCommitted;
import oracle.jdevimpl.vcs.xspi.VCSBugCommandState;
import oracle.jdevimpl.vcs.xspi.VCSBugComponents;
import oracle.jdevimpl.vcs.xspi.VCSBugTrackingManager;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationExportCommitted
extends GITExtendedAbstractOperation {
    private static final String EXPORTNAME = "ExportCommitted";
    private static final String F1_HELP_ID = "f1_git_export_committed_html";

    public GITOperationExportCommitted() {
        super("oracle.jdeveloper.git.export-committed", VCSCommandStyle.NORMAL);
    }

    public GITOperationExportCommitted(String id) {
        super(id);
    }

    protected String getDialogTitle() {
        return Resource.get("ACTION_EXPORT_COM_DIALOG_TITLE");
    }

    protected CommandState createCommandState() {
        return new VCSBugCommandState();
    }

    @Override
    protected JEWTDialog createOperationDialogImpl(Collection nodes, final VCSOptionsCustomizer customizer, CommandState commandState) {
        ((VCSBugCommandState)commandState).getBugContext().addPropertyListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("patch-attach-task")) {
                    Map options = customizer.getOptions();
                    options.put("PatchLocation", (Boolean)evt.getNewValue() == false);
                    customizer.setOptions(options);
                }
            }
        });
        return VCSBugComponents.createPatchOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)VCSComponents.createFileListerComponent((Collection)nodes, (TableCellRenderer)this.createFileListerRenderer()), (VCSOptionsCustomizer)customizer, (String)this.getHelpTopicId(), (VCSBugTrackingContext)((VCSBugCommandState)commandState).getBugContext());
    }

    protected void configureCommandState(CommandState commandState, VCSDirectoryInvokableState invokableState, Map timestamps, Locatable[] locatables) {
        super.configureCommandState(commandState, invokableState, timestamps, locatables);
        VCSBugTrackingContext context = new VCSBugTrackingContext("Git");
        context.setURL(this.getURLfromLocatable(locatables));
        ((VCSBugCommandState)commandState).setBugContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doitImplInvoke(VCSProfile profile, Locatable[] locatables) throws Exception {
        GitClient client = null;
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("EXPORT_COMMITTED_OPERATION"));
        try {
            client = GITClientAdaptor.getClient(locatables[0].getURL());
            SearchCriteria sc = new SearchCriteria();
            File[] files = new File[]{new File(locatables[0].getURL().toURI())};
            sc.setFiles(files);
            sc.setLimit(1);
            GitRevisionInfo[] revisions = client.log(sc, (ProgressMonitor)monitor);
            if (revisions.length == 0) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("INFORMATION_NO_COMMITTED"), (String)Resource.get("INFORMATION_NO_COMMITTED_TITLE"), null);
                int n = 1;
                return n;
            }
            int n = super.doitImplInvoke(profile, locatables);
            return n;
        }
        finally {
            monitor.logCompleted();
            if (client != null) {
                client.release();
            }
        }
    }

    protected void setCommandSpecificCustomizerOptions(VCSProfile profile, VCSOptionsCustomizer customizer) {
    }

    protected String getHelpTopicId() {
        return F1_HELP_ID;
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] locs = this.getRootOperand(profile);
        if (locs.length == 0) {
            return super.getOperands(profile);
        }
        return locs;
    }

    @Override
    protected boolean invokeCommand(final VCSProfile profile, final CommandState commandState) throws Exception {
        List<Locatable> nodes = Arrays.asList(commandState.getLocatables());
        VCSOptionsCustomizer customizer = this.createOptionsCustomizer(commandState);
        this.setCommandSpecificCustomizerOptions(profile, customizer);
        final JEWTDialog dialog = this.createOperationDialog(nodes, customizer, commandState);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected boolean doCommitOperation(Map options) throws Exception {
                return GITOperationExportCommitted.this.invokeCommandImpl(profile, commandState, (Component)dialog, options);
            }
        });
        return VCSDialogRunner.runDialog((JDialog)dialog);
    }

    private VCSOptionsCustomizer createOptionsCustomizer(CommandState commandState) {
        Locatable[] locatables;
        try {
            locatables = this.getRootOperand(this.getProfile());
        }
        catch (Exception e) {
            return null;
        }
        if (locatables.length > 0) {
            try {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("ExportFile", this.getExportFileSuggestion(EXPORTNAME));
                options.put("RootURL", locatables[0].getURL());
                options.put("Branch", this.getCurrentBranch(locatables[0].getURL()));
                options.put("Tag", this.getTag());
                options.put("CommitId", this.getGitRevision(locatables[0].getURL()));
                GITExportCommitted customizer = new GITExportCommitted(commandState);
                customizer.setOptions(options);
                return customizer;
            }
            catch (GITProcessException e) {
                GITProfile.getQualifiedLogger(GITOperationExportCommitted.class.getName()).log(Level.SEVERE, " Failed to get branches " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        boolean rmFile = false;
        String commitid = (String)options.get("CommitId");
        String branch = (String)options.get("Branch");
        String tag = (String)options.get("Tag");
        URL rootUrl = (URL)options.get("RootURL");
        URL exportUrl = null;
        boolean saveUrl = true;
        if (options.get("ExportFile") != null) {
            exportUrl = (URL)options.get("ExportFile");
        } else {
            exportUrl = URLFileSystem.createTempFile((String)"diff", (String)".patch", (URL)URLFactory.newDirURL((String)System.getProperty("java.io.tmpdir")));
            saveUrl = false;
        }
        OutputStream os = null;
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("checkoutRevision");
        monitor.setLog(true);
        GitClient client = null;
        try {
            String revision = commitid;
            if (revision == null) {
                revision = branch != null ? branch : tag;
            }
            os = this.getOutputStream(exportUrl);
            client = GITClientAdaptor.getClient(rootUrl);
            client.exportCommit(revision, os, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("EXPORT_EXP_COMMIT_ERROR"), monitor.getError());
            }
            if (saveUrl) {
                this.saveExportLocation(exportUrl);
            }
            this.openEditor(exportUrl);
            VCSBugTrackingManager.getInstance().attachPatch(((VCSBugCommandState)commandState).getBugContext(), exportUrl);
        }
        catch (GitException ex) {
            rmFile = true;
            throw new GITProcessException(Resource.get("EXPORT_EXP_COMMIT_ERROR"), ex.getMessage());
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (rmFile) {
                    URLFileSystem.delete((URL)exportUrl);
                }
            }
            catch (Exception exception) {}
            if (client != null) {
                client.release();
            }
        }
        return true;
    }

    protected Object getGitRevision(URL url) {
        return null;
    }

    protected String getTag() {
        return null;
    }
}

