/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUser;
import oracle.jdevimpl.vcs.git.GITUtil;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

class GITConfig {
    private static String _defaultEmail;

    GITConfig() {
    }

    List<GITUser> getUsers(URL root) {
        ArrayList<GITUser> users = new ArrayList<GITUser>();
        URL url = URLFactory.newURL((URL)root, (String)"/.git/config");
        if (URLFileSystem.exists((URL)url)) {
            this.getConfigUser(url, users);
        }
        if (URLFileSystem.exists((URL)(url = URLFactory.newURL((String)(System.getProperty("user.home") + "/.gitconfig"))))) {
            this.getConfigUser(url, users);
        }
        if (users.isEmpty()) {
            GITUser user = new GITUser(System.getProperty("user.name"));
            user.setEmail(GITConfig.getDefaultEmail());
            users.add(user);
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConfigUser(URL url, List<GITUser> users) {
        FileBasedConfig cfg = new FileBasedConfig(new File(url.getPath()), FS.DETECTED);
        try {
            cfg.load();
            String name = cfg.getString("user", null, "name");
            String email = cfg.getString("user", null, "email");
            if (name == null) {
                return;
            }
            GITUser user = new GITUser(name);
            if (email != null) {
                user.setEmail(email);
            } else {
                user.setEmail(GITConfig.getDefaultEmail());
            }
            users.add(user);
        }
        catch (ConfigInvalidException e) {
            GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.SEVERE, "Local config " + e.getMessage());
        }
        catch (IOException e) {
            GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.SEVERE, "Local config " + e.getMessage());
        }
    }

    static String getDefaultEmail() {
        if (_defaultEmail == null) {
            String host;
            try {
                host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.SEVERE, "Host name unknown");
                host = "unknown";
            }
            StringBuilder sb = new StringBuilder(System.getProperty("user.name"));
            sb.append("@");
            sb.append(host);
            _defaultEmail = sb.toString();
        }
        return _defaultEmail;
    }
}

