/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.util.logging.Level;
import oracle.ide.config.Preferences;
import oracle.ide.log.LogManager;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITCommandProgressMonitor
extends ProgressMonitor {
    private String _operation;
    private String _error;
    private boolean _finished = false;
    private boolean _log = false;
    private VCSCancellable _cancel;

    public GITCommandProgressMonitor(String operation) {
        this._operation = operation;
    }

    public void setOperation(String operation) {
        this._operation = operation;
    }

    public boolean isCanceled() {
        if (this._cancel != null) {
            return this._cancel.isCancelled();
        }
        return false;
    }

    public void started(String command) {
        GITProfile.getQualifiedLogger(this._operation).log(Level.INFO, command);
        this.logMsg(command);
    }

    public void finished() {
        this._finished = true;
    }

    public void preparationsFailed(String message) {
        GITProfile.getQualifiedLogger(this._operation).log(Level.WARNING, "PreparationsFailed " + message);
    }

    public void notifyError(String message) {
        this._error = message;
        this.logMsg(message);
        GITProfile.getQualifiedLogger(this._operation).log(Level.WARNING, "Error " + message);
    }

    public void notifyWarning(String message) {
        this.logMsg(message);
        GITProfile.getQualifiedLogger(this._operation).log(Level.WARNING, "Warning " + message);
    }

    public String getError() {
        return this._error;
    }

    public boolean hasFinished() {
        return this._finished;
    }

    public void setLog(boolean log) {
        this._log = log;
    }

    public void logCompleted() {
        this.logMsg(Resource.format("COMPLETED_OPERATION", this._operation));
        GITProfile.getQualifiedLogger(this._operation).log(Level.INFO, Resource.format("COMPLETED_OPERATION", this._operation));
    }

    private void logMsg(String command) {
        if (this._log && this.isUserLog()) {
            LogManager.getLogManager().getMsgPage().log((Object)command);
            LogManager.getLogManager().getMsgPage().log((Object)"\n");
        }
    }

    private boolean isUserLog() {
        return VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), (String)"oracle.jdeveloper.git").getAutoLogMessages();
    }

    public void setCancellable(VCSCancellable cancel) {
        this._cancel = cancel;
    }
}

