/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.tool.CreateTool;

public class ClassCreateTool
extends CreateTool {
    private Class _createClass;
    private Constructor _construct;
    private Class[] _argTypes;
    private Object[] _argValues;

    public ClassCreateTool(Class createClass) {
        this.setCreateClass(createClass);
    }

    public ClassCreateTool(Class createClass, Class[] argTypes, Object[] argValues) {
        this.setCreateClass(createClass, argTypes, argValues);
    }

    public final void setCreateClass(Class createClass) {
        this.setCreateClass(createClass, null, null);
    }

    public void setCreateClass(Class createClass, Class[] argTypes, Object[] argValues) {
        if (createClass == null) {
            throw new IllegalArgumentException("can't create null class");
        }
        if (!LayoutItem.class.isAssignableFrom(createClass)) {
            throw new IllegalArgumentException("class not a LayoutItem");
        }
        if (argTypes != null && argTypes.length != argValues.length) {
            throw new IllegalArgumentException("argTypes.length != argValues.length");
        }
        try {
            this._construct = argTypes == null ? createClass.getConstructor(new Class[0]) : createClass.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("class missing requested constructor");
        }
        this._createClass = createClass;
        if (argTypes != null) {
            this._argTypes = new Class[argTypes.length];
            System.arraycopy(argTypes, 0, this._argTypes, 0, argTypes.length);
        }
        if (argValues != null) {
            this._argValues = new Object[argValues.length];
            System.arraycopy(argValues, 0, this._argValues, 0, argValues.length);
        }
    }

    public Class getCreateClass() {
        return this._createClass;
    }

    public Class[] getCreateArgTypes() {
        Class[] copy = new Class[this._argTypes.length];
        System.arraycopy(this._argTypes, 0, copy, 0, this._argTypes.length);
        return copy;
    }

    public Object[] getCreateArgValues() {
        Object[] copy = new Object[this._argValues.length];
        System.arraycopy(this._argValues, 0, copy, 0, this._argValues.length);
        return copy;
    }

    protected LayoutItem createNewItem() {
        LayoutItem created = null;
        if (this._construct == null) {
            return null;
        }
        Object[] argVals = this._argValues == null ? new Object[]{} : this._argValues;
        try {
            created = (LayoutItem)this._construct.newInstance(argVals);
        }
        catch (InstantiationException ins) {
            return null;
        }
        catch (IllegalAccessException acc) {
            return null;
        }
        catch (InvocationTargetException ite) {
            return null;
        }
        return created;
    }
}

