/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.geom;

import java.awt.Rectangle;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;

public abstract class Line2D
implements Cloneable {
    protected Line2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract double getX2();

    public abstract double getY2();

    public abstract void setLine(double var1, double var3, double var5, double var7);

    public abstract Rectangle2D getBounds2D();

    public void setLine(Point2D p1, Point2D p2) {
        this.setLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setLine(Line2D l) {
        this.setLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    public boolean colinear(double x, double y) {
        return (x - this.getX1()) * (this.getY2() - this.getY1()) == (y - this.getY1()) * (this.getX2() - this.getX1());
    }

    public boolean colinear(Point2D p) {
        return this.colinear(p.getX(), p.getY());
    }

    public static int relativeCCW(double x1, double y1, double x2, double y2, double px, double py) {
        double ccw = (px -= x1) * (y2 -= y1) - (py -= y1) * (x2 -= x1);
        if (ccw == 0.0 && (ccw = px * x2 + py * y2) > 0.0 && (ccw = (px -= x2) * x2 + (py -= y2) * y2) < 0.0) {
            ccw = 0.0;
        }
        return ccw < 0.0 ? -1 : (ccw > 0.0 ? 1 : 0);
    }

    public int relativeCCW(double x, double y) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), x, y);
    }

    public int relativeCCW(Point2D p) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public static boolean linesIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        return Line2D.relativeCCW(x1, y1, x2, y2, x3, y3) * Line2D.relativeCCW(x1, y1, x2, y2, x4, y4) <= 0 && Line2D.relativeCCW(x3, y3, x4, y4, x1, y1) * Line2D.relativeCCW(x3, y3, x4, y4, x2, y2) <= 0;
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        return Line2D.linesIntersect(x1, y1, x2, y2, this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public boolean intersectsLine(Line2D l) {
        return Line2D.linesIntersect(l.getX1(), l.getY1(), l.getX2(), l.getY2(), this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public static double ptSegDistSq(double x0, double y0, double x1, double y1, double px, double py) {
        double dotprod = (px -= x0) * (x1 -= x0) + (py -= y0) * (y1 -= y0);
        double projlenSq = dotprod <= 0.0 ? 0.0 : ((dotprod = (px = x1 - px) * x1 + (py = y1 - py) * y1) <= 0.0 ? 0.0 : dotprod * dotprod / (x1 * x1 + y1 * y1));
        return px * px + py * py - projlenSq;
    }

    public static double ptSegDist(double x0, double y0, double x1, double y1, double px, double py) {
        return Math.sqrt(Line2D.ptSegDistSq(x0, y0, x1, y1, px, py));
    }

    public boolean contains(double x, double y) {
        double y2;
        double x2;
        double x1 = this.getX1();
        if (x1 < (x2 = this.getX2()) ? x < x1 || x > x2 : x < x2 || x > x1) {
            return false;
        }
        double y1 = this.getY1();
        if (y1 < (y2 = this.getY2()) ? y < y1 || y > y2 : y < y2 || y > y1) {
            return false;
        }
        return this.colinear(x, y);
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.intersects(new Rectangle2D.Double(x, y, w, h));
    }

    public boolean intersects(Rectangle2D r) {
        return r.intersectsLine(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public boolean contains(Rectangle2D r) {
        return false;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static class Double
    extends Line2D {
        private double x1;
        private double y1;
        private double x2;
        private double y2;

        public Double() {
        }

        public Double(double x1, double y1, double x2, double y2) {
            this.setLine(x1, y1, x2, y2);
        }

        public Double(Point2D p1, Point2D p2) {
            this.setLine(p1, p2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            double h;
            double y;
            double w;
            double x;
            if (this.x1 < this.x2) {
                x = this.x1;
                w = this.x2 - this.x1;
            } else {
                x = this.x2;
                w = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                y = this.y1;
                h = this.y2 - this.y1;
            } else {
                y = this.y2;
                h = this.y1 - this.y2;
            }
            return new Rectangle2D.Double(x, y, w, h);
        }
    }

    public static class Float
    extends Line2D {
        private float x1;
        private float y1;
        private float x2;
        private float y2;

        public Float() {
        }

        public Float(float x1, float y1, float x2, float y2) {
            this.setLine(x1, y1, x2, y2);
        }

        public Float(Point2D p1, Point2D p2) {
            this.setLine(p1, p2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }

        public Rectangle2D getBounds2D() {
            float h;
            float y;
            float w;
            float x;
            if (this.x1 < this.x2) {
                x = this.x1;
                w = this.x2 - this.x1;
            } else {
                x = this.x2;
                w = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                y = this.y1;
                h = this.y2 - this.y1;
            } else {
                y = this.y2;
                h = this.y1 - this.y2;
            }
            return new Rectangle2D.Float(x, y, w, h);
        }
    }
}

